/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import jeus.security.util.Constants;
import jeus.security.util.DBRepositoryTable;

public class ResourcePermissionTable
extends DBRepositoryTable {
    String resourcePermissionId;
    String resource;
    String actions;
    String classname;
    boolean excluded;
    boolean unchecked;

    public ResourcePermissionTable(String vendor) {
        this.table = "jeus_resource_permission";
        this.columns = new String[]{"resourcepermissionid", "res", "actions", "classname", "excluded", "unchecked"};
        this.columnsType = new String[]{"varchar2(30)", "varchar2(30)", "varchar2(100)", "varchar2(100)", "varchar2(5)", "varchar2(5)"};
        this.otherColumnsType = new String[]{"varchar(30)", "varchar(30)", "varchar(100)", "varchar(100)", "varchar(5)", "varchar(5)"};
        this.whereColumns = new String[]{"resourcepermissionid"};
        this.primaryKeyColumns = new String[]{"resourcepermissionid", "res"};
        super.initSQLBuilder(vendor);
    }

    public ResourcePermissionTable() {
    }

    public String getResourcePermissionId() {
        if (this.resourcePermissionId == null) {
            return "default";
        }
        return this.resourcePermissionId;
    }

    public void setResourcePermissionId(String resourcePermissionId) {
        this.resourcePermissionId = resourcePermissionId;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public String getClassname() {
        if (this.classname == null) {
            return Constants.DEFAULT_RR_PERMISSION_CLASSNAME;
        }
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    public boolean isUnchecked() {
        return this.unchecked;
    }

    public void setUnchecked(boolean unchecked) {
        this.unchecked = unchecked;
    }

    public ResourcePermissionTable getObject(ResultSet rs) throws SQLException {
        if (rs != null) {
            ResourcePermissionTable obj = new ResourcePermissionTable();
            obj.setResourcePermissionId(rs.getString(this.columns[0]));
            obj.setResource(rs.getString(this.columns[1]));
            obj.setActions(rs.getString(this.columns[2]));
            obj.setClassname(rs.getString(this.columns[3]));
            obj.setExcluded(Boolean.valueOf(rs.getString(this.columns[4])));
            obj.setUnchecked(Boolean.valueOf(rs.getString(this.columns[5])));
            return obj;
        }
        return null;
    }

    public String execInsertQuery() {
        StringBuffer query = new StringBuffer("insert into " + this.table + " values(");
        query.append(this.convertNull(this.getResourcePermissionId()) + ", ");
        query.append(this.convertNull(this.getResource()) + ", ");
        query.append(this.convertNull(this.getActions()) + ", ");
        query.append(this.convertNull(this.getClassname()) + ", ");
        query.append(this.convertNull(String.valueOf(this.isExcluded())) + ", ");
        query.append(this.convertNull(String.valueOf(this.isUnchecked())) + ")");
        return query.toString();
    }

    public String execUpdateQuery() {
        StringBuffer query = new StringBuffer("update " + this.table + " set ");
        query.append("res = " + this.convertNull(this.getResource()) + ", ");
        query.append("actions = " + this.convertNull(this.getActions()) + ", ");
        query.append("classname = " + this.convertNull(this.getClassname()) + ", ");
        query.append("excluded = " + this.convertNull(String.valueOf(this.isExcluded())) + ", ");
        query.append("unchecked = " + this.convertNull(String.valueOf(this.isUnchecked())));
        query.append(" where resourcepermissionid = " + this.convertNull(this.getResourcePermissionId()));
        return query.toString();
    }

    protected void initQuery() {
        this.list.add("insert into " + this.table + " values('0', 'jeus.*', '*', 'jeus.security.resource.ResourcePermission', 'false', 'false')");
    }
}

