/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.callback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import jeus.security.impl.callback.SystemPropertyCallbackHandler;
import jeus.security.util.SecurePasswordReader;

public class CommandLineCallbackHandler
extends SystemPropertyCallbackHandler {
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        super.handle(callbacks);
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                if (nc.getName() != null) continue;
                System.out.print(nc.getPrompt());
                System.out.flush();
                nc.setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                if (pc.getPassword() != null) continue;
                System.out.print(pc.getPrompt());
                System.out.flush();
                if (pc.isEchoOn()) {
                    pc.setPassword(new BufferedReader(new InputStreamReader(System.in)).readLine().toCharArray());
                    continue;
                }
                pc.setPassword(this.readPassword());
                continue;
            }
            if (callbacks[i] instanceof TextInputCallback) {
                TextInputCallback tic = (TextInputCallback)callbacks[i];
                System.out.print(tic.getPrompt());
                System.out.flush();
                tic.setText(new BufferedReader(new InputStreamReader(System.in)).readLine());
                continue;
            }
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 2: {
                        System.out.print("[ERROR] ");
                        break;
                    }
                    case 1: {
                        System.out.print("[WARNING] ");
                        break;
                    }
                    case 0: {
                        System.out.print("[INFORMATION] ");
                    }
                }
                System.out.println(toc.getMessage());
                System.out.flush();
                continue;
            }
            if (callbacks[i] instanceof ChoiceCallback) {
                ChoiceCallback cc = (ChoiceCallback)callbacks[i];
                for (int j = 0; j < cc.getChoices().length; ++j) {
                    String choice = cc.getChoices()[j];
                    System.out.println(j + 1 + ". " + choice);
                }
                System.out.println(cc.getPrompt());
                System.out.flush();
                String answer = new BufferedReader(new InputStreamReader(System.in)).readLine();
                StringTokenizer st = new StringTokenizer(answer, " ");
                int[] indexes = new int[st.countTokens()];
                int j = 0;
                while (st.hasMoreTokens()) {
                    String num = st.nextToken();
                    int index = Integer.parseInt(num) - 1;
                    if (cc.allowMultipleSelections()) {
                        indexes[j] = index;
                        ++j;
                        continue;
                    }
                    cc.setSelectedIndex(index);
                    return;
                }
                cc.setSelectedIndexes(indexes);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unhandled Callback");
        }
    }

    private char[] readPassword() throws IOException {
        return SecurePasswordReader.readPasswordSecurely();
    }
}

