/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.callback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import jeus.security.base.Subject;

public class JAASUsernamePasswordCallbackHandler
implements CallbackHandler {
    private String username;
    private String password;
    private boolean trusted;
    private String domain;
    private Subject subject;

    public JAASUsernamePasswordCallbackHandler() {
    }

    public JAASUsernamePasswordCallbackHandler(String username, String password) {
        this.domain = "SYSTEM_DOMAIN";
        this.username = username;
        this.password = password;
        this.trusted = false;
    }

    public JAASUsernamePasswordCallbackHandler(String domain, String username, String password) {
        if (domain == null) {
            domain = "SYSTEM_DOMAIN";
        } else {
            this.domain = domain;
        }
        this.username = username;
        this.password = password;
        this.trusted = false;
    }

    public JAASUsernamePasswordCallbackHandler(String domain, String username, String password, boolean trusted) {
        if (domain == null) {
            domain = "SYSTEM_DOMAIN";
        } else {
            this.domain = domain;
        }
        this.username = username;
        this.password = password;
        this.trusted = trusted;
    }

    public void setSecurityInfo(String domain, Subject subject, Boolean trusted) {
        if (domain == null) {
            domain = "SYSTEM_DOMAIN";
        } else {
            this.domain = domain;
        }
        this.subject = subject;
        this.username = subject.getPrincipal().getName();
        this.password = subject.getPassword();
        this.trusted = trusted;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 0: {
                        System.out.println(toc.getMessage());
                        break;
                    }
                    case 2: {
                        System.out.println("ERROR: " + toc.getMessage());
                        break;
                    }
                    case 1: {
                        System.out.println("WARNING: " + toc.getMessage());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported message type: " + toc.getMessageType());
                    }
                }
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                if (this.username == null) {
                    System.out.print(nc.getPrompt());
                    nc.setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
                    continue;
                }
                nc.setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                if (this.password == null) {
                    System.out.print(pc.getPrompt());
                    pc.setPassword(this.readPassword(System.in));
                    continue;
                }
                pc.setPassword(this.password.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof ConfirmationCallback) {
                ConfirmationCallback cc = (ConfirmationCallback)callbacks[i];
                if (this.trusted) {
                    cc.setSelectedIndex(0);
                    continue;
                }
                cc.setSelectedIndex(1);
                continue;
            }
            if (callbacks[i] instanceof TextInputCallback) {
                TextInputCallback tic = (TextInputCallback)callbacks[i];
                tic.setText(this.domain);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    private char[] readPassword(InputStream in) throws IOException {
        char[] lineBuffer;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }
}

