/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.callback;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import jeus.security.base.Subject;

public class UsernamePasswordCallbackHandler
implements CallbackHandler {
    private transient String username;
    private transient char[] password;
    private transient Object credential;

    public UsernamePasswordCallbackHandler() {
    }

    public UsernamePasswordCallbackHandler(String username, char[] password) {
        this.username = username;
        this.password = password;
        this.credential = password;
    }

    public UsernamePasswordCallbackHandler(String username, Object credential) {
        this.username = username;
        this.credential = credential;
    }

    public void setSecurityInfo(String username, Object credential) {
        this.username = username;
        this.credential = credential;
    }

    public void setSecurityInfo(String domain, Subject subject, Boolean trusted) {
        this.username = subject.getPrincipal().getName();
        char[] tmpPassword = subject.getPassword().toCharArray();
        this.password = new char[tmpPassword.length];
        System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                NameCallback nc = (NameCallback)c;
                nc.setName(this.username);
                continue;
            }
            if (c instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)c;
                pc.setPassword(this.password);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public Object getCredential() {
        return this.credential;
    }

    public void setCredential(Object credential) {
        this.credential = credential;
    }
}

