/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.installer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.management.ObjectName;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.LoggerUtil;
import jeus.security.util.MessageDigestUtil;
import jeus.util.EnvironmentCall;
import jeus.util.JeusBootstrapPropertyValues;

public class KeyStoreManagerService
extends Service {
    protected KeyStore keyStore;
    private KeyManagerFactory keyMgr;
    private String keyStoreType = "JKS";
    private URL keyStoreURL;
    protected char[] keyStorePassword;
    private char[] keyPassword;
    private SecretKey cipherKey;
    private String algorithm = "PBEWithMD5AndDES";
    private String keyPasswordCmdType;
    private String keyPasswordCmd;
    private byte[] salt = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
    private int iterationCount = 103;
    private AlgorithmParameterSpec cipherSpec;
    protected KeyStore trustStore;
    private String trustStoreType = "JKS";
    private char[] trustStorePassword;
    private URL trustStoreURL;
    private TrustManagerFactory trustMgr;

    public Class getType() {
        return KeyStoreManagerService.class;
    }

    private char[] decryptPassword(String password) {
        String onlyPassword = password;
        if (password.startsWith("{")) {
            int endIdx = password.indexOf("}");
            try {
                this.algorithm = password.substring(1, endIdx);
                if (EncryptionUtil.checkAlgorithm(this.algorithm)) {
                    onlyPassword = password.substring(endIdx + 1);
                }
            }
            catch (StringIndexOutOfBoundsException se) {
                // empty catch block
            }
        }
        return onlyPassword.toCharArray();
    }

    protected void doCreate() throws ServiceException, SecurityException {
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    public KeyStore doGetKeyStore() throws SecurityException {
        return this.keyStore;
    }

    public KeyManagerFactory getKeyManagerFactory() throws SecurityException {
        return this.keyMgr;
    }

    public KeyStore doGetTrustStore() throws SecurityException {
        return this.trustStore;
    }

    public TrustManagerFactory getTrustManagerFactory() throws SecurityException {
        return this.trustMgr;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String type) {
        this.keyStoreType = type;
    }

    public String getKeyStoreURL() {
        String url = null;
        if (this.keyStoreURL != null) {
            url = this.keyStoreURL.toExternalForm();
        }
        return url;
    }

    public void setKeyStoreURL(String storeURL) throws IOException {
        if (storeURL == null && (storeURL = System.getProperty("jeus.ssl.keystore")) == null) {
            storeURL = System.getProperty("javax.net.ssl.keyStore");
        }
        if (storeURL == null) {
            String jeusConfigHome = EnvironmentCall.getJeusConfigHome();
            storeURL = jeusConfigHome == null ? "keystore" : jeusConfigHome + JeusBootstrapPropertyValues.fs + EnvironmentCall.getLocalVirutalName() + JeusBootstrapPropertyValues.fs + "security" + JeusBootstrapPropertyValues.fs + "keystore";
        }
        this.keyStoreURL = this.validateStoreURL(storeURL);
    }

    public void setKeyStorePass(String password) {
        if ((password == null || password.equals("")) && ((password = System.getProperty("jeus.ssl.keypass")) == null || password.equals(""))) {
            password = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (password == null) {
            password = "changeit";
        }
        this.keyStorePassword = this.decryptPassword(password);
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String type) {
        this.trustStoreType = type;
    }

    public void setTrustStorePass(String password) {
        if ((password == null || password.equals("")) && ((password = System.getProperty("jeus.ssl.trustpass", "jeustrustpass")) == null || password.equals(""))) {
            password = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (password == null) {
            password = "changeit";
        }
        this.trustStorePassword = this.decryptPassword(password);
    }

    public String getTrustStoreURL() {
        String url = null;
        if (this.trustStoreURL != null) {
            url = this.trustStoreURL.toExternalForm();
        }
        return url;
    }

    public void setTrustStoreURL(String storeURL) throws IOException {
        if (storeURL == null && (storeURL = System.getProperty("jeus.ssl.truststore")) == null) {
            storeURL = System.getProperty("javax.net.ssl.trustStore");
        }
        if (storeURL == null) {
            String jeusConfigHome = EnvironmentCall.getJeusConfigHome();
            storeURL = jeusConfigHome == null ? "truststore" : jeusConfigHome + JeusBootstrapPropertyValues.fs + EnvironmentCall.getLocalVirutalName() + JeusBootstrapPropertyValues.fs + "security" + JeusBootstrapPropertyValues.fs + "truststore";
        }
        this.trustStoreURL = this.validateStoreURL(storeURL);
    }

    public void setSalt(String salt) {
        this.salt = salt.getBytes();
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public byte[] encode(byte[] secret) throws Exception {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(1, (Key)this.cipherKey, this.cipherSpec);
        return cipher.doFinal(secret);
    }

    public byte[] decode(byte[] secret) throws Exception {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(2, (Key)this.cipherKey, this.cipherSpec);
        return cipher.doFinal(secret);
    }

    public String encode64(byte[] secret) throws Exception {
        byte[] encoding = this.encode(secret);
        return MessageDigestUtil.tob64(encoding);
    }

    public byte[] decode64(String secret) throws Exception {
        byte[] encoding = MessageDigestUtil.fromb64(secret);
        return this.decode(encoding);
    }

    public void reloadKeyAndTrustStore() throws Exception {
        this.loadKeyAndTrustStore();
    }

    private void loadKeyPassword() throws Exception {
        if (this.keyPassword == null) {
            if (this.keyPasswordCmdType != null) {
                if (this.keyPasswordCmdType.equals("EXT")) {
                    this.execPasswordCmd();
                } else if (this.keyPasswordCmdType.equals("CLASS")) {
                    this.invokePasswordClass();
                }
            } else {
                this.keyPassword = this.keyStorePassword;
            }
        }
        this.cipherSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(this.keyPassword);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        this.cipherKey = factory.generateSecret(keySpec);
    }

    private void loadKeyAndTrustStore() throws Exception {
        String algorithm;
        InputStream is;
        if (this.keyStoreURL != null) {
            this.keyStore = KeyStore.getInstance(this.keyStoreType);
            is = this.keyStoreURL.openStream();
            this.keyStore.load(is, this.keyStorePassword);
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
            this.keyMgr = KeyManagerFactory.getInstance(algorithm);
            this.keyMgr.init(this.keyStore, this.keyPassword);
        }
        if (this.trustStoreURL != null) {
            this.trustStore = KeyStore.getInstance(this.trustStoreType);
            is = this.trustStoreURL.openStream();
            this.trustStore.load(is, this.trustStorePassword);
            algorithm = TrustManagerFactory.getDefaultAlgorithm();
            this.trustMgr = TrustManagerFactory.getInstance(algorithm);
            this.trustMgr.init(this.trustStore);
        }
    }

    private void execPasswordCmd() throws Exception {
        LoggerUtil.logger.debug("Executing command: " + this.keyPasswordCmd);
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(this.keyPasswordCmd);
        InputStream stdin = p.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stdin));
        String password = reader.readLine();
        stdin.close();
        int exitCode = p.waitFor();
        LoggerUtil.logger.debug("Command exited with: " + exitCode);
        this.keyPassword = password.toCharArray();
    }

    private void invokePasswordClass() throws Exception {
        block5: {
            Object instance;
            Object[] args;
            Class[] sig;
            this.keyPassword = null;
            String classname = this.keyPasswordCmd;
            String ctorArg = null;
            int colon = this.keyPasswordCmd.indexOf(58);
            if (colon > 0) {
                classname = this.keyPasswordCmd.substring(0, colon);
                ctorArg = this.keyPasswordCmd.substring(colon + 1);
            }
            LoggerUtil.logger.debug("Loading class: " + classname + ", ctorArg=" + ctorArg);
            Class<?> c = Class.forName(classname);
            if (ctorArg != null) {
                sig = new Class[]{String.class};
                Constructor<?> ctor = c.getConstructor(sig);
                args = new Object[]{ctorArg};
                instance = ctor.newInstance(args);
            } else {
                instance = c.newInstance();
            }
            try {
                LoggerUtil.logger.debug("Checking for toCharArray");
                sig = new Class[]{};
                Method toCharArray = c.getMethod("toCharArray", sig);
                args = new Object[]{};
                LoggerUtil.logger.debug("Invoking toCharArray");
                this.keyPassword = (char[])toCharArray.invoke(instance, args);
            }
            catch (NoSuchMethodException e) {
                LoggerUtil.logger.debug("No toCharArray found, invoking toString");
                String tmp = instance.toString();
                if (tmp == null) break block5;
                this.keyPassword = tmp.toCharArray();
            }
        }
    }

    private URL validateStoreURL(String storeURL) throws IOException {
        File tst;
        URL url = null;
        try {
            url = new URL(storeURL);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null && (tst = new File(storeURL)).exists()) {
            url = tst.toURL();
        }
        if (url == null) {
            String msg = "Failed to find url=" + storeURL + " as a URL, file or resource";
            throw new MalformedURLException(msg);
        }
        return url;
    }
}

