/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.installer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import jeus.security.base.Domain;
import jeus.security.base.Service;
import jeus.security.impl.login.JeusSecurityConfiguration;
import jeus.security.resource.CacheInfo;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.Constants;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.NameAndPathUtil;
import jeus.util.EnvironmentCall;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.xml.binding.jeusDD.AuditType;
import jeus.xml.binding.jeusDD.AuthenticationType;
import jeus.xml.binding.jeusDD.AuthorizationType;
import jeus.xml.binding.jeusDD.CacheConfigType;
import jeus.xml.binding.jeusDD.ConfigFileType;
import jeus.xml.binding.jeusDD.CredentialMappingType;
import jeus.xml.binding.jeusDD.CredentialVerificationType;
import jeus.xml.binding.jeusDD.CustomPropertyType;
import jeus.xml.binding.jeusDD.DatabaseRepositoryType;
import jeus.xml.binding.jeusDD.DbdriverConfigType;
import jeus.xml.binding.jeusDD.DefaultAuditServiceType;
import jeus.xml.binding.jeusDD.DefaultCredentialMappingServiceType;
import jeus.xml.binding.jeusDD.DefaultCredentialVerificationServiceType;
import jeus.xml.binding.jeusDD.DefaultIdentityAssertionType;
import jeus.xml.binding.jeusDD.DefaultUserMapperType;
import jeus.xml.binding.jeusDD.IdentityAssertionType;
import jeus.xml.binding.jeusDD.JaasLoginConfigType;
import jeus.xml.binding.jeusDD.KeystoreConfigType;
import jeus.xml.binding.jeusDD.LoginServiceType;
import jeus.xml.binding.jeusDD.RepositoryServiceType;
import jeus.xml.binding.jeusDD.SecurityDomainType;
import jeus.xml.binding.jeusDD.SecurityServicePropertyType;
import jeus.xml.binding.jeusDD.SecurityServiceType;
import jeus.xml.binding.jeusDD.SubjectValidationType;
import jeus.xml.binding.jeusDD.X509CredentialMappingType;
import jeus.xml.binding.jeusDD.X509IdentityAssertionType;
import jeus.xml.binding.jeusDD.XmlFileRepositoryType;

public class XMLSecurityConverterFromJeusDD {
    public Domain createDomain(Map domainsInfoMap, String domainName, String description) throws Exception {
        if (domainsInfoMap == null || domainName == null) {
            return null;
        }
        SecurityDomainType securityDomainType = (SecurityDomainType)domainsInfoMap.get(domainName);
        if (securityDomainType == null) {
            return null;
        }
        Domain domain = new Domain(domainName, description);
        ArrayList<Service> servicesList = new ArrayList<Service>();
        if (securityDomainType.isSetCustomService()) {
            int min = 0;
            int max = 0;
            long timeout = -1L;
            CacheInfo cacheInfo = null;
            if (securityDomainType.isSetCacheConfig()) {
                CacheConfigType cacheConfig = securityDomainType.getCacheConfig();
                if (cacheConfig.isSetMin()) {
                    min = cacheConfig.getMax();
                }
                if (cacheConfig.isSetMax()) {
                    max = cacheConfig.getMax();
                }
                if (cacheConfig.isSetTimeout()) {
                    timeout = cacheConfig.getTimeout();
                }
                cacheInfo = new CacheInfo(min, max, timeout);
            }
            if (cacheInfo != null) {
                domain.setCacheInfo(cacheInfo);
            }
            char[] keypassword = new char[]{};
            if (securityDomainType.isSetKeystoreConfig()) {
                KeyStore truststore;
                char[] password;
                String path;
                KeystoreConfigType keystoreConfig = securityDomainType.getKeystoreConfig();
                if (keystoreConfig.isSetKeystorePath()) {
                    KeyStore keystore;
                    path = keystoreConfig.getKeystorePath();
                    password = keystoreConfig.isSetKeystorePassword() ? this.decryptPassword(keystoreConfig.getKeystorePassword()) : this.setKeyStorePass(null);
                    if (keystoreConfig.isSetKeystoreKeypassword()) {
                        keypassword = this.decryptPassword(keystoreConfig.getKeystoreKeypassword());
                    }
                    if ((keystore = this.loadKeyStore(path, password, keypassword)) != null) {
                        domain.setKeyStore(keystore);
                        domain.setKeyStorePass(password);
                        domain.setKeyStorePath(path);
                        domain.setKeyStoreKeyPass(keypassword);
                        if (keystoreConfig.isSetKeystoreAlias()) {
                            domain.setKeyStoreAlias(keystoreConfig.getKeystoreAlias());
                        }
                    }
                }
                if (keystoreConfig.isSetTruststorePath() && (truststore = this.loadTrustStore(path = keystoreConfig.getTruststorePath(), password = keystoreConfig.isSetTruststorePassword() ? this.decryptPassword(keystoreConfig.getTruststorePassword()) : this.setTrustStorePass(null))) != null) {
                    domain.setTrustStore(truststore);
                    domain.setTrustStorePass(password);
                    domain.setTrustStorePath(path);
                }
            }
            servicesList.add(this.getService(Constants.DEFAULT_USER_TO_CERT_MAPPING_SERVICE_CLASSNAME));
            for (int i = 0; i < servicesList.size(); ++i) {
                Service service = (Service)servicesList.get(i);
                domain.addService(service);
            }
            domain = this.getDomain(domain, securityDomainType.getCustomService());
        } else {
            SecurityServiceType sst;
            SecurityServiceType sst2;
            DbdriverConfigType dbdriverConfig;
            DatabaseRepositoryType databaseRepository;
            ConfigFileType configFile;
            String fileName;
            String filePath;
            Service s;
            XmlFileRepositoryType xmlRepository;
            RepositoryServiceType repositoryService;
            int min = 0;
            int max = 0;
            long timeout = -1L;
            CacheInfo cacheInfo = null;
            if (securityDomainType.isSetCacheConfig()) {
                CacheConfigType cacheConfig = securityDomainType.getCacheConfig();
                if (cacheConfig.isSetMin()) {
                    min = cacheConfig.getMax();
                }
                if (cacheConfig.isSetMax()) {
                    max = cacheConfig.getMax();
                }
                if (cacheConfig.isSetTimeout()) {
                    timeout = cacheConfig.getTimeout();
                }
                cacheInfo = new CacheInfo(min, max, timeout);
            }
            if (cacheInfo != null) {
                domain.setCacheInfo(cacheInfo);
            }
            char[] keypassword = new char[]{};
            if (securityDomainType.isSetKeystoreConfig()) {
                KeyStore truststore;
                char[] password;
                String path;
                KeystoreConfigType keystoreConfig = securityDomainType.getKeystoreConfig();
                if (keystoreConfig.isSetKeystorePath()) {
                    KeyStore keystore;
                    path = keystoreConfig.getKeystorePath();
                    password = keystoreConfig.isSetKeystorePassword() ? this.decryptPassword(keystoreConfig.getKeystorePassword()) : this.setKeyStorePass(null);
                    if (keystoreConfig.isSetKeystoreKeypassword()) {
                        keypassword = this.decryptPassword(keystoreConfig.getKeystoreKeypassword());
                    }
                    if ((keystore = this.loadKeyStore(path, password, keypassword)) != null) {
                        domain.setKeyStore(keystore);
                        domain.setKeyStorePass(password);
                        domain.setKeyStorePath(path);
                        domain.setKeyStoreKeyPass(keypassword);
                        if (keystoreConfig.isSetKeystoreAlias()) {
                            domain.setKeyStoreAlias(keystoreConfig.getKeystoreAlias());
                        }
                    }
                }
                if (keystoreConfig.isSetTruststorePath() && (truststore = this.loadTrustStore(path = keystoreConfig.getTruststorePath(), password = keystoreConfig.isSetTruststorePassword() ? this.decryptPassword(keystoreConfig.getTruststorePassword()) : this.setTrustStorePass(null))) != null) {
                    domain.setTrustStore(truststore);
                    domain.setTrustStorePass(password);
                    domain.setTrustStorePath(path);
                }
            }
            servicesList.add(this.getService(Constants.DEFAULT_USER_TO_CERT_MAPPING_SERVICE_CLASSNAME));
            if (securityDomainType.isSetAuthentication()) {
                AuthenticationType authenticationType = securityDomainType.getAuthentication();
                if (authenticationType.isSetRepositoryService()) {
                    repositoryService = authenticationType.getRepositoryService();
                    if (repositoryService.isSetXmlFileRepository()) {
                        xmlRepository = repositoryService.getXmlFileRepository();
                        s = this.getService(Constants.DEFAULT_SYSTEM_AUTHENTICATION_FILEREALM_REPOSITORY_SERVICE_CLASSNAME);
                        filePath = null;
                        fileName = null;
                        if (xmlRepository.isSetConfigFile()) {
                            configFile = xmlRepository.getConfigFile();
                            if (configFile.isSetFilepath()) {
                                filePath = NameAndPathUtil.getPathWithEndingSeparator(configFile.getFilename());
                            }
                            if (configFile.isSetFilename()) {
                                fileName = configFile.getFilename();
                            }
                        }
                        if (filePath == null) {
                            filePath = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
                        }
                        if (fileName == null) {
                            fileName = "accounts.xml";
                        }
                        s.setProperty("filename", filePath + NameAndPathUtil.getPathWithEndingSeparator(securityDomainType.getName()) + fileName);
                    } else if (repositoryService.isSetDatabaseRepository()) {
                        databaseRepository = repositoryService.getDatabaseRepository();
                        s = this.getService(Constants.DEFAULT_AUTHENTICATION_DBREALM_REPOSITORY_SERVICE_CLASSNAME);
                        if (databaseRepository.isSetDatasourceExportName()) {
                            s.setProperty("export-name", databaseRepository.getDatasourceExportName());
                        } else if (databaseRepository.isSetDbdriverConfig()) {
                            dbdriverConfig = databaseRepository.getDbdriverConfig();
                            s.setProperty("vendor", dbdriverConfig.getVendor());
                            s.setProperty("driver", dbdriverConfig.getDriver());
                            s.setProperty("url", dbdriverConfig.getUrl());
                            s.setProperty("username", dbdriverConfig.getUsername());
                            s.setProperty("password", dbdriverConfig.getPassword());
                        }
                    } else if (repositoryService.isSetCustomRepository()) {
                        sst2 = repositoryService.getCustomRepository();
                        s = this.getService(sst2);
                    } else {
                        s = this.getService(Constants.DEFAULT_SYSTEM_AUTHENTICATION_FILEREALM_REPOSITORY_SERVICE_CLASSNAME);
                    }
                } else {
                    s = this.getService(Constants.DEFAULT_SYSTEM_AUTHENTICATION_FILEREALM_REPOSITORY_SERVICE_CLASSNAME);
                }
                servicesList.add(s);
                if (authenticationType.isSetCustomAuthenticationService()) {
                    sst = authenticationType.getCustomAuthenticationService();
                    servicesList.add(this.getService(sst));
                } else {
                    servicesList.add(this.getService(Constants.DEFAULT_AUTHENTICATION_SERVICE_CLASSNAME));
                }
            } else {
                servicesList.add(this.getService(Constants.DEFAULT_AUTHENTICATION_SERVICE_CLASSNAME));
                servicesList.add(this.getService(Constants.DEFAULT_SYSTEM_AUTHENTICATION_FILEREALM_REPOSITORY_SERVICE_CLASSNAME));
            }
            if (securityDomainType.isSetAuthorization()) {
                AuthorizationType authorizationType = securityDomainType.getAuthorization();
                if (authorizationType.isSetRepositoryService()) {
                    repositoryService = authorizationType.getRepositoryService();
                    if (repositoryService.isSetXmlFileRepository()) {
                        xmlRepository = repositoryService.getXmlFileRepository();
                        s = this.getService(Constants.DEFAULT_SYSTEM_AUTHORIZATION_FILEREALM_REPOSITORY_SERVICE_CLASSNAME);
                        filePath = null;
                        fileName = null;
                        if (xmlRepository.isSetConfigFile()) {
                            configFile = xmlRepository.getConfigFile();
                            if (configFile.isSetFilepath()) {
                                filePath = NameAndPathUtil.getPathWithEndingSeparator(configFile.getFilename());
                            }
                            if (configFile.isSetFilename()) {
                                fileName = configFile.getFilename();
                            }
                        }
                        if (filePath == null) {
                            filePath = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
                        }
                        if (fileName == null) {
                            fileName = "policies.xml";
                        }
                        s.setProperty("filename", filePath + NameAndPathUtil.getPathWithEndingSeparator(securityDomainType.getName()) + fileName);
                    } else if (repositoryService.isSetDatabaseRepository()) {
                        databaseRepository = repositoryService.getDatabaseRepository();
                        s = this.getService(Constants.DEFAULT_AUTHORIZATION_DBREALM_REPOSITORY_SERVICE_CLASSNAME);
                        if (databaseRepository.isSetDatasourceExportName()) {
                            s.setProperty("export-name", databaseRepository.getDatasourceExportName());
                        } else if (databaseRepository.isSetDbdriverConfig()) {
                            dbdriverConfig = databaseRepository.getDbdriverConfig();
                            s.setProperty("vendor", dbdriverConfig.getVendor());
                            s.setProperty("driver", dbdriverConfig.getDriver());
                            s.setProperty("url", dbdriverConfig.getUrl());
                            s.setProperty("username", dbdriverConfig.getUsername());
                            s.setProperty("password", dbdriverConfig.getPassword());
                        }
                    } else if (repositoryService.isSetCustomRepository()) {
                        sst2 = repositoryService.getCustomRepository();
                        s = this.getService(sst2);
                    } else {
                        s = this.getService(Constants.DEFAULT_SYSTEM_AUTHORIZATION_FILEREALM_REPOSITORY_SERVICE_CLASSNAME);
                    }
                } else {
                    s = authorizationType.isSetJaccService() ? this.getService(Constants.DEFAULT_JACC_AUTHORIZATION_REPOSITORY_SERVICE_CLASSNAME) : this.getService(Constants.DEFAULT_SYSTEM_AUTHORIZATION_FILEREALM_REPOSITORY_SERVICE_CLASSNAME);
                }
                servicesList.add(s);
                if (authorizationType.isSetJaccService()) {
                    servicesList.add(this.getService(Constants.DEFAULT_JACC_AUTHORIZATION_SERVICE_CLASSNAME));
                } else if (authorizationType.isSetCustomAuthorizationService()) {
                    sst = authorizationType.getCustomAuthorizationService();
                    servicesList.add(this.getService(sst));
                } else {
                    servicesList.add(this.getService(Constants.DEFAULT_AUTHORIZATION_SERVICE_CLASSNAME));
                }
            } else {
                servicesList.add(this.getService(Constants.DEFAULT_AUTHORIZATION_SERVICE_CLASSNAME));
                servicesList.add(this.getService(Constants.DEFAULT_SYSTEM_AUTHORIZATION_FILEREALM_REPOSITORY_SERVICE_CLASSNAME));
            }
            if (securityDomainType.isSetLogin()) {
                LoginServiceType loginType = securityDomainType.getLogin();
                if (loginType.isSetJaasLoginConfig()) {
                    JaasLoginConfigType loginConfigType = loginType.getJaasLoginConfig();
                    s = this.getService(Constants.DEFAULT_JAAS_LOGIN_SERVICE_CLASSNAME);
                    Security.setProperty("login.configuration.provider", "jeus.security.impl.login.JeusSecurityConfiguration");
                    JeusSecurityConfiguration loginConfig = new JeusSecurityConfiguration();
                    loginConfig.loadLoginConfig(domainName, loginConfigType);
                    domain.setLoginConfig(loginConfig);
                } else if (loginType.isSetCustomLoginService()) {
                    sst = loginType.getCustomLoginService();
                    s = this.getService(sst);
                } else {
                    s = this.getService(Constants.DEFAULT_SERVER_LOGIN_SERVICE_CLASSNAME);
                }
                servicesList.add(s);
            } else {
                servicesList.add(this.getService(Constants.DEFAULT_SERVER_LOGIN_SERVICE_CLASSNAME));
            }
            if (securityDomainType.isSetIdentityAssertion()) {
                IdentityAssertionType identityAssertionType = securityDomainType.getIdentityAssertion();
                if (identityAssertionType.isSetDefaultIdentityAssertionService()) {
                    DefaultIdentityAssertionType defaultIdentityAssertionType = identityAssertionType.getDefaultIdentityAssertionService();
                    if (defaultIdentityAssertionType.isSetX509IdentityAssertion()) {
                        s = this.getService(Constants.DEFAULT_IDENTITYASSERTION_SERVICE_CLASSNAME);
                        X509IdentityAssertionType x509IdentityAssertionType = defaultIdentityAssertionType.getX509IdentityAssertion();
                        filePath = null;
                        fileName = null;
                        if (x509IdentityAssertionType.isSetConfigFile()) {
                            configFile = x509IdentityAssertionType.getConfigFile();
                            if (configFile.isSetFilepath()) {
                                filePath = NameAndPathUtil.getPathWithEndingSeparator(configFile.getFilename());
                            }
                            if (configFile.isSetFilename()) {
                                fileName = configFile.getFilename();
                            }
                        }
                        if (filePath == null) {
                            filePath = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
                        }
                        if (fileName == null) {
                            fileName = "cert-user-map.xml";
                        }
                        s.setProperty("filename", filePath + NameAndPathUtil.getPathWithEndingSeparator(securityDomainType.getName()) + fileName);
                        if (x509IdentityAssertionType.isSetDefaultUserMapper()) {
                            DefaultUserMapperType defaultUserMapperType = x509IdentityAssertionType.getDefaultUserMapper();
                            if (defaultUserMapperType.isSetCertAttrType()) {
                                s.setProperty("cert-attr-type", defaultUserMapperType.getCertAttrType());
                            }
                            if (defaultUserMapperType.isSetAttributeType()) {
                                s.setProperty("attr-key", defaultUserMapperType.getAttributeType());
                            }
                            if (defaultUserMapperType.isSetAttributeValueDelimiter()) {
                                s.setProperty("attr-value-delimiter", defaultUserMapperType.getAttributeValueDelimiter());
                            }
                        } else {
                            CustomPropertyType cpt = x509IdentityAssertionType.getCustomUserMapper();
                            if (cpt != null) {
                                for (SecurityServicePropertyType pt : cpt.getProperty()) {
                                    s.setProperty(pt.getName(), pt.getValue());
                                }
                            }
                        }
                        servicesList.add(s);
                    }
                } else {
                    sst = identityAssertionType.getCustomIdentityAssertionService();
                    servicesList.add(this.getService(sst));
                }
            }
            if (securityDomainType.isSetCredentialMapping()) {
                DefaultCredentialMappingServiceType defaultCredentialMappingServiceType;
                CredentialMappingType credentialMappingType = securityDomainType.getCredentialMapping();
                if (credentialMappingType.isSetDefaultCredentialMappingService() && (defaultCredentialMappingServiceType = credentialMappingType.getDefaultCredentialMappingService()).isSetX509CredentialMapping()) {
                    s = this.getService(Constants.DEFAULT_CREDENTIALMAPPING_SERVICE_CLASSNAME);
                    X509CredentialMappingType x509CredentialMappingServiceType = defaultCredentialMappingServiceType.getX509CredentialMapping();
                    if (x509CredentialMappingServiceType.isSetTruststorePath()) {
                        s.setProperty("truststore", x509CredentialMappingServiceType.getTruststorePath());
                    }
                    if (x509CredentialMappingServiceType.isSetTruststorePassword()) {
                        s.setProperty("truststore-password", x509CredentialMappingServiceType.getTruststorePassword());
                    }
                    servicesList.add(s);
                }
                if (credentialMappingType.isSetCustomCredentialMappingService()) {
                    List customCredentialMappingServices = credentialMappingType.getCustomCredentialMappingService();
                    for (SecurityServiceType sst3 : customCredentialMappingServices) {
                        servicesList.add(this.getService(sst3));
                    }
                }
            }
            if (securityDomainType.isSetCredentialVerification()) {
                CredentialVerificationType credentialVerificationType = securityDomainType.getCredentialVerification();
                if (credentialVerificationType.isSetDefaultCredentialVerificationService()) {
                    DefaultCredentialVerificationServiceType defaultCredentialVerifictionService = credentialVerificationType.getDefaultCredentialVerificationService();
                    s = defaultCredentialVerifictionService.isSetPasswordVerification() ? this.getService(Constants.DEFAULT_PASSWORD_VERIFICATION_SERVICE_CLASSNAME) : (defaultCredentialVerifictionService.isSetJeusCertificateVerification() ? this.getService(Constants.DEFAULT_CERTIFICATE_VERIFICATION_SERVICE_CLASSNAME) : this.getService(Constants.DEFAULT_PASSWORD_VERIFICATION_SERVICE_CLASSNAME));
                    servicesList.add(s);
                }
                if (credentialVerificationType.isSetCustomCredentialVerificationService()) {
                    List customCredentialVerificationServices = credentialVerificationType.getCustomCredentialVerificationService();
                    for (SecurityServiceType sst3 : customCredentialVerificationServices) {
                        servicesList.add(this.getService(sst3));
                    }
                }
            } else {
                s = this.getService(Constants.DEFAULT_PASSWORD_VERIFICATION_SERVICE_CLASSNAME);
                servicesList.add(s);
            }
            if (securityDomainType.isSetAudit()) {
                AuditType auditType = securityDomainType.getAudit();
                if (auditType.isSetDefaultAuditService()) {
                    DefaultAuditServiceType defaultAuditService = auditType.getDefaultAuditService();
                    s = this.getService(Constants.DEFAULT_AUDIT_SERVICE_CLASSNAME);
                    String filePath2 = null;
                    String fileName2 = null;
                    if (defaultAuditService.isSetConfigFile()) {
                        ConfigFileType configFile2 = defaultAuditService.getConfigFile();
                        if (configFile2.isSetFilepath()) {
                            filePath2 = NameAndPathUtil.getPathWithEndingSeparator(configFile2.getFilepath());
                        }
                        if (configFile2.isSetFilename()) {
                            fileName2 = configFile2.getFilename();
                        }
                    }
                    if (filePath2 == null) {
                        filePath2 = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
                    }
                    if (fileName2 == null) {
                        fileName2 = "audit.log";
                    }
                    s.setProperty("filename", filePath2 + fileName2);
                    if (defaultAuditService.isSetAuditLevel()) {
                        s.setProperty("audit.level", defaultAuditService.getAuditLevel());
                    }
                    servicesList.add(s);
                }
                if (auditType.isSetCustomAuditService()) {
                    List customAuditServices = auditType.getCustomAuditService();
                    for (SecurityServiceType sst3 : customAuditServices) {
                        servicesList.add(this.getService(sst3));
                    }
                }
            }
            if (securityDomainType.isSetSubjectValidation()) {
                SubjectValidationType subjectValidationType = securityDomainType.getSubjectValidation();
                if (subjectValidationType.isSetDefaultSubjectValidationService()) {
                    s = this.getService(Constants.DEFAULT_SUBJECT_VALIDATION_SERVICE_CLASSNAME);
                    servicesList.add(s);
                }
                if (subjectValidationType.isSetCustomSubjectValidationService()) {
                    List customSubjectValidationServices = subjectValidationType.getCustomSubjectValidationService();
                    for (SecurityServiceType sst3 : customSubjectValidationServices) {
                        servicesList.add(this.getService(sst3));
                    }
                }
            }
            for (Service service : servicesList) {
                domain.addService(service);
            }
        }
        return domain;
    }

    private Domain getDomain(Domain domain, List servicesList) throws Exception {
        if (servicesList.isEmpty()) {
            return domain;
        }
        for (SecurityServiceType sst : servicesList) {
            domain.addService(this.getService(sst));
        }
        return domain;
    }

    private Service getService(SecurityServiceType sst) throws Exception {
        String clazz = sst.getClassname();
        Service s = (Service)Class.forName(clazz).newInstance();
        for (SecurityServicePropertyType pt : sst.getProperty()) {
            String name = pt.getName();
            String value = pt.getValue();
            if (value != null) {
                s.setProperty(name, value);
                continue;
            }
            s.setProperty(name, "true");
        }
        return s;
    }

    private Service getService(String clazz) throws Exception {
        return (Service)Class.forName(clazz).newInstance();
    }

    private KeyStore loadKeyStore(String path, char[] password, char[] keyPassword) throws Exception {
        URL keystoreURL = this.setKeyStoreURL(path);
        if (keystoreURL != null) {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            InputStream is = keystoreURL.openStream();
            keyStore.load(is, password);
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyMgr = KeyManagerFactory.getInstance(algorithm);
            keyMgr.init(keyStore, keyPassword);
            return keyStore;
        }
        return null;
    }

    private KeyStore loadTrustStore(String path, char[] password) throws Exception {
        URL trustStoreURL = this.setKeyStoreURL(path);
        if (trustStoreURL != null) {
            KeyStore trustStore = KeyStore.getInstance("JKS");
            InputStream is = trustStoreURL.openStream();
            trustStore.load(is, password);
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustMgr = TrustManagerFactory.getInstance(algorithm);
            trustMgr.init(trustStore);
            return trustStore;
        }
        return null;
    }

    private URL setKeyStoreURL(String storeURL) throws IOException {
        if (storeURL == null && (storeURL = System.getProperty("jeus.ssl.keystore")) == null) {
            storeURL = System.getProperty("javax.net.ssl.keyStore");
        }
        if (storeURL == null) {
            String jeusConfigHome = EnvironmentCall.getJeusConfigHome();
            storeURL = jeusConfigHome == null ? "keystore" : jeusConfigHome + JeusBootstrapPropertyValues.fs + EnvironmentCall.getLocalVirutalName() + JeusBootstrapPropertyValues.fs + "security" + JeusBootstrapPropertyValues.fs + "keystore";
        }
        return this.validateStoreURL(storeURL);
    }

    private URL setTrustStoreURL(String storeURL) throws IOException {
        if (storeURL == null && (storeURL = System.getProperty("jeus.ssl.truststore")) == null) {
            storeURL = System.getProperty("javax.net.ssl.trustStore");
        }
        if (storeURL == null) {
            String jeusConfigHome = EnvironmentCall.getJeusConfigHome();
            storeURL = jeusConfigHome == null ? "truststore" : jeusConfigHome + JeusBootstrapPropertyValues.fs + EnvironmentCall.getLocalVirutalName() + JeusBootstrapPropertyValues.fs + "security" + JeusBootstrapPropertyValues.fs + "truststore";
        }
        return this.validateStoreURL(storeURL);
    }

    private URL validateStoreURL(String storeURL) throws IOException {
        File tst;
        URL url = null;
        try {
            url = new URL(storeURL);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null && (tst = new File(storeURL)).exists()) {
            url = tst.toURL();
        }
        if (url == null) {
            String msg = "Failed to find url=" + storeURL + " as a URL, file or resource";
            throw new MalformedURLException(msg);
        }
        return url;
    }

    private char[] decryptPassword(String password) {
        String onlyPassword = password;
        if (password.startsWith("{")) {
            int endIdx = password.indexOf("}");
            try {
                String algorithm = password.substring(1, endIdx);
                if (EncryptionUtil.checkAlgorithm(algorithm)) {
                    onlyPassword = password.substring(endIdx + 1);
                }
            }
            catch (StringIndexOutOfBoundsException se) {
                // empty catch block
            }
        }
        return onlyPassword.toCharArray();
    }

    private char[] setKeyStorePass(String password) {
        if ((password == null || password.equals("")) && ((password = System.getProperty("jeus.ssl.keypass")) == null || password.equals(""))) {
            password = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (password == null) {
            password = "changeit";
        }
        return this.decryptPassword(password);
    }

    private char[] setTrustStorePass(String password) {
        if ((password == null || password.equals("")) && ((password = System.getProperty("jeus.ssl.trustpass", "jeustrustpass")) == null || password.equals(""))) {
            password = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (password == null) {
            password = "changeit";
        }
        return this.decryptPassword(password);
    }
}

