/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.jacc;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import javax.security.jacc.PolicyContext;
import jeus.security.impl.jacc.JACCPolicyConfigurationFactoryImpl;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.PolicyContainer;

public class JACCPolicyWrapper
extends Policy {
    private Policy defaultPolicy;
    PolicyContainer policyContainer;
    static JACCPolicyWrapper theWrapper;

    public JACCPolicyWrapper() {
        theWrapper = this;
        this.defaultPolicy = Policy.getPolicy();
        this.policyContainer = new PolicyContainer();
        if (this.defaultPolicy == null) {
            System.err.println("Error in JACCPolicyWrapper constructor: no default policy found - will not delegate permission checks");
        }
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        if (this.defaultPolicy != null) {
            return this.defaultPolicy.getPermissions(codeSource);
        }
        return null;
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (this.defaultPolicy != null) {
            return this.defaultPolicy.getPermissions(domain);
        }
        return null;
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        String policyContextId = PolicyContext.getContextID();
        if (policyContextId != null) {
            try {
                if (!JACCPolicyConfigurationFactoryImpl.theFactory.inService(policyContextId)) {
                    return false;
                }
                Principal[] princes = domain.getPrincipals();
                return PolicyContainer.authorize(policyContextId, this.policyContainer.getPolicy(policyContextId), permission, princes, this.defaultPolicy, domain);
            }
            catch (Exception e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._20_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._20_LEVEL, JeusMessage_Security._20, (Throwable)e);
                }
                return false;
            }
        }
        if (this.defaultPolicy != null) {
            return this.defaultPolicy.implies(domain, permission);
        }
        return false;
    }

    public void refresh() {
        if (this.defaultPolicy != null) {
            this.defaultPolicy.refresh();
        }
    }
}

