/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.lockout;

import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;
import jeus.security.base.Event;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.LockFactory;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.EventHandlingService;
import jeus.security.spi.LoginService;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;

public class SubjectLockoutService
extends EventHandlingService {
    private Map failedAttempts;
    private static LockFactory lf = new LockFactory();
    private int maxAttempts = 3;

    protected void doCreate() throws ServiceException, SecurityException {
        this.failedAttempts = new Hashtable();
        String max = this.getProperty("maxattempts");
        if (max != null) {
            this.maxAttempts = Integer.parseInt(max);
        }
    }

    protected void doDestroy() {
        this.failedAttempts.clear();
        this.failedAttempts = null;
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doHandleEvent(Event event) {
        Subject s = (Subject)event.get("subject");
        if (s == null || s.getPrincipal() == null) return;
        Integer i = (Integer)this.failedAttempts.get(s.getPrincipal());
        i = i != null ? new Integer(i + 1) : new Integer(1);
        if (i >= this.maxAttempts) {
            Subject sub = new Subject(s.getPrincipal());
            sub.getCredentialFactories().add(lf);
            boolean loggedIn = false;
            try {
                LoginService.loginCodeSubject();
                loggedIn = true;
                AuthenticationRepositoryService.addSubject(sub);
                this.failedAttempts.remove(s.getPrincipal());
                return;
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._21_LEVEL)) return;
                LoggerUtil.logger.log(JeusMessage_Security._21_LEVEL, JeusMessage_Security._21, (Throwable)e);
                return;
            }
            finally {
                try {
                    if (loggedIn) {
                        LoginService.logout();
                    }
                }
                catch (Exception e) {}
            }
        }
        this.failedAttempts.put(s.getPrincipal(), i);
    }

    protected boolean doHandlesEvent(Event event) {
        return event.getType().endsWith("authentication.failed");
    }
}

