/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.login;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import jeus.util.logging.JeusLogger;

public class LdapAuthenticator {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.security.loginmodule");
    private String contextFactory;
    private String providerUrl;
    private String connectionUsername;
    private String connectionPassword;
    private String userBase;
    private MessageFormat userSearchMapping;
    private String userPasswordAttr;
    private String userRoleAttr;
    private String roleBase;
    private String roleNameAttr;
    private MessageFormat roleSearchMapping;
    private DirContext context;
    ArrayList roles = new ArrayList();

    public LdapAuthenticator() {
    }

    public LdapAuthenticator(String providerUrl, String principal, String credential) {
        this.providerUrl = providerUrl;
        this.connectionUsername = principal;
        this.connectionPassword = credential;
    }

    public boolean authenticate(String username, String password) throws Exception {
        boolean succeeded;
        block9: {
            DirContext context = this.openContext();
            succeeded = false;
            try {
                Attributes attrs;
                String filter = this.userSearchMapping.format(new String[]{username});
                SearchControls constraints = this.createSearchConstrols();
                logger.fine("LdapAuthenticator : userBase = " + this.userBase + ", filter = " + filter);
                NamingEnumeration<SearchResult> results = context.search(this.userBase, filter, constraints);
                if (results == null || !results.hasMore()) {
                    logger.warning("Authentication failed. Can not find user " + username + " in the LDAP");
                    return false;
                }
                SearchResult result = results.next();
                if (results.hasMore()) {
                    // empty if block
                }
                if ((attrs = result.getAttributes()) == null) {
                    logger.warning("Authentication failed. Can not get any attribyte in the LDAP, entry name = " + result.getName());
                    return false;
                }
                if (this.userRoleAttr != null) {
                    this.addAttributeValues(attrs, this.userRoleAttr, this.roles);
                }
                String dn = null;
                if (this.userPasswordAttr == null) {
                    dn = this.getUserDN(context, this.userBase, result.getName());
                    succeeded = password == null || password.equals("no_pass") ? false : this.bindAsUser(context, dn, password);
                    if (!succeeded) {
                        logger.warning("Authentication failed. Can not bind LDAP as DN " + dn);
                    }
                }
                if (this.roleBase != null && this.roleNameAttr != null && this.roleSearchMapping != null) {
                    this.getRoles(context, dn, username, this.roles);
                }
            }
            catch (NamingException e) {
                if (context == null) break block9;
                this.closeContext();
            }
        }
        return succeeded;
    }

    public ArrayList getRoles() {
        return this.roles;
    }

    private ArrayList addAttributeValues(Attributes attrs, String attrId, ArrayList values) throws NamingException {
        Attribute attr;
        if (attrId == null || attrs == null) {
            return values;
        }
        if (values == null) {
            values = new ArrayList<String>();
        }
        if ((attr = attrs.get(attrId)) == null) {
            return values;
        }
        NamingEnumeration<?> e = attr.getAll();
        while (e.hasMore()) {
            String value = (String)e.next();
            values.add(value);
        }
        return values;
    }

    private ArrayList getRoles(DirContext context, String dn, String username, ArrayList roles) throws NamingException {
        String filter = this.roleSearchMapping.format(new String[]{this.doRFC2254Encoding(dn), username});
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> results = context.search(this.roleBase, filter, constraints);
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes attrs = result.getAttributes();
            if (attrs == null) continue;
            this.addAttributeValues(attrs, this.roleNameAttr, roles);
        }
        return roles;
    }

    private String doRFC2254Encoding(String input) {
        StringBuffer buf = new StringBuffer(input.length());
        block7: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    private String getUserDN(Context context, String userBase, String searchedName) throws NamingException {
        NameParser parser = context.getNameParser("");
        Name contextName = parser.parse(context.getNameInNamespace());
        Name baseName = parser.parse(userBase);
        Name entryName = parser.parse(searchedName);
        Name name = contextName.addAll(baseName);
        name = name.addAll(entryName);
        return name.toString();
    }

    private SearchControls createSearchConstrols() {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        ArrayList<String> attrlist = new ArrayList<String>();
        if (this.userRoleAttr != null) {
            attrlist.add(this.userRoleAttr);
        }
        if (this.userPasswordAttr != null) {
            attrlist.add(this.userPasswordAttr);
        }
        String[] attrs = new String[attrlist.size()];
        attrlist.toArray(attrs);
        constraints.setReturningAttributes(attrs);
        return constraints;
    }

    private boolean bindAsUser(DirContext context, String dn, String password) throws NamingException {
        boolean valid = false;
        context.addToEnvironment("java.naming.security.principal", dn);
        context.addToEnvironment("java.naming.security.credentials", password);
        try {
            Attributes attr = context.getAttributes("", null);
            valid = true;
        }
        catch (AuthenticationException e) {
            valid = false;
        }
        if (this.connectionUsername != null) {
            context.addToEnvironment("java.naming.security.principal", this.connectionUsername);
        } else {
            context.removeFromEnvironment("java.naming.security.principal");
        }
        if (this.connectionPassword != null) {
            context.addToEnvironment("java.naming.security.credentials", this.connectionPassword);
        } else {
            context.removeFromEnvironment("java.naming.security.credentials");
        }
        return valid;
    }

    private DirContext openContext() throws NamingException {
        if (this.context != null) {
            return this.context;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.contextFactory);
        env.put("java.naming.provider.url", this.providerUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.connectionUsername);
        env.put("java.naming.security.credentials", this.connectionPassword);
        logger.fine("LDAP connection information : initail context factory = " + this.contextFactory + ", provider url = " + this.providerUrl + ", security principal = " + this.connectionUsername);
        this.context = new InitialDirContext(env);
        return this.context;
    }

    private void closeContext() {
        try {
            this.context.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.context = null;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getConnectionUsername() {
        return this.connectionUsername;
    }

    public void setConnectionUsername(String connectionUsername) {
        this.connectionUsername = connectionUsername;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public String getRoleBase() {
        return this.roleBase;
    }

    public void setRoleBase(String roleBase) {
        this.roleBase = roleBase;
    }

    public String getRoleNameAttr() {
        return this.roleNameAttr;
    }

    public void setRoleNameAttr(String roleNameAttr) {
        this.roleNameAttr = roleNameAttr;
    }

    public MessageFormat getRoleSearchMapping() {
        return this.roleSearchMapping;
    }

    public void setRoleSearchMapping(MessageFormat roleSearchMapping) {
        this.roleSearchMapping = roleSearchMapping;
    }

    public String getUserBaseDN() {
        return this.userBase;
    }

    public void setUserBase(String userBase) {
        this.userBase = userBase;
    }

    public String getUserPasswordAttr() {
        return this.userPasswordAttr;
    }

    public void setUserPasswordAttr(String userPasswordAttr) {
        this.userPasswordAttr = userPasswordAttr;
    }

    public String getUserRoleAttr() {
        return this.userRoleAttr;
    }

    public void setUserRoleAttr(String userRoleAttr) {
        this.userRoleAttr = userRoleAttr;
    }

    public MessageFormat getUserSearchMapping() {
        return this.userSearchMapping;
    }

    public void setUserSearchMapping(MessageFormat userSearchMapping) {
        this.userSearchMapping = userSearchMapping;
    }
}

