/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.login;

import java.security.Permission;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.impl.login.ClientLoginService;
import jeus.security.resource.SystemPassword;
import jeus.security.spi.AuthenticationService;
import jeus.security.spi.AuthorizationService;
import jeus.security.spi.SubjectValidationService;

public class ServerLoginService
extends ClientLoginService {
    protected void doCreate() throws ServiceException {
        super.doCreate();
    }

    protected void doDestroy() {
        super.doDestroy();
    }

    protected void doLogin(Subject subject, boolean trusted) throws ServiceException, SecurityException {
        if (SystemPassword.checkSystemPassword(subject)) {
            SystemPassword.setSystemPassword(subject);
            this.doForceLogin(subject);
        } else {
            Subject sub = AuthenticationService.authenticate(subject, trusted);
            SubjectValidationService.checkValidity(sub);
            SystemPassword.setSystemPassword(sub);
            this.doForceLogin(sub);
        }
    }

    protected void doLogin(Subject subject, boolean trusted, String node) throws ServiceException, SecurityException {
        this.doLogin(subject, trusted, node);
    }

    protected void doCheckPermission(String contextId, Permission permission) throws ServiceException, SecurityException {
        AuthorizationService.authorize(contextId, permission, ServerLoginService.getCurrentSubject());
    }
}

