/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.network;

import java.io.IOException;
import jeus.net.NetworkControlPacket;
import jeus.net.SocketStream;
import jeus.net.impl.NodeInfo;
import jeus.security.base.Environment;
import jeus.security.impl.network.AbstractNetworkService;
import jeus.security.impl.network.SecurityConnectionListener;
import jeus.security.spi.SecurityInstaller;
import jeus.util.concurrent50.concurrent.Executor;

public class ServerSecurityConnectionListener
extends SecurityConnectionListener {
    private Executor pooledExecutor;

    public ServerSecurityConnectionListener(AbstractNetworkService networkService, Executor pooledExecutor) {
        super(networkService);
        this.pooledExecutor = pooledExecutor;
    }

    public void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        this.pooledExecutor.execute(messageProcessor);
    }

    public void connectionAllowed(SocketStream sockStream, NetworkControlPacket packet, int connectionType, Object piggybackedData) throws IOException {
        String localDomainPassword = SecurityInstaller.getGlobalPassword();
        Object[] data = (Object[])piggybackedData;
        String remotePW = (String)data[0];
        boolean authenticated = localDomainPassword.equals(remotePW);
        Environment sc = (Environment)data[1];
        if (sc.client) {
            sc.master = false;
            sc.slave = false;
            this.remoteEnv = sc;
        } else {
            if (!authenticated) {
                throw new RuntimeException("Remote domain password does not match local domain password - connection refused");
            }
            this.remoteEnv = sc;
        }
        this.remoteEnv.setNodeInfo((NodeInfo)sockStream.getSocketID());
        packet.setData((Object)SecurityInstaller.getEnvironment());
        sockStream.write((Object)packet);
    }

    public void receiveMessage(Object obj, SocketStream sockStream, Object controlInfo) {
        Object message;
        try {
            message = AbstractNetworkService.convertFromStream((byte[])obj);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Fail to read network message", e);
        }
        if (this.waitForReply) {
            this.receiveReply(message);
        } else {
            this.receiveRequest(message, sockStream);
        }
    }
}

