/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.verification;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import jeus.security.base.CredentialFactory;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.Password;
import jeus.security.spi.CredentialVerificationService;
import jeus.security.util.MD5Encoder;

public class PasswordWithMD5VerificationService
extends CredentialVerificationService {
    private static final MD5Encoder md5Encoder = new MD5Encoder();
    private static MessageDigest md5Helper = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doVerifyCredentials(Subject refSub, Subject proofSub) throws ServiceException, SecurityException {
        if (md5Helper == null) {
            try {
                md5Helper = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
        }
        CredentialFactory credFactory = null;
        Set proofCredFactorys = proofSub.getCredentialFactories();
        Iterator iter = proofCredFactorys.iterator();
        if (iter.hasNext()) {
            credFactory = (CredentialFactory)iter.next();
        }
        if (credFactory == null) {
            new SecurityException("failed to get the credential factory of proofSub(" + proofSub + ")");
        }
        String username = proofSub.getPrincipal().getName();
        String realm = credFactory.getProperty("realm");
        String nOnce = credFactory.getProperty("nonce");
        String nc = credFactory.getProperty("nc");
        String cnonce = credFactory.getProperty("cnonce");
        String qop = credFactory.getProperty("qop");
        String md5a2 = credFactory.getProperty("md5a2");
        for (Password ref : refSub.getPrivateCredentials()) {
            for (Password proof : proofSub.getPrivateCredentials()) {
                String clientDigest = proof.getPassword();
                String md5a1 = this.getDigest(username, realm, ref.getPlainPassword());
                if (md5a1 == null) continue;
                String serverDigestValue = md5a1 + ":" + nOnce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
                byte[] valueBytes = serverDigestValue.getBytes();
                String serverDigest = null;
                MessageDigest messageDigest = md5Helper;
                synchronized (messageDigest) {
                    serverDigest = md5Encoder.encode(md5Helper.digest(valueBytes));
                }
                if (!serverDigest.equals(clientDigest)) continue;
                return;
            }
        }
        throw new SecurityException();
    }

    protected boolean handles(Subject refSubject, Subject proofSubject) {
        return refSubject != null && refSubject.getPrivateCredentials(Password.class).size() > 0 && proofSubject != null && proofSubject.getPrivateCredentials(Password.class).size() > 0;
    }

    protected void doCreate() throws ServiceException, SecurityException {
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDigest(String username, String realmName, String refPassword) {
        if (md5Helper == null) {
            try {
                md5Helper = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
        }
        String digestValue = username + ":" + realmName + ":" + refPassword;
        byte[] valueBytes = digestValue.getBytes();
        byte[] digest = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            digest = md5Helper.digest(valueBytes);
        }
        return md5Encoder.encode(digest);
    }
}

