/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.util.Properties;
import jeus.security.base.CredentialFactory;
import jeus.security.base.CredentialFactoryException;
import jeus.security.resource.Password;
import jeus.security.util.Base64Coder;
import jeus.security.util.MessageDigestUtil;

public class CustomPasswordFactory
extends Properties
implements CredentialFactory {
    public CustomPasswordFactory() {
    }

    public CustomPasswordFactory(String password) {
        this.setProperty(this.getProperty("password-keyname"), Base64Coder.encode(password));
    }

    public CustomPasswordFactory(String hashAlgorithm, String encoding, String hashCharset) {
        this.setProperty("hash-algorithm", hashAlgorithm);
        this.setProperty("encoding", encoding);
        this.setProperty("hash-charset", hashCharset);
    }

    public CustomPasswordFactory(String password, String hashAlgorithm, String encoding, String hashCharset) {
        this.setProperty("hash-algorithm", hashAlgorithm);
        this.setProperty("encoding", encoding);
        this.setProperty("hash-charset", hashCharset);
        this.setPassword(password);
    }

    public String getPassword() {
        return this.getProperty(this.getProperty("password-keyname"));
    }

    public void setPassword(String password) {
        String hashAlgorithm = this.getProperty("hash-algorithm");
        if (hashAlgorithm == null || hashAlgorithm.equals("none")) {
            this.setProperty(this.getProperty("password-keyname"), Base64Coder.byteArrayToAltBase64(password.getBytes()));
        } else {
            this.setProperty(this.getProperty("password-keyname"), MessageDigestUtil.createPasswordHash(hashAlgorithm, this.getProperty("encoding"), this.getProperty("hash-charset"), password));
        }
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof CustomPasswordFactory)) {
            return false;
        }
        if (this == another) {
            return true;
        }
        return super.equals(another);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object getCredential() throws CredentialFactoryException {
        String password = this.getPassword();
        if (password == null) {
            throw new CredentialFactoryException("Error creating Password: the password property is null");
        }
        return new Password(password);
    }

    public boolean isPublicCredential() {
        return false;
    }
}

