/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jeus.security.resource.DefaultTimedEntry;
import jeus.security.resource.SecurityCache;
import jeus.security.util.TimedEntry;
import jeus.security.util.TimedLinkedHashMap;

public class DefaultCache
implements SecurityCache {
    private Map entryMap;
    private long defaultLifetime;
    private boolean threadSafe;
    private long now;
    private int min = 20;
    private int max = 50;

    public DefaultCache() {
        this(1800L, false);
    }

    public DefaultCache(long defaultLifetime) {
        this(defaultLifetime, false);
    }

    public DefaultCache(long defaultLifetime, boolean threadSafe) {
        this.defaultLifetime = defaultLifetime;
        this.threadSafe = threadSafe;
    }

    public DefaultCache(long defaultLifetime, boolean threadSafe, int min, int max) {
        this.defaultLifetime = defaultLifetime;
        this.threadSafe = threadSafe;
        this.min = min;
        this.max = max;
    }

    public DefaultCache(int min, int max, long defaultLifetime) {
        this.defaultLifetime = defaultLifetime;
        this.threadSafe = true;
        this.min = min;
        this.max = max;
    }

    public void create() {
        this.entryMap = this.threadSafe ? Collections.synchronizedMap(new TimedLinkedHashMap(this.min, 0.75f, true, this.max)) : new TimedLinkedHashMap(this.min, 0.75f, true, this.max);
        this.now = System.currentTimeMillis();
    }

    public void start() {
    }

    public void stop() {
        this.flush();
    }

    public void destroy() {
        this.entryMap.clear();
    }

    public Object get(Object key) {
        TimedEntry entry = (TimedEntry)this.entryMap.get(key);
        if (entry == null) {
            return null;
        }
        this.now = System.currentTimeMillis();
        if (!entry.isCurrent(this.now)) {
            if (!entry.refresh()) {
                entry.destroy();
                this.entryMap.remove(key);
                return null;
            }
        } else {
            entry.init(this.now);
        }
        return entry.getValue();
    }

    public Object peek(Object key) {
        TimedEntry entry = (TimedEntry)this.entryMap.get(key);
        Object value = null;
        if (entry != null) {
            value = entry.getValue();
        }
        return value;
    }

    public Object put(Object key, Object value) {
        if (this.entryMap.containsKey(key)) {
            return value;
        }
        TimedEntry entry = value instanceof TimedEntry ? (TimedEntry)value : new DefaultTimedEntry(this.defaultLifetime, value);
        entry.init(this.now);
        this.entryMap.put(key, entry);
        return null;
    }

    public void remove(Object key) {
        TimedEntry entry = (TimedEntry)this.entryMap.remove(key);
        if (entry != null) {
            entry.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map tmpMap;
        DefaultCache defaultCache = this;
        synchronized (defaultCache) {
            tmpMap = this.entryMap;
            this.entryMap = this.threadSafe ? Collections.synchronizedMap(new TimedLinkedHashMap(this.min, 0.75f, true, this.max)) : new TimedLinkedHashMap(this.min, 0.75f, true, this.max);
        }
        for (TimedEntry entry : tmpMap.values()) {
            entry.destroy();
        }
        tmpMap.clear();
    }

    public int size() {
        return this.entryMap.size();
    }

    public Collection values() {
        Vector<Object> values = new Vector<Object>(this.entryMap.size());
        for (TimedEntry entry : this.entryMap.values()) {
            values.add(entry.getValue());
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getValidKeys() {
        ArrayList validKeys = new ArrayList();
        Map map = this.entryMap;
        synchronized (map) {
            for (Map.Entry entry : this.entryMap.entrySet()) {
                TimedEntry value = (TimedEntry)entry.getValue();
                if (!value.isCurrent(this.now)) continue;
                validKeys.add(entry.getKey());
            }
        }
        return validKeys;
    }

    public void remove(String key) {
        this.entryMap.remove(key);
    }

    public boolean containsKey(String key) {
        return this.entryMap.containsKey(key);
    }

    public long getDefaultLifetime() {
        return this.defaultLifetime;
    }

    public synchronized void setDefaultLifetime(int defaultLifetime) {
        this.defaultLifetime = defaultLifetime;
    }

    public void run() {
        this.now = System.currentTimeMillis();
    }

    public long currentTimeMillis() {
        return this.now;
    }

    public TimedEntry peekEntry(Object key) {
        return (TimedEntry)this.entryMap.get(key);
    }
}

