/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jeus.security.util.EncryptionUtil;

public class Password
implements Serializable {
    static final long serialVersionUID = -4429278291333984214L;
    static final Pattern pattern = Pattern.compile("(\\{([\\w]*)\\})?([\\w]+)");
    private String algorithm;
    private String password;
    private String plainPassword;

    public static Password createPassword(String expression) throws IllegalArgumentException {
        Matcher matcher = pattern.matcher(expression);
        if (!matcher.matches() || matcher.groupCount() < 3) {
            throw new IllegalArgumentException("invalid password expression : " + expression);
        }
        String algorithm = matcher.group(2);
        String password = matcher.group(3);
        if (algorithm != null && !EncryptionUtil.checkAlgorithm(algorithm)) {
            throw new IllegalArgumentException("invalid encryption algorithm " + algorithm);
        }
        return new Password(algorithm, password);
    }

    public Password(String password) {
        this.password = password;
        this.plainPassword = password;
    }

    public Password(String algorithm, String password) {
        this.algorithm = algorithm;
        this.password = password;
        this.plainPassword = algorithm != null && !algorithm.equalsIgnoreCase("SHA") ? EncryptionUtil.decryptPassword(algorithm, password) : password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPlainPassword() {
        return this.plainPassword;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof Password)) {
            return false;
        }
        Password pw = (Password)another;
        if (pw.password == null || this.password == null) {
            return false;
        }
        return this.password.equals(pw.password);
    }

    public int hashCode() {
        if (this.password == null) {
            return 0;
        }
        return this.password.hashCode();
    }

    public synchronized boolean implies(Password password) {
        if (this.algorithm != null && this.algorithm.equalsIgnoreCase("SHA")) {
            String encodePassword = EncryptionUtil.encryptPassword(this.getAlgorithm(), password.password);
            return this.password.equals(encodePassword);
        }
        return this.plainPassword.equals(password.plainPassword);
    }

    public String toString() {
        return "{algorithm=" + this.algorithm + ", password=" + this.password + "}";
    }
}

