/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.util.Properties;
import jeus.security.base.CredentialFactory;
import jeus.security.base.CredentialFactoryException;
import jeus.security.resource.Password;

public class PasswordWithMD5Factory
extends Properties
implements CredentialFactory {
    public static final String DIGEST_PASSWORD_PROPERTY_KEY = "password";
    public static final String REALM_PROPERTY_KEY = "realm";
    public static final String NONCE_PROPERTY_KEY = "nonce";
    public static final String NC_PROPERTY_KEY = "nc";
    public static final String CNONCE_PROPERTY_KEY = "cnonce";
    public static final String QOP_PROPERTY_KEY = "qop";
    public static final String MD5A2_PROPERTY_KEY = "md5a2";

    public PasswordWithMD5Factory() {
    }

    public PasswordWithMD5Factory(String password) {
        this.setProperty(DIGEST_PASSWORD_PROPERTY_KEY, password);
    }

    public PasswordWithMD5Factory(String username, String clientDigest, String nOnce, String nc, String cnonce, String qop, String realm, String md5a2) {
        this.setProperty(DIGEST_PASSWORD_PROPERTY_KEY, clientDigest);
        this.setProperty(NONCE_PROPERTY_KEY, nOnce);
        this.setProperty(NC_PROPERTY_KEY, nc);
        this.setProperty(CNONCE_PROPERTY_KEY, cnonce);
        this.setProperty(QOP_PROPERTY_KEY, qop);
        this.setProperty(REALM_PROPERTY_KEY, realm);
        this.setProperty(MD5A2_PROPERTY_KEY, md5a2);
    }

    public String getPassword() {
        return this.getProperty(DIGEST_PASSWORD_PROPERTY_KEY);
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof PasswordWithMD5Factory)) {
            return false;
        }
        if (this == another) {
            return true;
        }
        return super.equals(another);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object getCredential() throws CredentialFactoryException {
        String password = this.getPassword();
        if (password == null) {
            throw new CredentialFactoryException("Error creating Password: the password property is null");
        }
        return new Password(password);
    }

    public boolean isPublicCredential() {
        return false;
    }
}

