/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.util.Set;
import jeus.security.base.CodeSubject;
import jeus.security.base.Subject;
import jeus.security.resource.Password;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.SetUtil;

public class SystemPassword
extends Password {
    private static SystemPassword referencePassword = new SystemPassword();

    private SystemPassword() {
        super(SecurityInstaller.getGlobalPassword());
    }

    private static SystemPassword getSystemPassword(Subject sub) {
        Set s = SetUtil.getMembers(SystemPassword.class, sub.getPrivateCredentials());
        if (s.size() > 0) {
            return (SystemPassword)s.iterator().next();
        }
        return null;
    }

    public static void setSystemPassword(Subject sub) {
        sub.getPrivateCredentials().clear();
        sub.getPublicCredentials().clear();
        sub.getCredentialFactories().clear();
        sub.getPrivateCredentials().add(referencePassword);
    }

    public static boolean checkSystemPassword(Subject sub) {
        SystemPassword proof = SystemPassword.getSystemPassword(sub);
        if (proof == null) {
            return false;
        }
        return referencePassword.getPassword().equals(proof.getPassword());
    }

    public static boolean checkCodeSubjectPassword(CodeSubject sub) {
        SystemPassword proof = (SystemPassword)sub.getPrivateCredentials().iterator().next();
        return referencePassword.getPassword().equals(proof.getPassword());
    }

    public static void initialSystemPassword(Subject sub) {
        sub.getPrivateCredentials().add(referencePassword);
    }

    public static String getSystemPassword() {
        return referencePassword.getPassword();
    }
}

