/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.security.Permission;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import jeus.security.resource.RolePermission;

public class TimeConstrainedRolePermission
extends RolePermission {
    private String timeConstraint = "*";
    private int startTime = Integer.MIN_VALUE;
    private int endTime = Integer.MAX_VALUE;
    private Set includedDays = new HashSet();

    public TimeConstrainedRolePermission(String roleName) {
        this(roleName, "*");
    }

    public TimeConstrainedRolePermission(String roleName, String timeConstraint) {
        super(roleName);
        if (timeConstraint != null && !timeConstraint.equals("*")) {
            this.timeConstraint = timeConstraint;
            this.parseTimeConstraint();
        }
    }

    private void parseTimeConstraint() {
        String time;
        StringTokenizer st1;
        StringTokenizer st = new StringTokenizer(this.timeConstraint, ";");
        if (st.hasMoreTokens() && (st1 = new StringTokenizer(time = st.nextToken(), "-")).countTokens() == 2) {
            StringTokenizer stEnd;
            String startTime = st1.nextToken();
            String endTime = st1.nextToken();
            StringTokenizer stStart = new StringTokenizer(startTime, ":");
            if (stStart.countTokens() == 2) {
                String startHours = stStart.nextToken();
                String startMinutes = stStart.nextToken();
                int startH = Integer.parseInt(startHours);
                int startM = Integer.parseInt(startMinutes);
                this.startTime = startH * 60 + startM;
            }
            if ((stEnd = new StringTokenizer(endTime, ":")).countTokens() == 2) {
                String endHours = stEnd.nextToken();
                String endMinutes = stEnd.nextToken();
                int endH = Integer.parseInt(endHours);
                int endM = Integer.parseInt(endMinutes);
                this.endTime = endH * 60 + endM;
            }
        }
        if (st.hasMoreTokens()) {
            String days = st.nextToken();
            st1 = new StringTokenizer(days, ",");
            while (st1.hasMoreTokens()) {
                String day = st1.nextToken();
                if (day.equalsIgnoreCase("mon") || day.equalsIgnoreCase("monday")) {
                    this.includedDays.add(new Integer(2));
                    continue;
                }
                if (day.equalsIgnoreCase("tue") || day.equalsIgnoreCase("tuesday")) {
                    this.includedDays.add(new Integer(3));
                    continue;
                }
                if (day.equalsIgnoreCase("wed") || day.equalsIgnoreCase("wednesday")) {
                    this.includedDays.add(new Integer(4));
                    continue;
                }
                if (day.equalsIgnoreCase("thu") || day.equalsIgnoreCase("thursday")) {
                    this.includedDays.add(new Integer(5));
                    continue;
                }
                if (day.equalsIgnoreCase("fri") || day.equalsIgnoreCase("friday")) {
                    this.includedDays.add(new Integer(6));
                    continue;
                }
                if (day.equalsIgnoreCase("sat") || day.equalsIgnoreCase("saturday")) {
                    this.includedDays.add(new Integer(7));
                    continue;
                }
                if (!day.equalsIgnoreCase("sun") && !day.equalsIgnoreCase("sunday")) continue;
                this.includedDays.add(new Integer(1));
            }
        } else {
            this.includedDays.add(new Integer(2));
            this.includedDays.add(new Integer(3));
            this.includedDays.add(new Integer(4));
            this.includedDays.add(new Integer(5));
            this.includedDays.add(new Integer(6));
            this.includedDays.add(new Integer(7));
            this.includedDays.add(new Integer(1));
        }
    }

    public boolean equals(Object anotherObject) {
        if (anotherObject == null) {
            return false;
        }
        if (anotherObject == this) {
            return true;
        }
        if (anotherObject instanceof TimeConstrainedRolePermission) {
            TimeConstrainedRolePermission rolePerm = (TimeConstrainedRolePermission)anotherObject;
            return super.equals(rolePerm) && this.startTime == rolePerm.startTime && this.endTime == rolePerm.endTime;
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.timeConstraint.hashCode();
    }

    public String getActions() {
        return this.timeConstraint;
    }

    public boolean implies(Permission anotherPermission) {
        if (this.timeConstraint.equals("*")) {
            return super.implies(anotherPermission);
        }
        Calendar cal = Calendar.getInstance();
        int curHour = cal.get(11);
        int curMinute = cal.get(12);
        int now = curHour * 60 + curMinute;
        Integer dayOfWeek = new Integer(cal.get(7));
        if (now >= this.startTime && now <= this.endTime && this.includedDays.contains(dayOfWeek)) {
            return super.implies(anotherPermission);
        }
        return false;
    }
}

