/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CopyOnWriteHashSet
implements Set,
Serializable {
    private HashSet hashSet;
    private boolean isShared;

    public CopyOnWriteHashSet() {
        this.hashSet = new HashSet();
    }

    public CopyOnWriteHashSet(HashSet _hashSet) {
        this.hashSet = _hashSet;
    }

    public CopyOnWriteHashSet(Collection c) {
        this.hashSet = new HashSet(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public CopyOnWriteHashSet(int initialCapacity, float loadFactor) {
        this.hashSet = new HashSet(initialCapacity, loadFactor);
    }

    public CopyOnWriteHashSet(int initialCapacity) {
        this.hashSet = new HashSet(initialCapacity);
    }

    private synchronized HashSet getHashSet() {
        return this.hashSet;
    }

    public Iterator iterator() {
        this.isShared = true;
        HashSet _hashSet = this.getHashSet();
        return new ReadOnlyIterator(_hashSet.iterator());
    }

    public int size() {
        HashSet _hashSet = this.getHashSet();
        return _hashSet.size();
    }

    public boolean isEmpty() {
        HashSet _hashSet = this.getHashSet();
        return _hashSet.isEmpty();
    }

    public boolean contains(Object o) {
        HashSet _hashSet = this.getHashSet();
        return _hashSet.contains(o);
    }

    public synchronized boolean add(Object o) {
        if (this.isShared) {
            this.hashSet = (HashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.add(o);
    }

    public synchronized boolean remove(Object o) {
        if (this.isShared) {
            this.hashSet = (HashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.remove(o);
    }

    public synchronized boolean removeAll(Collection c) {
        if (this.isShared) {
            this.hashSet = (HashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (this.isShared) {
            this.hashSet = (HashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.retainAll(c);
    }

    public synchronized boolean addAll(Collection c) {
        if (this.isShared) {
            this.hashSet = (HashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.addAll(c);
    }

    public boolean containsAll(Collection c) {
        if (this.isShared) {
            this.hashSet = (HashSet)this.hashSet.clone();
            this.isShared = false;
        }
        return this.hashSet.containsAll(c);
    }

    public void clear() {
        this.hashSet = new HashSet();
    }

    public Object clone() {
        this.isShared = true;
        CopyOnWriteHashSet newSet = new CopyOnWriteHashSet(this.hashSet);
        newSet.isShared = true;
        return newSet;
    }

    public Object[] toArray() {
        HashSet hashSet = this.getHashSet();
        return hashSet.toArray();
    }

    public Object[] toArray(Object[] a) {
        HashSet hashSet = this.getHashSet();
        return hashSet.toArray(a);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        HashSet _hashSet = this.getHashSet();
        s.writeObject(_hashSet);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.hashSet = (HashSet)s.readObject();
    }

    public boolean equals(Object o) {
        HashSet _hashSet = this.getHashSet();
        return _hashSet.equals(o);
    }

    public int hashCode() {
        HashSet _hashSet = this.getHashSet();
        return _hashSet.hashCode();
    }

    class ReadOnlyIterator
    implements Iterator {
        private Iterator iterator;

        public ReadOnlyIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }
    }
}

