/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jeus.security.impl.atnrep.db.SequenceNumTable;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.util.JeusBootstrapProperties;

public abstract class DBConverter {
    private static final String fs = System.getProperty("file.separator");
    private static URLClassLoader classLoader = null;
    private String driver;
    private String url;
    private String username;
    private String password;
    private Connection conn;
    private Statement stmt;
    private PreparedStatement pstmt;
    protected String vendor;
    protected SequenceNumTable seqNoTable;
    protected Map memoryGroupTable;

    public DBConverter(String driver, String url, String username, String password) throws Exception {
        block3: {
            this.driver = null;
            this.url = null;
            this.username = null;
            this.password = null;
            this.conn = null;
            this.stmt = null;
            this.pstmt = null;
            this.vendor = "oracle";
            this.seqNoTable = null;
            this.driver = driver;
            this.url = url;
            this.username = username;
            this.password = password;
            try {
                Vector<URL> urls = new Vector<URL>();
                String dir = JeusBootstrapProperties.JEUS_HOME + fs + "lib" + fs + "datasource";
                File f = new File(dir);
                String[] files = f.list();
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].lastIndexOf(46) == -1 || !files[i].substring(files[i].lastIndexOf(46) + 1).equals("jar") && !files[i].substring(files[i].lastIndexOf(46) + 1).equals("zip")) continue;
                    URL _url = new URL("file://localhost/" + dir + fs + files[i]);
                    urls.add(_url);
                }
                URL[] srcURL = new URL[urls.size()];
                urls.toArray(srcURL);
                ClassLoader currentLoader = this.getClass().getClassLoader();
                classLoader = new URLClassLoader(srcURL, currentLoader);
            }
            catch (Throwable t) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) break block3;
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, t);
            }
        }
    }

    public synchronized Object unmarshal() throws Exception {
        return this.fromDBTable();
    }

    public synchronized Object unmarshal(String key) throws Exception {
        return this.fromDBTable(key);
    }

    public synchronized void marshal(Object object) throws Exception {
        this.toDBTable(object);
    }

    public void connect() throws Exception {
        if (this.conn == null) {
            Class<?> clazz = classLoader.loadClass(this.driver);
            Properties props = new Properties();
            props.put("user", this.username);
            props.put("password", this.password);
            this.conn = ((Driver)clazz.newInstance()).connect(this.url, props);
            this.conn.setAutoCommit(false);
            this.stmt = this.conn.createStatement();
        }
    }

    public void selectConnect() throws Exception {
        if (this.conn == null) {
            Class<?> clazz = classLoader.loadClass(this.driver);
            Properties props = new Properties();
            props.put("user", this.username);
            props.put("password", this.password);
            this.conn = ((Driver)clazz.newInstance()).connect(this.url, props);
            this.conn.setAutoCommit(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
            if (this.pstmt != null) {
                this.pstmt.close();
            }
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
        }
        finally {
            this.stmt = null;
            this.conn = null;
            this.pstmt = null;
        }
    }

    public void executeUpdate(String[] sqls) {
        try {
            this.connect();
            for (int i = 0; i < sqls.length; ++i) {
                this.stmt.executeUpdate(sqls[i]);
            }
            this.conn.commit();
            this.close();
        }
        catch (SQLException e) {
            block8: {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
                }
                try {
                    this.conn.rollback();
                }
                catch (Exception ex) {
                    if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) break block8;
                    LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
                }
            }
            this.close();
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            this.close();
        }
    }

    public ResultSet executeQuery(String sql) {
        ResultSet result = null;
        try {
            this.connect();
            result = this.stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            this.close();
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            this.close();
        }
        return result;
    }

    public ResultSet executeSelectQuery(String sql, String[] keys) {
        ResultSet result = null;
        try {
            this.selectConnect();
            this.pstmt = this.conn.prepareStatement(sql);
            for (int i = 1; i <= keys.length; ++i) {
                this.pstmt.setString(i, keys[i - 1]);
            }
            result = this.pstmt.executeQuery();
        }
        catch (SQLException e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            e.printStackTrace();
            this.close();
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            e.printStackTrace();
            this.close();
        }
        return result;
    }

    public boolean checkExist(String sql) throws Exception {
        boolean flag = false;
        Connection con = null;
        Statement stmt = null;
        try {
            Properties props = new Properties();
            props.put("user", this.username);
            props.put("password", this.password);
            Class<?> clazz = classLoader.loadClass(this.driver);
            con = ((Driver)clazz.newInstance()).connect(this.url, props);
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            rs.close();
            flag = true;
        }
        catch (SQLException e) {
            flag = false;
        }
        catch (ClassNotFoundException e) {
            URL[] urls = classLoader.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                System.out.println("CurrentURL = " + urls[i].toString());
            }
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSeqNoTable() throws Exception {
        block32: {
            if (this.seqNoTable == null) {
                this.seqNoTable = new SequenceNumTable(this.vendor);
                Connection con = null;
                Statement stmt = null;
                try {
                    Class<?> clazz = classLoader.loadClass(this.driver);
                    Properties props = new Properties();
                    props.put("user", this.username);
                    props.put("password", this.password);
                    con = ((Driver)clazz.newInstance()).connect(this.url, props);
                    con.setAutoCommit(false);
                    stmt = con.createStatement();
                    stmt.executeUpdate(this.seqNoTable.getCreateQuery());
                    ArrayList initDataSqlList = this.seqNoTable.getInitQuery();
                    String[] initDataSqls = new String[initDataSqlList.size()];
                    initDataSqlList.toArray(initDataSqls);
                    for (int i = 0; i < initDataSqls.length; ++i) {
                        stmt.executeUpdate(initDataSqls[i]);
                    }
                    con.commit();
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 955) break block32;
                    if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                        LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
                    }
                    try {
                        if (con != null) {
                            con.rollback();
                        }
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                finally {
                    try {
                        if (con != null) {
                            con.setAutoCommit(true);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public boolean checkExist(String sql, String domainName) throws Exception {
        boolean flag = false;
        Connection con = null;
        Statement pstmt = null;
        try {
            Properties props = new Properties();
            props.put("user", this.username);
            props.put("password", this.password);
            Class<?> clazz = classLoader.loadClass(this.driver);
            con = ((Driver)clazz.newInstance()).connect(this.url, props);
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, domainName);
            ResultSet rs = pstmt.executeQuery();
            rs.close();
            flag = true;
        }
        catch (SQLException e) {
            flag = false;
        }
        catch (ClassNotFoundException e) {
            URL[] urls = classLoader.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                System.out.println("CurrentURL = " + urls[i].toString());
            }
            throw e;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String[] createSqls, String[] initDataSqls) throws Exception {
        Connection con = null;
        Statement stmt = null;
        try {
            int i;
            block34: {
                Class<?> clazz = classLoader.loadClass(this.driver);
                Properties props = new Properties();
                props.put("user", this.username);
                props.put("password", this.password);
                con = ((Driver)clazz.newInstance()).connect(this.url, props);
                con.setAutoCommit(false);
                stmt = con.createStatement();
                try {
                    for (i = 0; i < createSqls.length; ++i) {
                        stmt.executeUpdate(createSqls[i]);
                    }
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 955) break block34;
                    throw e;
                }
            }
            for (i = 0; i < initDataSqls.length; ++i) {
                stmt.executeUpdate(initDataSqls[i]);
            }
            con.commit();
        }
        catch (SQLException e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            e.printStackTrace();
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        finally {
            try {
                if (con != null) {
                    con.setAutoCommit(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(String[] dropSqls) throws Exception {
        Connection con = null;
        Statement stmt = null;
        try {
            Class<?> clazz = classLoader.loadClass(this.driver);
            Properties props = new Properties();
            props.put("user", this.username);
            props.put("password", this.password);
            con = ((Driver)clazz.newInstance()).connect(this.url, props);
            con.setAutoCommit(false);
            stmt = con.createStatement();
            for (int i = 0; i < dropSqls.length; ++i) {
                stmt.executeUpdate(dropSqls[i]);
            }
            con.commit();
        }
        catch (SQLException e) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
        }
        finally {
            try {
                if (con != null) {
                    con.setAutoCommit(true);
                }
            }
            catch (Exception e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Map getGroupsTable() {
        return this.memoryGroupTable;
    }

    public void setGroupsTable(Map memoryGroupTable) {
        this.memoryGroupTable = memoryGroupTable;
    }

    protected abstract Object fromDBTable() throws Exception;

    protected abstract Object fromDBTable(String var1) throws Exception;

    protected abstract void toDBTable(Object var1) throws Exception;

    public abstract void create() throws Exception;
}

