/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.Properties;
import java.util.Vector;
import jeus.security.util.DBRealmSQLQueryConverter;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.util.JeusBootstrapProperties;

public class DBDriverConverter
extends DBRealmSQLQueryConverter {
    private static final String fs = System.getProperty("file.separator");
    private static URLClassLoader classLoader;
    private String driver;
    private String url;
    private String username;
    private String password;

    public DBDriverConverter(String domainName, String vendor, String driver, String url, String username, String password) throws Exception {
        block3: {
            this.domainName = domainName;
            this.vendor = vendor;
            this.driver = driver;
            this.url = url;
            this.username = username;
            this.password = password;
            try {
                Vector<URL> urls = new Vector<URL>();
                String dir = JeusBootstrapProperties.JEUS_HOME + fs + "lib" + fs + "datasource";
                File f = new File(dir);
                String[] files = f.list();
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].lastIndexOf(46) == -1 || !files[i].substring(files[i].lastIndexOf(46) + 1).equals("jar") && !files[i].substring(files[i].lastIndexOf(46) + 1).equals("zip")) continue;
                    URL _url = new URL("file://localhost/" + dir + fs + files[i]);
                    urls.add(_url);
                }
                URL[] srcURL = new URL[urls.size()];
                urls.toArray(srcURL);
                ClassLoader currentLoader = this.getClass().getClassLoader();
                classLoader = new URLClassLoader(srcURL, currentLoader);
            }
            catch (Throwable t) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) break block3;
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, t);
            }
        }
    }

    protected void connect() throws Exception {
        if (this.conn == null) {
            Class<?> clazz = classLoader.loadClass(this.driver);
            Properties props = new Properties();
            props.put("user", this.username);
            props.put("password", this.password);
            this.conn = ((Driver)clazz.newInstance()).connect(this.url, props);
            this.conn.setAutoCommit(false);
        }
    }
}

