/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import com.tmax.jce.provider.TmaxProvider;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.NoSuchPaddingException;
import jeus.security.util.Base64Coder;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.LoggerUtil;
import jeus.security.util.MessageDigestUtil;
import jeus.util.EnvironmentCall;
import jeus.util.console.EncryptionConsoleTool;
import jeus.util.properties.JeusPropertyValues;

public class EncryptionTool {
    public static void main(String[] args) {
        EncryptionUtil.init(JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + EnvironmentCall.getLocalVirutalName() + JeusPropertyValues.fs + "security", (Provider)new TmaxProvider());
        EncryptionConsoleTool encryption = new EncryptionConsoleTool("encryption", "execute encryption tool");
        if (!encryption.checkArguments(args)) {
            return;
        }
        String algorithm = encryption.getCipherAlgorithm();
        if (encryption.isProtectMode()) {
            if (!EncryptionUtil.isProtected()) {
                EncryptionUtil.initPasswordForSecretKey();
            } else {
                EncryptionUtil.inputPasswordForSecretKey();
            }
        } else if (EncryptionUtil.isProtected()) {
            if (algorithm.equalsIgnoreCase("base64")) {
                EncryptionTool.base64Encrypt(encryption.getPlainText());
                return;
            }
            if (algorithm.equalsIgnoreCase("SHA")) {
                EncryptionTool.shaExecute(encryption.getPlainText());
                return;
            }
            EncryptionUtil.inputPasswordForSecretKey();
        }
        EncryptionUtil.cacheEncryptionInfo();
        if (algorithm.equalsIgnoreCase("base64")) {
            EncryptionTool.base64Encrypt(encryption.getPlainText());
        } else if (algorithm.equalsIgnoreCase("SHA")) {
            EncryptionTool.shaExecute(encryption.getPlainText());
        } else {
            EncryptionTool.encrypt(algorithm, encryption.getPlainText());
        }
    }

    private static void base64Encrypt(String plain_password) {
        String encodedPassword = Base64Coder.encode(plain_password);
        System.out.println("[base64] : [" + plain_password + "] --> [encode:" + encodedPassword + "]");
        System.out.println("[base64] : [" + encodedPassword + "] --> [decode:" + Base64Coder.decode(encodedPassword) + "]");
    }

    private static void shaExecute(String plain_password) {
        try {
            MessageDigest msgDigest = MessageDigest.getInstance("sha");
            byte[] passBytes = plain_password.getBytes("UTF-8");
            byte[] hash = msgDigest.digest(passBytes);
            String passwordHash = MessageDigestUtil.encodeBase64(hash);
            System.out.println("[sha] : [" + plain_password + "] --> [" + passwordHash + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void encrypt(String algorithm, String plain_password) {
        try {
            String encodedPassword = EncryptionUtil.encode(algorithm, plain_password);
            System.out.println("[" + algorithm + "] : [" + plain_password + "] --> [encode:" + encodedPassword + "]");
            String decodePassword = EncryptionUtil.decode(algorithm, encodedPassword);
            System.out.println("[" + algorithm + "] : [" + encodedPassword + "] --> [decode:" + decodePassword + "]");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("You have entered invalid algorithm value : " + algorithm);
            System.err.println("valid algorithm value : base64|SHA|DES|DESede|AES|SEED|Blowfish ");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            LoggerUtil.logger.log("Retry encryption execution :  Invalid security.key file (" + e.getMessage() + ")");
        }
        catch (IOException e) {
            LoggerUtil.logger.log("Retry encryption execution :  Invalid security.key file (" + e.getMessage() + ")");
            e.printStackTrace();
        }
    }
}

