/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.security.Permission;
import jeus.security.base.Domain;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.spi.SecurityRuntimeException;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.PasswordVerifier;
import jeus.util.JeusRuntimeException;

public class LoginUtil {
    public static void loginTest() {
    }

    public static void checkPermissionWithCodeSubject(Permission permission) {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        try {
            LoginService.checkPermission("default", permission);
            if (SecurityInstaller.getEnvironment() == null) {
                LoginService.loginCodeSubject(Domain.getCodeSubject());
            } else {
                LoginService.loginCodeSubject(Domain.getCodeSubject(SecurityInstaller.getEnvironment().defaultDomainName));
            }
        }
        catch (Throwable e) {
            throw new SecurityRuntimeException(JeusMessage_Security._49, e);
        }
    }

    public static void checkPermissionWithRuntimeException(Permission permission) {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        try {
            LoginService.checkPermission("default", permission);
        }
        catch (Throwable e) {
            throw new SecurityRuntimeException(e);
        }
    }

    public static void loginCodeSubjectWithRuntimeException() {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        try {
            if (SecurityInstaller.getEnvironment() == null) {
                LoginService.loginCodeSubject(Domain.getCodeSubject());
            } else {
                LoginService.loginCodeSubject(Domain.getCodeSubject(SecurityInstaller.getEnvironment().defaultDomainName));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new JeusRuntimeException(e);
        }
    }

    public static void loginAnonymousWithRuntimeException() {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        try {
            if (SecurityInstaller.getEnvironment() == null) {
                LoginService.loginCodeSubject(Domain.getCodeSubject());
            } else {
                LoginService.loginAnonymousSubject(Domain.getAnonymousSubject(SecurityInstaller.getEnvironment().defaultDomainName));
            }
        }
        catch (SecurityException e) {
            throw new SecurityRuntimeException(e);
        }
        catch (Throwable e) {
            throw new JeusRuntimeException(e);
        }
    }

    public static void logoutWithRuntimeException() {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        try {
            LoginService.logout();
        }
        catch (Throwable e) {
            throw new JeusRuntimeException(e);
        }
    }

    public static void loginWithRuntimeException(Subject subject) {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        try {
            LoginService.login(subject);
        }
        catch (SecurityException e) {
            throw new SecurityRuntimeException(e);
        }
        catch (Throwable e) {
            throw new JeusRuntimeException(e);
        }
    }

    public static boolean verify(PasswordVerifier passwordVerifier) throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return true;
        }
        String username = passwordVerifier.getUsername();
        LoginService.login(Domain.getCodeSubject(SecurityInstaller.getEnvironment().defaultDomainName), false);
        Subject subject = AuthenticationRepositoryService.getSubject(username);
        LoginService.logout();
        String password = subject.getPasswordObject().getPlainPassword();
        return passwordVerifier.verify(password);
    }

    public static void logoutAll() throws ServiceException, SecurityException {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        while (LoginService.logout() != null) {
        }
    }

    public static Subject getLatestUserSubjectWithRuntimeException() {
        if (SecurityInstaller.isSecurityOff()) {
            return null;
        }
        try {
            return LoginService.getLatestUserSubject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

