/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.JeusMessage_Security;
import jeus.util.JeusException;
import jeus.util.logging.JeusLogger;

public final class PasswordFileManager {
    private static final int TYPE_READ = 1;
    private static final int UNAME_READ = 2;
    private static final int PASS_READ = 3;
    private static final int READ_ERROR = 4;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
    private static int status = 1;

    public static String[] getUnamePassPair(String path) throws Exception {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(path));
            String typeStr = null;
            String[] pair = new String[2];
            switch (status) {
                case 1: {
                    typeStr = reader.readLine();
                    if (typeStr == null) {
                        status = 4;
                    } else {
                        typeStr = typeStr.trim();
                        status = 2;
                    }
                }
                case 2: {
                    pair[0] = reader.readLine();
                    if (pair[0] == null) {
                        status = 4;
                    } else {
                        pair[0] = pair[0].trim();
                        status = 3;
                    }
                }
                case 3: {
                    pair[1] = reader.readLine();
                    if (pair[1] == null) {
                        status = 4;
                    } else {
                        pair[1] = pair[1].trim();
                        status = 1;
                        break;
                    }
                }
                case 4: {
                    if (logger.isLoggable(JeusMessage_Security._50_LEVEL)) {
                        logger.log(JeusMessage_Security._50_LEVEL, JeusMessage_Security._50);
                    }
                    throw new JeusException("The contents of the password file are not enough");
                }
            }
            logger.log(Level.FINEST, "Password Encoded type : " + typeStr);
            logger.log(Level.FINEST, "User Name : " + pair[0]);
            logger.log(Level.FINEST, "Encoded Password : " + pair[1]);
            pair[1] = EncryptionUtil.decryptPassword(typeStr, pair[1]);
            return pair;
        }
        catch (FileNotFoundException e) {
            if (logger.isLoggable(JeusMessage_Security._51_LEVEL)) {
                logger.log(JeusMessage_Security._51_LEVEL, JeusMessage_Security._51, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_Security._52_LEVEL)) {
                logger.log(JeusMessage_Security._52_LEVEL, JeusMessage_Security._52, (Throwable)e);
            }
            throw e;
        }
    }
}

