/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

public class StringSerializer {
    private static final String STRING_ARRAY_CLASSNAME = "[Ljava.lang.String;";
    private static final String INTEGER_ARRAY_CLASSNAME = "[Ljava.lang.Integer;";
    private static final String FLOAT_ARRAY_CLASSNAME = "[Ljava.lang.Float;";
    private static final String DOUBLE_ARRAY_CLASSNAME = "[Ljava.lang.Double;";
    private static final String LONG_ARRAY_CLASSNAME = "[Ljava.lang.Long;";
    private static final String BOOLEAN_ARRAY_CLASSNAME = "[Ljava.lang.Boolean;";
    private static final String BYTE_ARRAY_CLASSNAME = "[Ljava.lang.Byte;";
    private static final String CHARACTER_ARRAY_CLASSNAME = "[Ljava.lang.Character;";
    private static final String SHORT_ARRAY_CLASSNAME = "[Ljava.lang.Short;";
    private static final String INTEGER_PRIM_ARRAY_CLASSNAME = "[I";
    private static final String FLOAT_PRIM_ARRAY_CLASSNAME = "[F";
    private static final String DOUBLE_PRIM_ARRAY_CLASSNAME = "[D";
    private static final String LONG_PRIM_ARRAY_CLASSNAME = "[J";
    private static final String BOOLEAN_PRIM_ARRAY_CLASSNAME = "[Z";
    private static final String BYTE_PRIM_ARRAY_CLASSNAME = "[B";
    private static final String CHARACTER_PRIM_ARRAY_CLASSNAME = "[C";
    private static final String SHORT_PRIM_ARRAY_CLASSNAME = "[S";

    public static Object[] fromString(String[] values, Class type) {
        Object[] result = null;
        Class innerType = null;
        if (type.getName().equals(STRING_ARRAY_CLASSNAME)) {
            result = new String[values.length];
            innerType = String.class;
        }
        if (type.getName().equals(INTEGER_ARRAY_CLASSNAME) || type.getName().equals(INTEGER_PRIM_ARRAY_CLASSNAME)) {
            result = new Integer[values.length];
            innerType = Integer.class;
        }
        if (type.getName().equals(FLOAT_ARRAY_CLASSNAME) || type.getName().equals(FLOAT_PRIM_ARRAY_CLASSNAME)) {
            result = new Float[values.length];
            innerType = Float.class;
        }
        if (type.getName().equals(DOUBLE_ARRAY_CLASSNAME) || type.getName().equals(DOUBLE_PRIM_ARRAY_CLASSNAME)) {
            result = new Double[values.length];
            innerType = Double.class;
        }
        if (type.getName().equals(LONG_ARRAY_CLASSNAME) || type.getName().equals(LONG_PRIM_ARRAY_CLASSNAME)) {
            result = new Long[values.length];
            innerType = Long.class;
        }
        if (type.getName().equals(BOOLEAN_ARRAY_CLASSNAME) || type.getName().equals(BOOLEAN_PRIM_ARRAY_CLASSNAME)) {
            result = new Boolean[values.length];
            innerType = Boolean.class;
        }
        if (type.getName().equals(BYTE_ARRAY_CLASSNAME) || type.getName().equals(BYTE_PRIM_ARRAY_CLASSNAME)) {
            result = new Byte[values.length];
            innerType = Byte.class;
        }
        if (type.getName().equals(CHARACTER_ARRAY_CLASSNAME) || type.getName().equals(CHARACTER_PRIM_ARRAY_CLASSNAME)) {
            result = new Character[values.length];
            innerType = Character.class;
        }
        if (type.getName().equals(SHORT_ARRAY_CLASSNAME) || type.getName().equals(SHORT_PRIM_ARRAY_CLASSNAME)) {
            result = new Short[values.length];
            innerType = Short.class;
        }
        if (result == null || innerType == null) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            result[i] = StringSerializer.fromString(values[i], innerType);
        }
        return result;
    }

    public static Object fromString(String value, Object type) {
        return StringSerializer.fromString(value, type.getClass());
    }

    public static Object fromString(String value, Class type) {
        if (value == null) {
            return null;
        }
        if (type == String.class) {
            return value;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new Integer(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return new Float(value);
        }
        if ((type == Character.class || type == Character.TYPE) && value.length() > 0) {
            return new Character(value.charAt(0));
        }
        if (type == Double.class || type == Double.TYPE) {
            return new Double(value);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return new Boolean(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return new Long(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return new Short(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return new Byte(value);
        }
        if (type == String[].class) {
            return StringSerializer.fromString(new String[]{value}, type);
        }
        if (type == Integer[].class) {
            return StringSerializer.fromString(new String[]{value}, type);
        }
        if (type == Float[].class) {
            return StringSerializer.fromString(new String[]{value}, type);
        }
        if (type == Character[].class && value.length() > 0) {
            return StringSerializer.fromString(new String[]{value}, type);
        }
        if (type == Double[].class) {
            return StringSerializer.fromString(new String[]{value}, type);
        }
        if (type == Boolean[].class) {
            return StringSerializer.fromString(new String[]{value}, type);
        }
        if (type == Long[].class) {
            return StringSerializer.fromString(new String[]{value}, type);
        }
        if (type == Short[].class) {
            return StringSerializer.fromString(new String[]{value}, type);
        }
        if (type == Byte[].class) {
            return StringSerializer.fromString(new String[]{value}, type);
        }
        return null;
    }

    public static String toString(Object object) {
        String[] result = StringSerializer.toStringFromArray(new Object[]{object});
        return result[0];
    }

    public static String[] toStringFromArray(Object[] array) {
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            Object o = array[i];
            Class<?> type = o.getClass();
            if (type == String.class) {
                result[i] = (String)o;
                continue;
            }
            if (type == Integer.class || type == Integer.TYPE) {
                result[i] = StringSerializer.toString((Integer)o);
                continue;
            }
            if (type == Float.class || type == Float.TYPE) {
                result[i] = StringSerializer.toString((Float)o);
                continue;
            }
            if (type == Double.class || type == Double.TYPE) {
                result[i] = StringSerializer.toString((Double)o);
                continue;
            }
            if (type == Long.class || type == Long.TYPE) {
                result[i] = StringSerializer.toString((Long)o);
                continue;
            }
            if (type == Byte.class || type == Byte.TYPE) {
                result[i] = StringSerializer.toString((Byte)o);
                continue;
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                result[i] = StringSerializer.toString((Boolean)o);
                continue;
            }
            if (type == Short.class || type == Short.TYPE) {
                result[i] = StringSerializer.toString((Short)o);
                continue;
            }
            if (type != Character.class && type != Character.TYPE) continue;
            result[i] = StringSerializer.toString((Character)o);
        }
        return result;
    }

    public static String toString(String s) {
        return s;
    }

    public static String toString(int i) {
        return String.valueOf(i);
    }

    public static String toString(char c) {
        return String.valueOf(c);
    }

    public static String toString(float f) {
        return String.valueOf(f);
    }

    public static String toString(double d) {
        return String.valueOf(d);
    }

    public static String toString(long l) {
        return String.valueOf(l);
    }

    public static String toString(byte b) {
        return String.valueOf(b);
    }

    public static String toString(short s) {
        return String.valueOf(s);
    }

    public static String toString(boolean b) {
        return String.valueOf(b);
    }

    public static String toString(Integer i) {
        return i.toString();
    }

    public static String toString(Character c) {
        return c.toString();
    }

    public static String toString(Float f) {
        return f.toString();
    }

    public static String toString(Double d) {
        return d.toString();
    }

    public static String toString(Long l) {
        return l.toString();
    }

    public static String toString(Byte b) {
        return b.toString();
    }

    public static String toString(Short s) {
        return s.toString();
    }

    public static String toString(Boolean b) {
        return b.toString();
    }

    public static String[] toString(int[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = StringSerializer.toString(array[i]);
        }
        return result;
    }

    public static String[] toString(char[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = StringSerializer.toString(array[i]);
        }
        return result;
    }

    public static String[] toString(float[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = StringSerializer.toString(array[i]);
        }
        return result;
    }

    public static String[] toString(double[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = StringSerializer.toString(array[i]);
        }
        return result;
    }

    public static String[] toString(long[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = StringSerializer.toString(array[i]);
        }
        return result;
    }

    public static String[] toString(byte[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = StringSerializer.toString(array[i]);
        }
        return result;
    }

    public static String[] toString(short[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = StringSerializer.toString(array[i]);
        }
        return result;
    }

    public static String[] toString(boolean[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = StringSerializer.toString(array[i]);
        }
        return result;
    }

    public static void main(String[] args) {
        String str = new String("0");
        Integer i = new Integer(1);
        Float f = new Float(2.0f);
        Double d = new Double(3.0);
        Long l = new Long(4L);
        Character c = new Character('5');
        Byte b = new Byte("6");
        Boolean z = new Boolean(true);
        Short s = new Short("8");
        int iPrim = 10;
        float fPrim = 11.0f;
        double dPrim = 12.0;
        long lPrim = 13L;
        char cPrim = '\u000e';
        byte bPrim = 15;
        boolean zPrim = false;
        short sPrim = 17;
        Object[] strArray = new String[]{str, str, str};
        Object[] iArray = new Integer[]{i, i, i};
        Object[] fArray = new Float[]{f, f, f};
        Object[] dArray = new Double[]{d, d, d};
        Object[] lArray = new Long[]{l, l, l};
        Object[] cArray = new Character[]{c, c, c};
        Object[] bArray = new Byte[]{b, b, b};
        Object[] zArray = new Boolean[]{z, z, z};
        Object[] sArray = new Short[]{s, s, s};
        int[] iPrimArray = new int[]{iPrim, iPrim, iPrim};
        float[] fPrimArray = new float[]{fPrim, fPrim, fPrim};
        double[] dPrimArray = new double[]{dPrim, dPrim, dPrim};
        long[] lPrimArray = new long[]{lPrim, lPrim, lPrim};
        char[] cPrimArray = new char[]{cPrim, cPrim, cPrim};
        byte[] bPrimArray = new byte[]{bPrim, bPrim, bPrim};
        boolean[] zPrimArray = new boolean[]{zPrim, zPrim, zPrim};
        short[] sPrimArray = new short[]{sPrim, sPrim, sPrim};
        System.out.println("OBJ:");
        String strStr = StringSerializer.toString(str);
        System.out.println(strStr);
        String iStr = StringSerializer.toString(i);
        System.out.println(iStr);
        String fStr = StringSerializer.toString(f);
        System.out.println(fStr);
        String dStr = StringSerializer.toString(d);
        System.out.println(dStr);
        String lStr = StringSerializer.toString(l);
        System.out.println(lStr);
        String cStr = StringSerializer.toString(c);
        System.out.println(cStr);
        String bStr = StringSerializer.toString(b);
        System.out.println(bStr);
        String zStr = StringSerializer.toString(z);
        System.out.println(zStr);
        String sStr = StringSerializer.toString(s);
        System.out.println(sStr);
        System.out.println("PRIM:");
        String iPrimStr = StringSerializer.toString(iPrim);
        System.out.println(iPrimStr);
        String fPrimStr = StringSerializer.toString(fPrim);
        System.out.println(fPrimStr);
        String dPrimStr = StringSerializer.toString(dPrim);
        System.out.println(dPrimStr);
        String lPrimStr = StringSerializer.toString(lPrim);
        System.out.println(lPrimStr);
        String cPrimStr = StringSerializer.toString(cPrim);
        System.out.println(cPrimStr);
        String bPrimStr = StringSerializer.toString(bPrim);
        System.out.println(bPrimStr);
        String zPrimStr = StringSerializer.toString(zPrim);
        System.out.println(zPrimStr);
        String sPrimStr = StringSerializer.toString(sPrim);
        System.out.println(sPrimStr);
        System.out.println("OBJ ARRAY:");
        String[] strStrArray = StringSerializer.toStringFromArray(strArray);
        StringSerializer.printStrings(strStrArray);
        String[] iStrArray = StringSerializer.toStringFromArray(iArray);
        StringSerializer.printStrings(iStrArray);
        String[] fStrArray = StringSerializer.toStringFromArray(fArray);
        StringSerializer.printStrings(fStrArray);
        String[] dStrArray = StringSerializer.toStringFromArray(dArray);
        StringSerializer.printStrings(dStrArray);
        String[] lStrArray = StringSerializer.toStringFromArray(lArray);
        StringSerializer.printStrings(lStrArray);
        String[] cStrArray = StringSerializer.toStringFromArray(cArray);
        StringSerializer.printStrings(cStrArray);
        String[] bStrArray = StringSerializer.toStringFromArray(bArray);
        StringSerializer.printStrings(bStrArray);
        String[] zStrArray = StringSerializer.toStringFromArray(zArray);
        StringSerializer.printStrings(zStrArray);
        String[] sStrArray = StringSerializer.toStringFromArray(sArray);
        StringSerializer.printStrings(sStrArray);
        System.out.println("PRIM ARRAY:");
        String[] iPrimStrArray = StringSerializer.toString(iPrimArray);
        StringSerializer.printStrings(iPrimStrArray);
        String[] fPrimStrArray = StringSerializer.toString(fPrimArray);
        StringSerializer.printStrings(fPrimStrArray);
        String[] dPrimStrArray = StringSerializer.toString(dPrimArray);
        StringSerializer.printStrings(dPrimStrArray);
        String[] lPrimStrArray = StringSerializer.toString(lPrimArray);
        StringSerializer.printStrings(lPrimStrArray);
        String[] cPrimStrArray = StringSerializer.toString(cPrimArray);
        StringSerializer.printStrings(cPrimStrArray);
        String[] bPrimStrArray = StringSerializer.toString(bPrimArray);
        StringSerializer.printStrings(bPrimStrArray);
        String[] zPrimStrArray = StringSerializer.toString(zPrimArray);
        StringSerializer.printStrings(zPrimStrArray);
        String[] sPrimStrArray = StringSerializer.toString(sPrimArray);
        StringSerializer.printStrings(sPrimStrArray);
        str = (String)StringSerializer.fromString(strStr, String.class);
        i = (Integer)StringSerializer.fromString(iStr, Integer.class);
        f = (Float)StringSerializer.fromString(fStr, Float.class);
        d = (Double)StringSerializer.fromString(dStr, Double.class);
        l = (Long)StringSerializer.fromString(lStr, Long.class);
        c = (Character)StringSerializer.fromString(cStr, Character.class);
        b = (Byte)StringSerializer.fromString(bStr, Byte.class);
        z = (Boolean)StringSerializer.fromString(zStr, Boolean.class);
        s = (Short)StringSerializer.fromString(sStr, Short.class);
        System.out.println("OBJ AFTER FROMSTRING:");
        strStr = StringSerializer.toString(str);
        System.out.println(strStr);
        iStr = StringSerializer.toString(i);
        System.out.println(iStr);
        fStr = StringSerializer.toString(f);
        System.out.println(fStr);
        dStr = StringSerializer.toString(d);
        System.out.println(dStr);
        lStr = StringSerializer.toString(l);
        System.out.println(lStr);
        cStr = StringSerializer.toString(c);
        System.out.println(cStr);
        bStr = StringSerializer.toString(b);
        System.out.println(bStr);
        zStr = StringSerializer.toString(z);
        System.out.println(zStr);
        sStr = StringSerializer.toString(s);
        System.out.println(sStr);
        strArray = (String[])StringSerializer.fromString(strStrArray, strArray.getClass());
        iArray = (Integer[])StringSerializer.fromString(iStrArray, iStrArray.getClass());
        fArray = (Float[])StringSerializer.fromString(fStrArray, fStrArray.getClass());
        dArray = (Double[])StringSerializer.fromString(dStrArray, dStrArray.getClass());
        lArray = (Long[])StringSerializer.fromString(lStrArray, lStrArray.getClass());
        cArray = (Character[])StringSerializer.fromString(cStrArray, cStrArray.getClass());
        bArray = (Byte[])StringSerializer.fromString(bStrArray, bStrArray.getClass());
        zArray = (Boolean[])StringSerializer.fromString(zStrArray, zStrArray.getClass());
        sArray = (Short[])StringSerializer.fromString(sStrArray, sStrArray.getClass());
        System.out.println("OBJ ARRAY AFTER FROMSTRING:");
        strStrArray = StringSerializer.toStringFromArray(strArray);
        StringSerializer.printStrings(strStrArray);
        iStrArray = StringSerializer.toStringFromArray(iArray);
        StringSerializer.printStrings(iStrArray);
        fStrArray = StringSerializer.toStringFromArray(fArray);
        StringSerializer.printStrings(fStrArray);
        dStrArray = StringSerializer.toStringFromArray(dArray);
        StringSerializer.printStrings(dStrArray);
        lStrArray = StringSerializer.toStringFromArray(lArray);
        StringSerializer.printStrings(lStrArray);
        cStrArray = StringSerializer.toStringFromArray(cArray);
        StringSerializer.printStrings(cStrArray);
        bStrArray = StringSerializer.toStringFromArray(bArray);
        StringSerializer.printStrings(bStrArray);
        zStrArray = StringSerializer.toStringFromArray(zArray);
        StringSerializer.printStrings(zStrArray);
        sStrArray = StringSerializer.toStringFromArray(sArray);
        StringSerializer.printStrings(sStrArray);
    }

    private static void printStrings(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            System.out.print(strings[i] + "|");
        }
        System.out.println("");
    }
}

