/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jeus.security.base.Domain;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.spi.GroupNotExistsException;
import jeus.security.spi.SubjectNotExistsException;

public class SubjectContainer {
    private Map subjectsTable = new Hashtable();
    private Map groupsTable = new Hashtable();

    public boolean isSubjectEmpty() {
        return this.subjectsTable.isEmpty();
    }

    public boolean isGroupsEmpty() {
        return this.groupsTable.isEmpty();
    }

    public synchronized void addSubject(Subject subject) throws ServiceException {
        if (subject == null) {
            throw new ServiceException("Failed to add Subject data: Subject is null");
        }
        if (subject.getPrincipal() == null) {
            throw new ServiceException("Failed to add Subject data: Subject Principal is null");
        }
        Object o = this.subjectsTable.get(subject.getPrincipal().getName());
        if (o == null) {
            this.subjectsTable.put(subject.getPrincipal().getName(), subject.clone());
        } else {
            Subject localSubject = (Subject)o;
            localSubject.add(subject);
        }
    }

    public synchronized void removeSubject(Subject subject) throws SubjectNotExistsException, ServiceException {
        if (subject == null) {
            throw new ServiceException("Failed to remove Subject data: Subject is null");
        }
        if (subject.getPrincipal() == null) {
            throw new ServiceException("Failed to remove Subject data: Subject Principal is null");
        }
        Object o = this.subjectsTable.get(subject.getPrincipal().getName());
        if (o == null) {
            throw new SubjectNotExistsException("Could not remove Subject data: the Subject does not exist");
        }
        Subject localSubject = (Subject)o;
        localSubject.remove(subject);
        if (localSubject.isEmpty()) {
            this.subjectsTable.remove(localSubject.getPrincipal().getName());
        }
    }

    public synchronized void removeSubject(String name) throws SubjectNotExistsException, ServiceException {
        if (name == null) {
            throw new ServiceException("Failed to remove Subject: Subject name is null");
        }
        Object o = this.subjectsTable.get(name);
        if (o == null) {
            throw new SubjectNotExistsException("Could not remove Subject: the Subject named " + name + " does not exist");
        }
        this.subjectsTable.remove(name);
    }

    public Subject getSubject(String name) throws SubjectNotExistsException, ServiceException {
        if (name == null) {
            throw new ServiceException("Failed to get Subject data: name is null");
        }
        Object o = this.subjectsTable.get(name);
        if (o == null) {
            throw new SubjectNotExistsException("Could not get Subject data: the Subject " + name + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        Subject localSubject = (Subject)o;
        return (Subject)localSubject.clone();
    }

    public Subject[] getSubjectsAsArray() {
        return this.subjectsTable.values().toArray(new Subject[0]);
    }

    public void addSubjectsFromArray(Subject[] subjects) throws ServiceException {
        for (int i = 0; i < subjects.length; ++i) {
            this.addSubject(subjects[i]);
        }
    }

    public Set getSubjectNames() {
        HashSet result = new HashSet();
        result.addAll(this.subjectsTable.keySet());
        return result;
    }

    public synchronized void clear() {
        this.subjectsTable.clear();
        this.groupsTable.clear();
    }

    public boolean userExists(String userName) {
        return this.subjectsTable.containsKey(userName);
    }

    public boolean groupExist(String groupName) {
        return this.groupsTable.containsKey(groupName);
    }

    public synchronized void addGroup(Group group) {
        this.groupsTable.put(group.getName(), group);
    }

    public synchronized void addUserToGroup(String groupName, Principal principal) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupsTable.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        Object sobj = this.subjectsTable.get(principal.getName());
        if (sobj == null) {
            throw new SubjectNotExistsException("Could not get Subject data: the Subject " + principal.getName() + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        GroupPrincipalImpl group = (GroupPrincipalImpl)obj;
        if (group.addMember(principal)) {
            Subject sub = (Subject)sobj;
            sub.getPrincipals().add(group);
            this.addSubject(sub);
        }
    }

    public Group getGroup(String groupName) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupsTable.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        return (GroupPrincipalImpl)obj;
    }

    public Set getGroupNames() {
        HashSet result = new HashSet();
        result.addAll(this.groupsTable.keySet());
        return result;
    }

    public GroupPrincipalImpl[] getGroupList() {
        return this.groupsTable.values().toArray(new GroupPrincipalImpl[this.groupsTable.size()]);
    }

    public synchronized void removeGroup(String groupName) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupsTable.remove(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        for (Subject subject : this.subjectsTable.values()) {
            subject.removePrincipal((GroupPrincipalImpl)obj);
        }
    }

    public synchronized void removeUserToGroup(String groupName, Principal principal) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupsTable.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        Object sobj = this.subjectsTable.get(principal.getName());
        if (sobj == null) {
            throw new SubjectNotExistsException("Could not get Subject data: the Subject " + principal.getName() + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        GroupPrincipalImpl group = (GroupPrincipalImpl)obj;
        if (group.removeMember(principal)) {
            Subject sub = (Subject)sobj;
            sub.removePrincipal(group);
        }
    }

    public String getGroupDescriptor(String groupName) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupsTable.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        GroupPrincipalImpl group = (GroupPrincipalImpl)obj;
        return group.getDescription();
    }

    public boolean isMember(String groupName, Principal principal) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupsTable.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        GroupPrincipalImpl group = (GroupPrincipalImpl)obj;
        return group.isMember(principal);
    }

    public synchronized Enumeration getMembersFromGroup(String groupName) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupsTable.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        GroupPrincipalImpl group = (GroupPrincipalImpl)obj;
        return group.members();
    }

    public void setGroupTable(Map table) {
        this.groupsTable = table;
    }

    public void printGroupInfo() {
        Iterator groups = this.groupsTable.keySet().iterator();
        while (groups.hasNext()) {
            GroupPrincipalImpl group = (GroupPrincipalImpl)this.groupsTable.get(groups.next());
            System.out.println(group.getName() + " : " + group.toString());
        }
    }
}

