/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class TimedAbstractMap
implements Map {
    volatile transient Set keySet = null;
    volatile transient Collection values = null;

    protected TimedAbstractMap() {
    }

    public int size() {
        return this.entrySet().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(Object value) {
        Iterator i = this.entrySet().iterator();
        if (value == null) {
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                if (e.getValue() != null) continue;
                return true;
            }
        } else {
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                if (!value.equals(e.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        Iterator i = this.entrySet().iterator();
        if (key == null) {
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                if (e.getKey() != null) continue;
                return true;
            }
        } else {
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                if (!key.equals(e.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public Object get(Object key) {
        Iterator i = this.entrySet().iterator();
        if (key == null) {
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                if (e.getKey() != null) continue;
                return e.getValue();
            }
        } else {
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                if (!key.equals(e.getKey())) continue;
                return e.getValue();
            }
        }
        return null;
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        Map.Entry e;
        Iterator i = this.entrySet().iterator();
        Map.Entry correctEntry = null;
        if (key == null) {
            while (correctEntry == null && i.hasNext()) {
                e = (Map.Entry)i.next();
                if (e.getKey() != null) continue;
                correctEntry = e;
            }
        } else {
            while (correctEntry == null && i.hasNext()) {
                e = (Map.Entry)i.next();
                if (!key.equals(e.getKey())) continue;
                correctEntry = e;
            }
        }
        Object oldValue = null;
        if (correctEntry != null) {
            oldValue = correctEntry.getValue();
            i.remove();
        }
        return oldValue;
    }

    public void putAll(Map t) {
        for (Map.Entry e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void clear() {
        this.entrySet().clear();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(){
                        private Iterator i;
                        {
                            this.i = TimedAbstractMap.this.entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getKey();
                        }

                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                public int size() {
                    return TimedAbstractMap.this.size();
                }

                public boolean contains(Object k) {
                    return TimedAbstractMap.this.containsKey(k);
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return new Iterator(){
                        private Iterator i;
                        {
                            this.i = TimedAbstractMap.this.entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getValue();
                        }

                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                public int size() {
                    return TimedAbstractMap.this.size();
                }

                public boolean contains(Object v) {
                    return TimedAbstractMap.this.containsValue(v);
                }
            };
        }
        return this.values;
    }

    public abstract Set entrySet();

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry e : this.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry e = (Map.Entry)i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            buf.append((key == this ? "(this Map)" : key) + "=" + (value == this ? "(this Map)" : value));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        TimedAbstractMap result = (TimedAbstractMap)super.clone();
        result.keySet = null;
        result.values = null;
        return result;
    }

    static class SimpleEntry
    implements Map.Entry {
        Object key;
        Object value;

        public SimpleEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(Map.Entry e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

