/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import jeus.security.base.SKI;
import jeus.security.base.SecurityException;
import jeus.security.resource.UserCertInfo;
import jeus.security.util.Arrays;
import jeus.security.util.Base64Coder;
import jeus.security.util.X509NameTokenizer;

public class X509Util {
    public static boolean isEmpty(CertPath certpath) {
        List<? extends Certificate> list;
        return certpath == null || (list = certpath.getCertificates()) == null || list.size() <= 0;
    }

    public static boolean containsNonX509Certificate(CertPath certpath) {
        if (X509Util.isEmpty(certpath)) {
            return false;
        }
        List<? extends Certificate> list = certpath.getCertificates();
        for (int i = 0; i < list.size(); ++i) {
            Certificate obj = list.get(i);
            if (obj instanceof X509Certificate) continue;
            return true;
        }
        return false;
    }

    public static X509Certificate[] getCertificates(CertPath certpath) {
        if (X509Util.isEmpty(certpath)) {
            return new X509Certificate[0];
        }
        List<? extends Certificate> list = certpath.getCertificates();
        return list.toArray(new X509Certificate[list.size()]);
    }

    public static void validateOrdered(CertPath certpath) throws CertificateException {
        if (X509Util.isEmpty(certpath)) {
            return;
        }
        if (X509Util.containsNonX509Certificate(certpath)) {
            throw new AssertionError((Object)"Received a cert path containing a non-X509 certificate");
        }
        X509Certificate[] ax509certificate = X509Util.getCertificates(certpath);
        if (ax509certificate == null || ax509certificate.length < 2) {
            return;
        }
        for (int i = 0; i < ax509certificate.length - 1; ++i) {
            if (X509Util.isSelfSigned(ax509certificate[i])) {
                throw new CertificateException(ax509certificate[i].toString());
            }
            X509Util.validateIssuedBy(ax509certificate[i], ax509certificate[i + 1]);
        }
    }

    public static boolean isOrdered(CertPath certpath) {
        try {
            X509Util.validateOrdered(certpath);
            return true;
        }
        catch (CertificateException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getName(X500Principal x500principal) {
        return x500principal == null ? null : x500principal.getName("RFC2253");
    }

    public static boolean sameX500Principal(X500Principal x500principal, X500Principal x500principal1) {
        if (x500principal == null && x500principal1 == null) {
            return true;
        }
        if (x500principal != null && x500principal1 == null) {
            return false;
        }
        if (x500principal == null && x500principal1 != null) {
            return false;
        }
        String s = X509Util.getName(x500principal);
        String s1 = X509Util.getName(x500principal1);
        return s.equals(s1);
    }

    public static String getSubjectDN(X509Certificate x509certificate) {
        return X509Util.getName(x509certificate.getSubjectX500Principal());
    }

    public static String getIssuerDN(X509Certificate x509certificate) {
        return X509Util.getName(x509certificate.getIssuerX500Principal());
    }

    public static String getIssuerDNAndSerialNo(X509Certificate x509certificate) {
        return X509Util.getIssuerDN(x509certificate) + x509certificate.getSerialNumber();
    }

    public static void validateIssuedBy(X509Certificate x509certificate, X509Certificate x509certificate1) throws CertificateException {
        if (!X509Util.getIssuerDN(x509certificate).equals(X509Util.getSubjectDN(x509certificate1))) {
            throw new CertificateException(x509certificate.toString() + ":" + x509certificate1.toString());
        }
        try {
            x509certificate.verify(x509certificate1.getPublicKey());
        }
        catch (Exception exception) {
            throw new CertificateException(x509certificate.toString() + ":" + x509certificate1.toString());
        }
    }

    public static boolean isIssuedBy(X509Certificate x509certificate, X509Certificate x509certificate1) {
        try {
            X509Util.validateIssuedBy(x509certificate, x509certificate1);
            return true;
        }
        catch (CertificateException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isSelfSigned(X509Certificate x509certificate) {
        return X509Util.isIssuedBy(x509certificate, x509certificate);
    }

    public static byte[] getSKIBytesFromCert(X509Certificate cert) {
        String SKI_OID = "2.5.29.14";
        byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
        if (cert.getVersion() < 3 || derEncodedValue == null) {
            MessageDigest sha;
            PublicKey key = cert.getPublicKey();
            if (!(key instanceof RSAPublicKey)) {
                System.err.println("Support for RSA key only");
                return null;
            }
            byte[] encoded = key.getEncoded();
            byte[] value = new byte[encoded.length - 22];
            System.arraycopy(encoded, 22, value, 0, value.length);
            try {
                sha = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
                return null;
            }
            sha.reset();
            sha.update(value);
            return sha.digest();
        }
        byte[] abyte0 = new byte[derEncodedValue.length - 4];
        System.arraycopy(derEncodedValue, 4, abyte0, 0, abyte0.length);
        return abyte0;
    }

    public static X509Certificate getCertInTrustStore(KeyStore trustStore, String alias) throws KeyStoreException {
        Certificate[] certs = trustStore.getCertificateChain(alias);
        if (certs != null) {
            return (X509Certificate)certs[0];
        }
        return null;
    }

    public static String getAliasInTrustStore(KeyStore keyStore, X509Certificate token) {
        Enumeration<String> aliases = null;
        try {
            aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                if (!((Object)token.getIssuerDN()).equals(cert.getIssuerDN())) continue;
                try {
                    token.verify(cert.getPublicKey());
                }
                catch (CertificateException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvalidKeyException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (NoSuchProviderException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (SignatureException e) {
                    e.printStackTrace();
                    continue;
                }
                return alias;
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static CertPath createCertPath(Certificate[] certs) {
        try {
            if (certs != null) {
                CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                CertPath path = certFact.generateCertPath(java.util.Arrays.asList(certs));
                return path;
            }
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static X509Certificate getCertInTrustStore(KeyStore keyStore, Principal subjectDN) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            if (cert == null || !((Object)cert.getSubjectDN()).equals(subjectDN)) continue;
            return cert;
        }
        return null;
    }

    public static SKI[] getSKIsInTrustStore(KeyStore trustStore) throws Exception {
        Enumeration<String> aliases = trustStore.aliases();
        ArrayList<SKI> skis = new ArrayList<SKI>();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate cert = (X509Certificate)trustStore.getCertificate(alias);
            String ski = Base64Coder.byteArrayToBase64(X509Util.getSKIBytesFromCert(cert));
            skis.add(new SKI(ski));
        }
        return skis.toArray(new SKI[0]);
    }

    public static X509Certificate getCertInTrustStore(KeyStore trustStore, SKI ski) throws KeyStoreException {
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            byte[] refSki;
            String alias = aliases.nextElement();
            X509Certificate cert = (X509Certificate)trustStore.getCertificate(alias);
            byte[] proofSki = Base64Coder.base64ToByteArray(ski.getValue());
            if (!Arrays.compareByteArrays(proofSki, refSki = X509Util.getSKIBytesFromCert(cert))) continue;
            return cert;
        }
        return null;
    }

    public static X509Certificate getCertInTrustStore(KeyStore trustStore, Principal issuerDN, BigInteger serial) throws KeyStoreException {
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate cert = (X509Certificate)trustStore.getCertificate(alias);
            if (!((Object)cert.getIssuerDN()).equals(issuerDN) || !cert.getSerialNumber().equals(serial)) continue;
            return cert;
        }
        return null;
    }

    public static X509Certificate getCertInKeyStore(Map userCertMap, KeyStore keyStore, String user) throws KeyStoreException, SecurityException {
        UserCertInfo info = (UserCertInfo)userCertMap.get(user);
        if (info == null) {
            throw new SecurityException("Could not get Certificate: the alias does not exist for user{" + user + "}");
        }
        String alias = info.getAlias();
        if (alias == null) {
            throw new SecurityException("Could not get Certificate: the alias does not exist for user{" + user + "}");
        }
        Certificate[] certs = keyStore.getCertificateChain(alias);
        X509Certificate cert = certs == null || certs.length == 0 ? (X509Certificate)keyStore.getCertificate(alias) : (X509Certificate)certs[0];
        return cert;
    }

    public static SKI[] getSKIsInKeyStore(KeyStore keyStore) throws Exception {
        Enumeration<String> aliases = keyStore.aliases();
        ArrayList<SKI> skis = new ArrayList<SKI>();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate[] certs = keyStore.getCertificateChain(alias);
            X509Certificate cert = certs == null || certs.length == 0 ? (X509Certificate)keyStore.getCertificate(alias) : (X509Certificate)certs[0];
            if (cert == null) continue;
            String ski = Base64Coder.byteArrayToBase64(X509Util.getSKIBytesFromCert(cert));
            skis.add(new SKI(ski));
        }
        return skis.toArray(new SKI[skis.size()]);
    }

    public static X509Certificate getCertInKeyStore(KeyStore keyStore, SKI ski) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        byte[] proofSki = Base64Coder.base64ToByteArray(ski.getValue());
        while (aliases.hasMoreElements()) {
            X509Certificate cert;
            byte[] refSki;
            String alias = aliases.nextElement();
            Certificate[] certs = keyStore.getCertificateChain(alias);
            if (certs == null || certs.length <= 0 || !Arrays.compareByteArrays(proofSki, refSki = X509Util.getSKIBytesFromCert(cert = (X509Certificate)certs[0]))) continue;
            return cert;
        }
        return null;
    }

    public static X509Certificate getCertInKeyStore(KeyStore keyStore, Principal issuerDN, BigInteger serial) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            X509Certificate cert;
            String alias = aliases.nextElement();
            Certificate[] certs = keyStore.getCertificateChain(alias);
            if (certs == null || certs.length <= 0 || !((Object)(cert = (X509Certificate)certs[0]).getIssuerDN()).equals(issuerDN) || !cert.getSerialNumber().equals(serial)) continue;
            return cert;
        }
        return null;
    }

    public static X509Certificate getCertInKeyStore(KeyStore keyStore, Principal subjectDN) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            X509Certificate cert;
            String alias = aliases.nextElement();
            Certificate[] certs = keyStore.getCertificateChain(alias);
            if (certs == null || certs.length <= 0 || !((Object)(cert = (X509Certificate)certs[0]).getSubjectDN()).equals(subjectDN)) continue;
            return cert;
        }
        return null;
    }

    public static List getCertificates(Map userCertMap, KeyStore keyStore, String user, char[] keyStorePwd) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, SecurityException {
        UserCertInfo info = (UserCertInfo)userCertMap.get(user);
        if (info == null) {
            throw new SecurityException("Could not get PrivateKey: the alias does not exist for user{" + user + "}");
        }
        String alias = info.getAlias();
        char[] password = info.getKeyPassword();
        if (password == null) {
            password = keyStorePwd;
        }
        return java.util.Arrays.asList(keyStore.getCertificateChain(alias));
    }

    public static PrivateKey getPrivateKey(Map userCertMap, KeyStore keyStore, String user, char[] keyStorePwd) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, SecurityException {
        UserCertInfo info = (UserCertInfo)userCertMap.get(user);
        if (info == null) {
            throw new SecurityException("Could not get PrivateKey: the alias does not exist for user{" + user + "}");
        }
        String alias = info.getAlias();
        char[] password = info.getKeyPassword();
        if (password == null) {
            password = keyStorePwd;
        }
        return (PrivateKey)keyStore.getKey(alias, password);
    }

    private static char[] getKeyPasswordInUserCertInfo(Map userCertMap, String alias) {
        for (UserCertInfo info : userCertMap.values()) {
            if (!info.getAlias().equals(alias)) continue;
            return info.getKeyPassword();
        }
        return null;
    }

    public static PrivateKey getPrivateKey(Map userCertMap, KeyStore keyStore, Principal subjectDN, char[] keyStorePwd) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, SecurityException {
        String alias = X509Util.getAliasForDN(keyStore, subjectDN.getName());
        char[] password = null;
        if (userCertMap.size() > 0) {
            password = X509Util.getKeyPasswordInUserCertInfo(userCertMap, alias);
        }
        if (password == null) {
            password = keyStorePwd;
        }
        return (PrivateKey)keyStore.getKey(alias, password);
    }

    public static PrivateKey getPrivateKey(Map userCertMap, KeyStore keyStore, SKI ski, char[] keyStorePwd) throws Exception {
        String alias = X509Util.getAliasForX509Cert(keyStore, Base64Coder.base64ToByteArray(ski.getValue()));
        char[] password = null;
        if (userCertMap.size() > 0) {
            password = X509Util.getKeyPasswordInUserCertInfo(userCertMap, alias);
        }
        if (password == null) {
            password = keyStorePwd;
        }
        return (PrivateKey)keyStore.getKey(alias, password);
    }

    public static PrivateKey getPrivateKey(Map userCertMap, KeyStore keyStore, Principal issuerDN, BigInteger serial, char[] keyStorePwd) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, SecurityException {
        String alias = X509Util.getAliasForX509Cert(keyStore, issuerDN.getName(), serial);
        char[] password = null;
        if (userCertMap.size() > 0) {
            password = X509Util.getKeyPasswordInUserCertInfo(userCertMap, alias);
        }
        if (password == null) {
            password = keyStorePwd;
        }
        return (PrivateKey)keyStore.getKey(alias, password);
    }

    public static boolean isValid(KeyStore truststore, KeyStore keystore, X509Certificate cert, boolean checkCRL) throws KeyStoreException {
        return truststore.getCertificateAlias(cert) != null || keystore.getCertificateAlias(cert) != null;
    }

    public static String getAliasForX509Cert(KeyStore keystore, byte[] skiBytes) throws SecurityException {
        boolean found = false;
        try {
            Enumeration<String> e = keystore.aliases();
            while (e.hasMoreElements()) {
                byte[] data;
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = keystore.getCertificate(alias);
                    if (cert == null) {
                        continue;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || (data = X509Util.getSKIBytesFromCert((X509Certificate)cert)).length != skiBytes.length || !java.util.Arrays.equals(data, skiBytes)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e.getMessage(), e);
        }
        return null;
    }

    public static String getAliasForDN(KeyStore keystore, String subjectDN) throws SecurityException {
        try {
            Enumeration<String> e = keystore.aliases();
            while (e.hasMoreElements()) {
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = keystore.getCertificate(alias);
                    if (cert == null) {
                        continue;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || !((X509Certificate)cert).getSubjectDN().getName().equals(subjectDN)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e.getMessage(), e);
        }
        return null;
    }

    public static String getAliasForX509Cert(KeyStore keystore, String issuer, BigInteger serialNumber) throws SecurityException {
        Vector issuerRDN = X509Util.splitAndTrim(issuer);
        boolean useSerialNumber = true;
        try {
            Enumeration<String> e = keystore.aliases();
            while (e.hasMoreElements()) {
                Vector certRDN;
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = keystore.getCertificate(alias);
                    if (cert == null) {
                        continue;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate)) continue;
                X509Certificate x509cert = (X509Certificate)cert;
                if (useSerialNumber && (!useSerialNumber || x509cert.getSerialNumber().compareTo(serialNumber) != 0) || !(certRDN = X509Util.splitAndTrim(x509cert.getIssuerX500Principal().getName())).equals(issuerRDN)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e.getMessage(), e);
        }
        return null;
    }

    private static Vector splitAndTrim(String inString) {
        X509NameTokenizer nmTokens = new X509NameTokenizer(inString);
        Vector<String> vr = new Vector<String>();
        while (nmTokens.hasMoreTokens()) {
            vr.add(nmTokens.nextToken());
        }
        Collections.sort(vr);
        return vr;
    }

    public static String getAliasForX509CertThumb(KeyStore keystore, byte[] thumb) throws SecurityException {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new SecurityException(e1.getMessage(), e1);
        }
        try {
            Enumeration<String> e = keystore.aliases();
            while (e.hasMoreElements()) {
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = keystore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate)) continue;
                sha.reset();
                try {
                    sha.update(cert.getEncoded());
                }
                catch (CertificateEncodingException e1) {
                    throw new SecurityException(e1.getMessage(), e1);
                }
                byte[] data = sha.digest();
                if (!java.util.Arrays.equals(data, thumb)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e.getMessage(), e);
        }
        return null;
    }

    public static String getSubjectDNFromCertificate(X509Certificate cert, String certAttrKey, String delimiter) {
        String subjectDN = cert.getSubjectDN().getName();
        String value = "";
        StringTokenizer subjectDNToken = new StringTokenizer(subjectDN, delimiter);
        while (subjectDNToken.hasMoreTokens()) {
            String token = subjectDNToken.nextToken().trim();
            int offset = token.indexOf("=");
            String type = token.substring(0, offset);
            value = token.substring(offset + 1);
            if (!type.equals(certAttrKey)) continue;
            break;
        }
        if (delimiter != null && delimiter.length() > 0 && value.indexOf(delimiter) != -1) {
            value = value.substring(0, value.indexOf(delimiter));
        }
        return value;
    }
}

