/*
 * Decompiled with CFR 0.152.
 */
package jeus.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jeus.server.JeusBootstrapper;
import jeus.server.RootClassLoader;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusBootstrapPropertyValues;

public class Bootstrapper {
    private static final String fs = File.separator;
    protected static final String clsp = File.pathSeparator;
    private static final String SET_PROPERTY_PREFIX = "-D";
    private static final String SET_PROPERTY_FILE_PREFIX = "-properties=";
    private static final Set EXCLUDE_SET = new HashSet();

    protected static RootClassLoader initClassloader() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        String path = JeusBootstrapProperties.PREPEND_CLASSPATH;
        if (path != null) {
            Bootstrapper.addClassPath(path, urls);
        }
        Bootstrapper.printClassPath(urls);
        if (JeusBootstrapProperties.JEUS_HOME != null) {
            String jeusHome = JeusBootstrapProperties.JEUS_HOME;
            urls.add(JeusBootstrapPropertyValues.makeUrlFromPath(jeusHome + fs + "lib" + fs + "system" + fs + "jeus.jar"));
            urls.add(JeusBootstrapPropertyValues.makeUrlFromPath(JeusBootstrapProperties.JDK_HOME + fs + "lib" + fs + "tools.jar"));
            String dir = jeusHome + fs + "lib" + fs + "system";
            Bootstrapper.addJarFilesInDirectory(dir, urls, EXCLUDE_SET);
            urls.add(JeusBootstrapPropertyValues.makeUrlFromPath(jeusHome + fs + "lib" + fs + "application/"));
            dir = jeusHome + fs + "lib" + fs + "thirdparty";
            Bootstrapper.addJarFilesInDirectory(dir, urls, null);
            dir = jeusHome + fs + "lib" + fs + "application";
            File f = new File(dir);
            if (f.exists()) {
                Bootstrapper.makeClassPath(f, urls);
            }
            dir = jeusHome + fs + "lib" + fs + "datasource";
            Bootstrapper.addJarFilesInDirectory(dir, urls, null);
        }
        if ((path = JeusBootstrapProperties.SERVER_CLASSPATH) != null) {
            Bootstrapper.addClassPath(path, urls);
        }
        Properties p = System.getProperties();
        String prefix = "jeus.server.classpath.";
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(prefix)) continue;
            Bootstrapper.addClassPath(System.getProperty(name), urls);
        }
        path = JeusBootstrapProperties.SERVER_LIB_PATH;
        if (path != null) {
            Bootstrapper.addLibPath(path, urls);
        }
        URL[] srcURL = new URL[urls.size()];
        srcURL = urls.toArray(srcURL);
        if (JeusBootstrapProperties.PRINT_CLASSPATH) {
            for (int i = 0; i < srcURL.length; ++i) {
                URL url = srcURL[i];
                System.out.println("jeus classpath : " + url);
            }
        }
        return new RootClassLoader(srcURL, JeusBootstrapper.class.getClassLoader());
    }

    private static void addJarFilesInDirectory(String dir, ArrayList urls, Set excludeSet) throws MalformedURLException {
        File f = new File(dir);
        if (f.exists()) {
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                if (excludeSet != null && excludeSet.contains(files[i]) || files[i].lastIndexOf(46) == -1 || !files[i].substring(files[i].lastIndexOf(46) + 1).equals("jar") && !files[i].substring(files[i].lastIndexOf(46) + 1).equals("zip")) continue;
                urls.add(JeusBootstrapPropertyValues.makeUrlFromPath(dir + fs + files[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printClassPath(ArrayList urls) {
        for (int i = 0; i < urls.size(); ++i) {
            URL url = (URL)urls.get(i);
            InputStream is = null;
            try {
                URLConnection urlConnection = url.openConnection();
                is = urlConnection.getInputStream();
                System.out.println("JEUS prepend classpath : " + url);
                continue;
            }
            catch (IOException e) {
                continue;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private static void addClassPath(String path, ArrayList urls) throws MalformedURLException {
        while (true) {
            int idx;
            if ((idx = path.indexOf(clsp)) == -1) {
                File file = new File(path);
                Bootstrapper.addUrl(file, urls, path);
                break;
            }
            String url = path.substring(0, idx);
            File file = new File(url);
            Bootstrapper.addUrl(file, urls, url);
            if (idx + 1 == path.length()) break;
            path = path.substring(idx + 1);
        }
    }

    private static void addLibPath(String path, ArrayList urls) throws MalformedURLException {
        while (true) {
            int idx;
            if ((idx = path.indexOf(clsp)) == -1) {
                Bootstrapper.addJarFilesInDirectory(path, urls, null);
                break;
            }
            String url = path.substring(0, idx);
            Bootstrapper.addJarFilesInDirectory(url, urls, null);
            if (idx + 1 == path.length()) break;
            path = path.substring(idx + 1);
        }
    }

    private static void addUrl(File file, ArrayList urls, String path) throws MalformedURLException {
        String url;
        if (file.isAbsolute()) {
            url = path;
        } else {
            String absolutePath = JeusBootstrapProperties.JEUS_HOME != null ? JeusBootstrapProperties.JEUS_HOME + fs + "lib" + fs + "system" + fs + path : JeusBootstrapPropertyValues.CURRENT_DIRECTORY + fs + path;
            url = absolutePath;
            file = new File(absolutePath);
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                url = url + "/";
            }
            urls.add(JeusBootstrapPropertyValues.makeUrlFromPath(url));
        }
    }

    private static void makeClassPath(File f, ArrayList urls) throws Exception {
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                if (files[i].getName().lastIndexOf(46) == -1 || !files[i].getName().substring(files[i].getName().lastIndexOf(46) + 1).equals("jar") && !files[i].getName().substring(files[i].getName().lastIndexOf(46) + 1).equals("zip")) continue;
                urls.add(JeusBootstrapPropertyValues.makeUrlFromPath(files[i].getAbsolutePath()));
                continue;
            }
            if (!files[i].isDirectory()) continue;
            Bootstrapper.makeClassPath(files[i], urls);
        }
    }

    protected static void callMainMethod(URLClassLoader bootstrapLoader, String category, String className, String[] args) throws Exception {
        Class cl;
        Thread.currentThread().setName(className);
        if (category != null) {
            Class JeusVersionClass;
            String jvmID;
            Class propertyValueClass = ((RootClassLoader)bootstrapLoader).loadClassFromSuper("jeus.util.properties.JeusPropertyValues", false);
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            if (propertyValueClass != null) {
                Field field = propertyValueClass.getField("JEUS_CATEGORY");
                int categoryInt = propertyValueClass.getField(category).getInt(null);
                field.setInt(null, categoryInt);
                thread.setContextClassLoader(bootstrapLoader);
                if (categoryInt == 1) {
                    Class virtualDNSClass = ((RootClassLoader)bootstrapLoader).loadClassFromSuper("jeus.util.VirtualDNS", false);
                    jvmID = (String)virtualDNSClass.getField("LOCAL_VIRTUALNAME").get(null);
                } else {
                    jvmID = categoryInt == 2 ? args[0].substring(args[0].lastIndexOf(95) + 1) : "client";
                }
            } else {
                jvmID = "client";
            }
            Class loggerClass = ((RootClassLoader)bootstrapLoader).loadClassFromSuper("jeus.util.logging.JeusLogRecord", false);
            if (loggerClass != null) {
                Field field1 = loggerClass.getField("JVM_ID");
                field1.set(null, jvmID);
            }
            if ((JeusVersionClass = ((RootClassLoader)bootstrapLoader).loadClassFromSuper("jeus.server.manager.JeusVersion", false)) != null) {
                String bVersion = (String)JeusVersionClass.getMethod("getBuildVersion", null).invoke(null, null);
                Class simpleFomatterClass = ((RootClassLoader)bootstrapLoader).loadClassFromSuper("jeus.util.logging.SimpleFormatter", false);
                Field field2 = simpleFomatterClass.getField("BUILD_VERSION");
                field2.set(null, bVersion);
            }
            thread.setContextClassLoader(loader);
        }
        if ((cl = ((RootClassLoader)bootstrapLoader).loadClassFromSuper(className, false)) == null) {
            throw new RuntimeException("wrong class name, cannot find the class " + className);
        }
        Thread.currentThread().setContextClassLoader(cl.getClassLoader());
        Class[] argTypes = new Class[]{new String[0].getClass()};
        Method m = cl.getDeclaredMethod("main", argTypes);
        m.invoke(null, new Object[]{args});
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Error: It needs main class name as the first argument.");
            Bootstrapper.usage(System.err);
            return;
        }
        Bootstrapper.main(args[0], "JEUS_CLIENT", args, 1);
    }

    public static void main(String mainClass, String category, String[] args, int index) {
        String[] innerArgs = new String[args.length - index];
        System.arraycopy(args, index, innerArgs, 0, innerArgs.length);
        int currentArgIndex = 0;
        while (currentArgIndex < innerArgs.length) {
            String arg = innerArgs[currentArgIndex];
            if (arg.startsWith(SET_PROPERTY_PREFIX)) {
                String value;
                String key;
                int endIndex = arg.indexOf(61);
                if (endIndex >= 0) {
                    key = arg.substring(SET_PROPERTY_PREFIX.length(), endIndex);
                    value = arg.substring(endIndex + 1);
                } else {
                    key = arg.substring(SET_PROPERTY_PREFIX.length());
                    value = "";
                }
                System.setProperty(key, value);
                innerArgs = Bootstrapper.removeElements(innerArgs, new int[]{currentArgIndex});
                continue;
            }
            if (arg.startsWith(SET_PROPERTY_FILE_PREFIX)) {
                try {
                    FileInputStream fis = new FileInputStream(arg.substring(SET_PROPERTY_FILE_PREFIX.length()));
                    Properties prev = System.getProperties();
                    Properties p = new Properties();
                    p.load(fis);
                    p.putAll((Map<?, ?>)prev);
                    System.setProperties(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                innerArgs = Bootstrapper.removeElements(innerArgs, new int[]{currentArgIndex});
                continue;
            }
            ++currentArgIndex;
        }
        Bootstrapper.callMain(category, mainClass, innerArgs);
    }

    protected static void callMain(String nodeCategory, String mainClass, String[] args) {
        try {
            RootClassLoader bootstrapLoader = Bootstrapper.initClassloader();
            Bootstrapper.callMainMethod(bootstrapLoader, nodeCategory, mainClass, args);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Error: Could not load the main class " + mainClass);
        }
        catch (InvocationTargetException ex) {
            ex.getTargetException().printStackTrace();
        }
        catch (Throwable t) {
            System.err.println("Error: Bootstrapping Failed");
            t.printStackTrace();
        }
    }

    protected static void usage(PrintStream out) {
        out.println("usage:");
        out.println("  java -classpath ${JEUS_HOME}/lib/system/bootstrap.jar -Djeus.home=${JEUS_HOME} jeus.server.Bootstrapper main_class_name [options] [arg0 arg1...]");
        out.println();
        out.println("  options:");
        out.println("   -setProperty{key=value}        set system property with key=value");
        out.println("   -setPropertyFile=file_path     set system properties file");
    }

    public static String[] removeElements(String[] args, int[] idxs) {
        String[] temp = new String[args.length - idxs.length];
        int removed = 0;
        block0: for (int i = 0; i < args.length; ++i) {
            for (int j = 0; j < idxs.length; ++j) {
                if (i != idxs[j]) continue;
                ++removed;
                continue block0;
            }
            temp[i - removed] = args[i];
        }
        return temp;
    }

    static {
        EXCLUDE_SET.add("jeus.jar");
        EXCLUDE_SET.add("extension.jar");
        EXCLUDE_SET.add("bootstrap.jar");
        EXCLUDE_SET.add("jext.jar");
    }
}

