/*
 * Decompiled with CFR 0.152.
 */
package jeus.server;

import java.util.Enumeration;
import javax.management.ObjectName;
import jeus.management.JMXManager;
import jeus.security.util.LoginUtil;
import jeus.server.VirtualTerminal;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.properties.JeusEngineContainerProperties;

public class ContainerMonitorThread
extends Thread {
    private ObjectName containerManagerServiceName;
    private Thread currThread;
    private final Object sync = new Object();
    private boolean exported = false;
    private static final long ALIVECHECK_PERIOD = JeusEngineContainerProperties.CONTAINER_MONITOR_PERIOD;
    private static final int NUM_CHECK_RETRY = JeusEngineContainerProperties.CONTAINER_MONITOR_RETRY_COUNT;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");

    public ContainerMonitorThread(ObjectName containerManagerServiceName) {
        super("jeus.server.ContainerMonitorThread");
        this.setDaemon(true);
        this.containerManagerServiceName = containerManagerServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() {
        Object object = this.sync;
        synchronized (object) {
            this.exported = true;
            this.sync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexport() {
        Object object = this.sync;
        synchronized (object) {
            this.exported = false;
        }
        this.currThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            this.currThread = Thread.currentThread();
            while (true) {
                Object object = this.sync;
                synchronized (object) {
                    if (this.exported) {
                        break;
                    }
                    do {
                        try {
                            this.sync.wait();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    } while (!this.exported);
                }
                if (logger.isLoggable(JeusMessage_Manager._196_LEVEL)) {
                    logger.log(JeusMessage_Manager._196_LEVEL, JeusMessage_Manager._196);
                }
                block24: while (true) {
                    try {
                        Thread.sleep(ALIVECHECK_PERIOD);
                    }
                    catch (Throwable t) {
                        Thread.interrupted();
                    }
                    if (!this.exported) break;
                    Enumeration terminals = null;
                    try {
                        terminals = (Enumeration)JMXManager.getMbeanServer().getAttribute(this.containerManagerServiceName, "VirtualTerminals");
                    }
                    catch (Throwable e) {
                        if (!logger.isLoggable(JeusMessage_Manager._197_LEVEL)) continue;
                        logger.log(JeusMessage_Manager._197_LEVEL, JeusMessage_Manager._197, e);
                        continue;
                    }
                    block25: while (true) {
                        VirtualTerminal term;
                        if (!terminals.hasMoreElements()) continue block24;
                        try {
                            term = (VirtualTerminal)terminals.nextElement();
                        }
                        catch (Throwable ex) {
                            continue block24;
                        }
                        if (!this.exported) break block24;
                        try {
                            try {
                                int count = NUM_CHECK_RETRY;
                                while (true) {
                                    try {
                                        term.checkAlive();
                                        continue block25;
                                    }
                                    catch (Throwable th) {
                                        if (count > 0) {
                                            --count;
                                            continue;
                                        }
                                        throw th;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable t) {
                                if (!this.exported) break block24;
                                if (logger.isLoggable(JeusMessage_Manager._198_LEVEL)) {
                                    logger.log(JeusMessage_Manager._198_LEVEL, JeusMessage_Manager._198, (Object)term.getContainerName(), t);
                                }
                                try {
                                    term.kill(true);
                                    if (!logger.isLoggable(JeusMessage_Manager._199_LEVEL)) continue;
                                    logger.log(JeusMessage_Manager._199_LEVEL, JeusMessage_Manager._199, (Object)term.getContainerName(), t);
                                }
                                catch (Throwable t1) {
                                    if (!logger.isLoggable(JeusMessage_Manager._200_LEVEL)) continue;
                                    logger.log(JeusMessage_Manager._200_LEVEL, JeusMessage_Manager._200, (Object)term.getContainerName(), t1);
                                }
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    break;
                }
                if (!logger.isLoggable(JeusMessage_Manager._201_LEVEL)) continue;
                logger.log(JeusMessage_Manager._201_LEVEL, JeusMessage_Manager._201);
            }
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }
}

