/*
 * Decompiled with CFR 0.152.
 */
package jeus.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.management.JMXManager;
import jeus.management.JMXUtility;
import jeus.security.util.PermissionMaker;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.service.ContainerManagerServiceMBean;
import jeus.util.JarExtractor;
import jeus.util.VirtualDNS;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMX;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusSystemType;

public class ControlThread
implements Runnable {
    private static final String fs = System.getProperty("file.separator");
    private static final char fsc = fs.charAt(0);
    private static final int idleTime = 60000;
    private static final int operationTO = 10000;
    private static final int bufferSize = 33792;
    private static final int magicNum = 973630;
    private static final int ftpChunkSize = 32768;
    private JeusServer server;
    private Socket link;
    private DataInputStream input;
    private DataOutputStream output;
    private byte[] fileBuffer;
    private File ftpFile;
    private FileOutputStream destination;
    private JarExtractor extractor;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.nodecontroller");
    private static final String permissionName = "jeus.server." + VirtualDNS.LOCAL_VIRTUALNAME;
    private static final Permission ftpPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"ftp");
    private static final Permission rftpPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"rftp");
    private static final Permission read_hostnamePermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"read_hostname");
    private static final Permission bootAllPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"bootall");
    private static final Permission downAllPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"downall");
    private static final Permission exitAllPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"exitall");
    private static final Permission read_configPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"read_config");
    private static final Permission write_configPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"write_config");
    private static final Permission read_virtualhost = PermissionMaker.makeResourcePermission((String)permissionName, (String)"read_virtualhost");
    private ContainerManagerServiceMBean containerManagerService;

    public ControlThread(JeusServer server) {
        block2: {
            this.fileBuffer = null;
            this.server = server;
            try {
                this.containerManagerService = JMXUtility.getProxy((MBeanServerConnection)JMXManager.getMbeanServer(), server.getContainerManagerServiceName(), ContainerManagerServiceMBean.class, false);
            }
            catch (Throwable e) {
                if (!logger.isLoggable(JeusMessage_JMX.JMX_14_LEVEL)) break block2;
                logger.log(JeusMessage_JMX.JMX_14_LEVEL, JeusMessage_JMX.JMX_14);
            }
        }
        this.extractor = new JarExtractor();
    }

    public void run() {
        this.acceptRequests();
        this.suspendNew();
    }

    public void resumeNew(Socket socket) throws JeusServerException {
        this.link = socket;
        try {
            this.link.setSoLinger(true, 5000);
            this.link.setTcpNoDelay(true);
            this.input = new DataInputStream(new BufferedInputStream(socket.getInputStream(), 33792));
            this.output = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 33792));
        }
        catch (Throwable ex) {
            throw new JeusServerException(JeusMessage_Manager._202, ex);
        }
    }

    public void suspendNew() {
        try {
            this.link.shutdownInput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.link.shutdownOutput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.link.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.link = null;
        this.input = null;
        this.output = null;
    }

    /*
     * Exception decompiling
     */
    private void acceptRequests() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 75[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeAuthenticationFailed(Exception ex) throws IOException {
        if (logger.isLoggable(JeusMessage_Manager._368_LEVEL)) {
            logger.log(JeusMessage_Manager._368_LEVEL, JeusMessage_Manager._368);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log("", (Throwable)ex);
        }
        this.output.writeInt(-1);
        this.output.flush();
    }

    private List getNodeFromDescriptor() throws IOException {
        JeusSystemType jeusSystem = JeusMainDescriptorJB.getJeusMainDescriptor();
        ArrayList<String> nodelist = new ArrayList<String>();
        List nodes = jeusSystem.getNode();
        for (int i = 0; i < nodes.size(); ++i) {
            JeusNodeType nodeType = (JeusNodeType)nodes.get(i);
            nodelist.add(nodeType.getName());
        }
        return nodelist;
    }

    private boolean checkMagicNumber() throws IOException {
        int ch4;
        int ch3;
        int ch1 = this.input.read();
        if (ch1 == -1) {
            return false;
        }
        int ch2 = this.input.read();
        int magic = (ch1 << 24) + (ch2 << 16) + ((ch3 = this.input.read()) << 8) + ((ch4 = this.input.read()) << 0);
        return magic == 973630;
    }

    private void createFile(String fileName) throws JeusServerException {
        try {
            this.ftpFile = new File(fileName);
            if (this.ftpFile.getParent() != null) {
                new File(this.ftpFile.getParent()).mkdirs();
            }
            this.destination = new FileOutputStream(this.ftpFile);
        }
        catch (Throwable ex) {
            throw new JeusServerException(JeusMessage_Manager._234, fileName, ex);
        }
    }
}

