/*
 * Decompiled with CFR 0.152.
 */
package jeus.server;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.Permission;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.ObjectName;
import javax.xml.bind.JAXBException;
import jeus.deploy.archivist.FileArchive;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.management.JMXManager;
import jeus.management.JMXUtility;
import jeus.management.enterprise.agent.ClusterChecker;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.j2ee.J2EEDomain;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.JEUSManager;
import jeus.management.j2ee.JVM;
import jeus.management.j2ee.manager.JeusProcess;
import jeus.net.impl.ClusterInfo;
import jeus.net.impl.NodeInfo;
import jeus.security.base.Environment;
import jeus.security.base.Subject;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.LoginUtil;
import jeus.security.util.PasswordFileManager;
import jeus.security.util.PermissionMaker;
import jeus.server.CommonProcessInitializer;
import jeus.server.JeusServerException;
import jeus.server.RootClassLoader;
import jeus.server.cluster.NodeEntry;
import jeus.server.service.ClusterService;
import jeus.server.service.JEUSService;
import jeus.server.service.JeusLogService;
import jeus.server.service.util.JeusManagerServiceList;
import jeus.server.service.util.JeusServerServiceList;
import jeus.server.service.util.JeusServiceList;
import jeus.util.ErrorMsgManager;
import jeus.util.FileMonitor;
import jeus.util.FileMonitorTask;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusPooledExecutorFactory;
import jeus.util.JeusPort;
import jeus.util.JeusPrintStream;
import jeus.util.JeusProperties;
import jeus.util.JeusRootClassLoader;
import jeus.util.JeusRuntimeException;
import jeus.util.LicenseException;
import jeus.util.Logger;
import jeus.util.PooledExecutorFactory;
import jeus.util.Runner;
import jeus.util.ScheduledExecutor;
import jeus.util.StatisticRefinedThreadPoolExecutor;
import jeus.util.VirtualDNS;
import jeus.util.console.JeusConsole;
import jeus.util.logging.JeusLogManager;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.JeusLoggerConfiguration;
import jeus.util.message.JeusMessage_JNSServer;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.net.JeusSocketDispatcher;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusPropertyValues;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.SecurityDomainType;
import jeus.xml.binding.jeusDD.SecurityDomainsType;
import jeus.xml.binding.jeusDD.SecurityManagerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JeusServer
implements FileMonitor,
JeusProcess,
ClusterChecker {
    private static final String fs = System.getProperty("file.separator");
    private static final String permissionName = "jeus.server." + VirtualDNS.LOCAL_VIRTUALNAME;
    public static final Permission bootPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"boot");
    public static final Permission backupPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"backup");
    public static final Permission downPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"down");
    public static final Permission exitPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"exit");
    public static final Permission downBackupPermission = PermissionMaker.makeResourcePermission((String)permissionName, (String)"downBackup");
    public static final int RMIOperationTO = 300000;
    private final int NOT_BOOTED = 0;
    private final int BOOTING = 1;
    private final int BOOTED = 2;
    private final int DOWNING = 3;
    private int serverState = 0;
    private final Object runsync = new Object();
    private Map<String, NodeEntry> primarys;
    public static Vector resurrectEventListeners = new Vector();
    public static ObjectName ServerObjectName;
    public static JEUSManager jeusManager;
    public static JeusServer server;
    private JeusManagerServiceList managerServiceList;
    private JeusServerServiceList bootServiceList;
    private ObjectName containerManagerServiceName;
    public static String defaultORBClassName;
    public static ClusterInfo clusterInfo;
    private Hashtable configModifyDayList = new Hashtable();
    private String backupNodeName;
    private boolean isDynamic = true;
    private ClusterService clusterService;
    private boolean backupRunning;
    static JeusLogger logger;

    public void start(JeusConsole jeusConsole) throws JeusServerException {
        boolean isInitialBoot = false;
        String userName = null;
        String password = null;
        String passFile = null;
        boolean isProtectMode = false;
        userName = jeusConsole.getUsername();
        password = jeusConsole.getPassword();
        passFile = jeusConsole.getFilename();
        isProtectMode = jeusConsole.isProtectMode();
        this.isDynamic = jeusConsole.getIsDynamic();
        if (userName != null && password != null || passFile != null) {
            isInitialBoot = true;
        }
        JeusMainDescriptor desc = JeusServer.readJeusMainDescriptor(VirtualDNS.LOCAL_VIRTUALNAME);
        try {
            desc.initJeusServerLogger(VirtualDNS.LOCAL_VIRTUALNAME);
        }
        catch (Throwable e) {
            throw new JeusServerException("Fail to init jeus logger", e);
        }
        boolean protectedKey = EncryptionUtil.isProtected();
        if (logger.isLoggable(JeusMessage_Manager1._559_LEVEL)) {
            logger.log(JeusMessage_Manager1._559_LEVEL, "protectkey mode={0}, secret.key file is encrypted={1}", new Object[]{isProtectMode, protectedKey});
        }
        if (isProtectMode) {
            if (protectedKey) {
                EncryptionUtil.inputPasswordForSecretKey();
            } else if (logger.isLoggable(JeusMessage_Manager1._557_LEVEL)) {
                logger.log(JeusMessage_Manager1._557_LEVEL, "JEUS is booted with protectkey mode, but secret.key file is either empty or not protected.");
            }
        } else if (protectedKey) {
            if (logger.isLoggable(JeusMessage_Manager1._558_LEVEL)) {
                logger.log(JeusMessage_Manager1._558_LEVEL, "[ERROR] JEUS must boot with protectkey enabled - secret.key file is encrypted");
            }
            throw new JeusServerException(JeusMessage_Manager1._558);
        }
        EncryptionUtil.cacheEncryptionInfo();
        try {
            this.initNodeList();
        }
        catch (Throwable e) {
            throw new JeusServerException("Fail to init node list", e);
        }
        try {
            CommonProcessInitializer.configJeusSocketDispatcher(desc);
            JeusSocketDispatcher.setListenPort((int)JeusPort.JeusBase);
            JeusSocketDispatcher.start((boolean)true);
        }
        catch (Exception ex) {
            throw new JeusServerException(JeusMessage_Manager.MGR_395, (Throwable)ex);
        }
        try {
            Environment env = Environment.getMasterConfiguration();
            JeusSystemType system = desc.getJeusSystem();
            SecurityManagerType securityManagerType = system.getSecurityManager();
            if (securityManagerType != null) {
                SecurityDomainsType securityDomainsType;
                env.enableNIO = securityManagerType.getDefaultUseNio();
                if (securityManagerType.isSetConnectRetries()) {
                    env.setRetries(securityManagerType.getConnectRetries());
                }
                if ((securityDomainsType = securityManagerType.getSecurityDomains()) != null) {
                    List domains = securityDomainsType.getSecurityDomain();
                    Iterator iter = domains.iterator();
                    ArrayList<String> domainNames = new ArrayList<String>();
                    while (iter.hasNext()) {
                        SecurityDomainType securityDomainType = (SecurityDomainType)iter.next();
                        domainNames.add(securityDomainType.getName());
                        env.getDomainsInfoMap().put(securityDomainType.getName(), securityDomainType);
                    }
                    env.domains = domainNames.toArray(new String[domainNames.size()]);
                }
            }
            List nodeList = system.getNode();
            ArrayList<String> hostNames = new ArrayList<String>();
            for (int i = 0; i < nodeList.size(); ++i) {
                JeusNodeType nodeType = (JeusNodeType)nodeList.get(i);
                hostNames.add(nodeType.getName());
            }
            String[] host = new String[hostNames.size()];
            int[] port = new int[hostNames.size()];
            for (int i = 0; i < hostNames.size(); ++i) {
                String s = VirtualDNS.getRealNodeName((String)hostNames.get(i));
                int index = s.indexOf(":");
                String h = s.substring(0, index);
                int p = Integer.parseInt(s.substring(index + 1)) + 6;
                host[i] = h;
                port[i] = p;
            }
            env.remoteBaseSecurityPorts = port;
            env.hostNames = host;
            env.securitySwitch = Boolean.valueOf(System.getProperty("jeus.security.enable", "true"));
            SecurityInstaller.installSecurity(env);
            if (logger.isLoggable(JeusMessage_Manager._184_LEVEL)) {
                logger.log(JeusMessage_Manager._184_LEVEL, JeusMessage_Manager._184);
            }
        }
        catch (Throwable ex) {
            throw new JeusServerException(JeusMessage_Manager._185, ex);
        }
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            JMXManager.init(desc.getJMXManagerDescriptor(), VirtualDNS.LOCAL_VIRTUALNAME, true);
            J2EEDomain domainMo = null;
            try {
                domainMo = (J2EEDomain)J2EEDomain.createMBean("JeusSystem", null, this);
                jeusManager = (JEUSManager)JEUSManager.createMBean(VirtualDNS.LOCAL_VIRTUALNAME, null, this);
                JMXUtility.setNodeObjectName(jeusManager.getObjectName());
                StatisticRefinedThreadPoolExecutor.addThreadPoolMBeans();
                JVM.createMBean(VirtualDNS.LOCAL_VIRTUALNAME, jeusManager.getObjectName(), this);
                JeusLogService.createMBean(VirtualDNS.LOCAL_VIRTUALNAME, jeusManager.getObjectName(), null);
                SecurityInstaller.registerMBean(jeusManager.getObjectName());
            }
            catch (Exception e) {
                if (domainMo != null) {
                    domainMo.destroyMBean();
                }
                if (jeusManager != null) {
                    jeusManager.destroyMBean();
                }
                throw new JeusServerException(JeusMessage_Manager._240, (Throwable)e);
            }
            this.managerServiceList = new JeusManagerServiceList();
            ArrayList started = this.startJeusService(this.managerServiceList.getServices(), VirtualDNS.LOCAL_VIRTUALNAME, jeusManager);
            this.managerServiceList.setStartedList(started);
            List list = this.managerServiceList.getStartedServices();
            for (int i = 0; i < list.size(); ++i) {
                JEUSService service = (JEUSService)list.get(i);
                if (!(service instanceof ClusterService)) continue;
                this.clusterService = (ClusterService)service;
                break;
            }
            JMXManager.exportSNMPAdaptor(desc.getJMXManagerDescriptor(), false, VirtualDNS.LOCAL_VIRTUALNAME);
            String[] checkFiles = new String[]{VirtualDNS.LOCAL_VIRTUALNAME + "/JEUSMain.xml", "vhost.properties"};
            FileMonitorTask task = new FileMonitorTask(new FileArchive[]{JeusManagerPropertyValues.getConfigArchive()}, checkFiles, this);
            ScheduledExecutor.getInstance().scheduleWithFixedDelay(task, JeusManagerProperties.FILE_MONITOR_INTERVAL, JeusManagerProperties.FILE_MONITOR_INTERVAL);
            if (logger.isLoggable(JeusMessage_Manager._241_LEVEL)) {
                logger.log(JeusMessage_Manager._241_LEVEL, JeusMessage_Manager._241);
            }
            jeusManager.sendNotification("jeus.manger.started", "", null);
        }
        catch (IOException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
        if (isInitialBoot) {
            if (passFile != null) {
                String[] pair;
                try {
                    pair = PasswordFileManager.getUnamePassPair(passFile);
                }
                catch (Exception e) {
                    throw new JeusServerException(e.getMessage());
                }
                if (pair != null) {
                    userName = pair[0];
                    password = pair[1];
                }
            }
            LoginUtil.loginWithRuntimeException(Subject.makeSubject("SYSTEM_DOMAIN", userName, password));
            try {
                Vector cons = this.boot();
                if (cons != null) {
                    String constr = "[";
                    for (int i = 0; i < cons.size(); ++i) {
                        if (i != 0) {
                            constr = constr + ", ";
                        }
                        constr = constr + (String)cons.elementAt(i);
                    }
                    constr = constr + "]";
                    if (logger.isLoggable(JeusMessage_Manager._242_LEVEL)) {
                        logger.log(JeusMessage_Manager._242_LEVEL, JeusMessage_Manager._242, (Object)constr);
                    }
                }
            }
            catch (Throwable t) {
                throw new JeusServerException(JeusMessage_Manager._243, t);
            }
            finally {
                LoginUtil.logoutWithRuntimeException();
            }
        }
    }

    public void initNodeList() throws JAXBException, IOException {
        String nodeName;
        int i;
        String serverName = VirtualDNS.LOCAL_VIRTUALNAME;
        JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
        for (i = 0; i < desc.primarys.size(); ++i) {
            nodeName = (String)desc.primarys.get(i);
            if (!serverName.equals(nodeName)) continue;
            String bkname = (String)desc.backups.get(i);
            if (bkname == null || bkname.length() <= 0) break;
            this.backupNodeName = bkname;
            break;
        }
        clusterInfo = new ClusterInfo(JeusNetPropertyValues.LOCAL_HOSTNAME, JeusPort.JeusBase);
        this.primarys = new Hashtable<String, NodeEntry>();
        for (i = 0; i < desc.primarys.size(); ++i) {
            nodeName = (String)desc.primarys.get(i);
            NodeInfo nodeInfo = VirtualDNS.getNodeInfo(nodeName);
            clusterInfo.addNode(nodeInfo);
            boolean needBackup = nodeName.equals(this.backupNodeName);
            NodeEntry nodeEntry = new NodeEntry(nodeName, serverName, server, needBackup);
            if (this.isDynamic) {
                nodeEntry.setAlwaysNeedConnection();
            }
            this.primarys.put(nodeName, nodeEntry);
            if (!logger.isLoggable(JeusMessage_JNSServer._179_LEVEL)) continue;
            logger.log(JeusMessage_JNSServer._179_LEVEL, JeusMessage_JNSServer._179, (Object)nodeInfo);
        }
        if (logger.isLoggable(JeusMessage_Manager._251_LEVEL)) {
            logger.log(JeusMessage_Manager._251_LEVEL, JeusMessage_Manager._251);
        }
    }

    private ArrayList startJeusService(String[] services, String host, JEUSManager jeusManager) throws JeusServerException {
        ArrayList<J2EEManagedObject> startedServices = new ArrayList<J2EEManagedObject>();
        J2EEManagedObject mo = null;
        String className = null;
        try {
            for (int i = 0; i < services.length; ++i) {
                className = services[i];
                if (logger.isLoggable(JeusMessage_Manager._244_LEVEL)) {
                    logger.log(JeusMessage_Manager._244_LEVEL, JeusMessage_Manager._244, (Object)className);
                }
                Class<?> serviceClass = JeusRootClassLoader.loader.loadClass(className);
                try {
                    Method createMethod = serviceClass.getMethod("createMBean", String.class, ObjectName.class, Object.class);
                    mo = (JEUSService)createMethod.invoke(null, host, jeusManager.getObjectName(), this);
                    mo.startService(this);
                    startedServices.add(mo);
                    continue;
                }
                catch (LicenseException e) {
                    logger.log(Level.SEVERE, e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    throw e;
                }
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Manager._245_LEVEL)) {
                logger.log(JeusMessage_Manager._245_LEVEL, JeusMessage_Manager._245, (Object)className, (Throwable)e);
            }
            for (int i = 0; i < startedServices.size(); ++i) {
                ((JEUSService)startedServices.get(i)).destroyMBean();
            }
            if (mo != null) {
                mo.destroyMBean();
            }
            throw new JeusServerException(JeusMessage_Manager._245, className, (Throwable)e);
        }
        return startedServices;
    }

    private void stopJeusService(JeusServiceList list) throws JeusServerException {
        List services = list.getStartedServices();
        for (int i = services.size() - 1; i >= 0; --i) {
            JEUSService service = (JEUSService)services.get(i);
            ObjectName objectName = service.getObjectName();
            try {
                if (logger.isLoggable(JeusMessage_Manager._246_LEVEL)) {
                    logger.log(JeusMessage_Manager._246_LEVEL, JeusMessage_Manager._246, (Object)objectName);
                }
                service.stopService();
                continue;
            }
            catch (Throwable e) {
                throw new JeusServerException(JeusMessage_Manager._247, objectName.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Vector boot() {
        Vector vector;
        JeusMainDescriptor desc;
        block18: {
            Vector vector2;
            LoginUtil.checkPermissionWithCodeSubject(bootPermission);
            try {
                Object object = this.runsync;
                // MONITORENTER : object
                if (this.isDowned()) break block18;
                vector2 = null;
                // MONITOREXIT : object
                this.installConfigModifyInfo();
            }
            catch (Throwable throwable) {
                this.installConfigModifyInfo();
                LoginUtil.logoutWithRuntimeException();
                throw throwable;
            }
            LoginUtil.logoutWithRuntimeException();
            return vector2;
        }
        this.serverState = 1;
        try {
            desc = JeusServer.readJeusMainDescriptor(VirtualDNS.LOCAL_VIRTUALNAME);
        }
        catch (Throwable e) {
            logger.log(JeusMessage_Manager._248_LEVEL, JeusMessage_Manager._248, e);
            Vector vector3 = null;
            // MONITOREXIT : object
            this.installConfigModifyInfo();
            LoginUtil.logoutWithRuntimeException();
            return vector3;
        }
        try {
            desc.initJeusServerLogger(VirtualDNS.LOCAL_VIRTUALNAME);
            Logger.createLogger("", 0);
        }
        catch (Throwable ex) {
            logger.log(JeusMessage_Manager._249_LEVEL, JeusMessage_Manager._249, ex);
            Vector vector4 = null;
            // MONITOREXIT : object
            this.installConfigModifyInfo();
            LoginUtil.logoutWithRuntimeException();
            return vector4;
        }
        logger.log(JeusMessage_Manager._250_LEVEL, JeusMessage_Manager._250, (Object)VirtualDNS.LOCAL_VIRTUALNAME);
        this.clearWorkspace();
        try {
            this.bootServiceList = new JeusServerServiceList();
            this.bootServiceList.setStartedList(this.startJeusService(this.bootServiceList.getServices(), VirtualDNS.LOCAL_VIRTUALNAME, jeusManager));
            logger.log(JeusMessage_Manager._252_LEVEL, JeusMessage_Manager._252, (Object)VirtualDNS.LOCAL_VIRTUALNAME);
            jeusManager.sendNotification("jeus.server.started", "", new ArrayList<String>(this.primarys.keySet()));
            Vector englist = (Vector)JMXManager.getMbeanServer().getAttribute(this.containerManagerServiceName, "BootedContainerList");
            this.serverState = 2;
            vector = englist;
            // MONITOREXIT : object
            this.installConfigModifyInfo();
        }
        catch (Throwable ex) {
            try {
                if (this.bootServiceList != null) {
                    this.stopJeusService(this.bootServiceList);
                }
            }
            catch (JeusServerException e) {
                logger.log(JeusMessage_Manager1._501_LEVEL, JeusMessage_Manager1._501, (Throwable)((Object)e));
            }
            logger.log(JeusMessage_Manager._253_LEVEL, JeusMessage_Manager._253, ex);
            logger.flush();
            this.serverState = 0;
            Vector vector5 = null;
            // MONITOREXIT : object
            this.installConfigModifyInfo();
            LoginUtil.logoutWithRuntimeException();
            return vector5;
        }
        LoginUtil.logoutWithRuntimeException();
        return vector;
    }

    private void clearWorkspace() {
        try {
            String dir = JeusBootstrapProperties.JEUS_HOME + File.separator + "workspace";
            String except = dir + File.separator + "deployment";
            this.removeDir(dir, except);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void removeDir(String dir, String except) {
        File[] list = new File(dir).listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].isFile() && !list[i].getPath().equals(except)) {
                    this.removeDir(list[i].getPath(), except);
                }
                try {
                    String filepath = list[i].getPath();
                    new File(filepath).delete();
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    public static JeusMainDescriptor readJeusMainDescriptor(String nodeName) throws JeusServerException {
        JeusMainDescriptor desc;
        try {
            desc = JeusMainDescriptorJB.getJeusMainDescriptor(nodeName);
        }
        catch (Exception e) {
            throw new JeusServerException(JeusMessage_Manager._238, (Throwable)e);
        }
        logger.log(JeusMessage_Manager._239_LEVEL, JeusMessage_Manager._239);
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(String lnode) {
        LoginUtil.checkPermissionWithCodeSubject(backupPermission);
        if (logger.isLoggable(JeusMessage_Manager._258_LEVEL)) {
            logger.log(JeusMessage_Manager._258_LEVEL, JeusMessage_Manager._258, (Object)lnode);
        }
        try {
            try {
                String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_Manager._274, (Object[])new String[]{lnode, this.getServerName()});
                logger.sendEmailNotification(Level.SEVERE, msg);
            }
            catch (Throwable ex) {
                logger.log(JeusMessage_Manager._257_LEVEL, JeusMessage_Manager._257, ex);
            }
            Object object = this.runsync;
            synchronized (object) {
                block11: {
                    if (this.isDowned()) break block11;
                    logger.log(JeusMessage_Manager._256_LEVEL, JeusMessage_Manager._256);
                    return;
                }
                this.backupRunning = true;
            }
            this.boot();
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean down() {
        boolean bl;
        block9: {
            boolean bl2;
            LoginUtil.checkPermissionWithCodeSubject(downPermission);
            try {
                Object object = this.runsync;
                // MONITORENTER : object
                if (this.isBooted()) break block9;
                bl2 = false;
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                LoginUtil.logoutWithRuntimeException();
                throw throwable;
            }
            LoginUtil.logoutWithRuntimeException();
            return bl2;
        }
        this.serverState = 3;
        this.backupRunning = false;
        logger.log(JeusMessage_Manager._261_LEVEL, JeusMessage_Manager._261);
        Thread.interrupted();
        try {
            jeusManager.sendNotificationByLIFO("jeus.server.stopping", "", null);
            this.stopJeusService(this.bootServiceList);
            jeusManager.sendNotificationByLIFO("jeus.server.stopped", "", null);
            logger.log(JeusMessage_Manager._262_LEVEL, JeusMessage_Manager._262);
            logger.flush();
            this.serverState = 0;
            bl = true;
            // MONITOREXIT : object
        }
        catch (Throwable ex) {
            logger.log(JeusMessage_Manager._263_LEVEL, JeusMessage_Manager._263, ex);
            this.serverState = 2;
            boolean bl3 = false;
            // MONITOREXIT : object
            LoginUtil.logoutWithRuntimeException();
            return bl3;
        }
        LoginUtil.logoutWithRuntimeException();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() throws JeusServerException {
        LoginUtil.checkPermissionWithCodeSubject(exitPermission);
        try {
            this.internalExit();
            System.exit(0);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemExit(int exitCode) {
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            System.exit(exitCode);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalExit() throws JeusServerException {
        LoginUtil.checkPermissionWithCodeSubject(exitPermission);
        try {
            Object object = this.runsync;
            synchronized (object) {
                if (!this.isDowned()) {
                    throw new JeusServerException(JeusMessage_Manager._264);
                }
                try {
                    this.stopJeusService(this.managerServiceList);
                }
                catch (JeusServerException e) {
                    logger.log(JeusMessage_Manager1._501_LEVEL, JeusMessage_Manager1._501, (Throwable)((Object)e));
                }
                ScheduledExecutor.getInstance().cancelAll();
                try {
                    SecurityInstaller.uninstallSecurity();
                    logger.log(JeusMessage_Manager._186_LEVEL, JeusMessage_Manager._186);
                }
                catch (Exception e) {
                    logger.log(JeusMessage_Manager._187_LEVEL, JeusMessage_Manager._187, (Throwable)e);
                }
                JeusIOComponentCreator.getDefaultselector().destroySelector();
                JeusSocketDispatcher.destroySocketDispatcher();
                try {
                    JMXManager.stop();
                }
                catch (JeusServerException e) {
                    logger.log(JeusMessage_Manager1._501_LEVEL, JeusMessage_Manager1._501, (Throwable)((Object)e));
                }
                if (logger.isLoggable(JeusMessage_Manager._265_LEVEL)) {
                    logger.log(JeusMessage_Manager._265_LEVEL, JeusMessage_Manager._265);
                }
                JeusLogManager.enableReset();
                logger.close();
            }
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getAliveNodeList() {
        Vector<String> v = new Vector<String>();
        Map<String, NodeEntry> map = this.primarys;
        synchronized (map) {
            for (NodeEntry nodeEntry : this.primarys.values()) {
                if (nodeEntry.getStatus() != 1) continue;
                v.add(nodeEntry.getTargetNodeName());
            }
        }
        return v;
    }

    public String getServerState() {
        switch (this.serverState) {
            case 0: {
                return "not booted";
            }
            case 1: {
                return "booting";
            }
            case 2: {
                return "booted";
            }
            case 3: {
                return "downing";
            }
        }
        return "not booted";
    }

    public boolean isBooted() {
        return this.serverState == 2;
    }

    public boolean isDowned() {
        return this.serverState == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInCluster(String nodeName) {
        Map<String, NodeEntry> map = this.primarys;
        synchronized (map) {
            return this.primarys.containsKey(nodeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInWorkingCluster(String nodeName) {
        Map<String, NodeEntry> map = this.primarys;
        synchronized (map) {
            NodeEntry entry = this.primarys.get(nodeName);
            if (entry == null) {
                return true;
            }
            return entry.getStatus() == 1;
        }
    }

    public static void main(String[] args) {
        long due;
        JeusConsole jeusConsole = new JeusConsole("jeus", "start JEUS Server");
        if (!jeusConsole.checkArguments(args)) {
            return;
        }
        JeusPrintStream.setJeusStream();
        PooledExecutorFactory.setPooledExecutorFactory((PooledExecutorFactory)new JeusPooledExecutorFactory());
        try {
            JeusLogManager.disableReset();
            JeusLoggerConfiguration.setDefaultFilePath();
            logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
            Logger.createLogger("", 0);
            Logger.setLogLevel(1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JeusRootClassLoader.loader = JeusServer.class.getClassLoader();
        JeusRootClassLoader.inServer = true;
        logger.log(JeusMessage_Manager1._411_LEVEL, JeusMessage_Manager1._411, (Object)VirtualDNS.LOCAL_VIRTUALNAME);
        if (!Runner.checkBoot()) {
            logger.log(JeusMessage_Manager1._510_LEVEL, JeusMessage_Manager1._510);
            return;
        }
        if (Runner.getLicenseType() == Runner.LIC_TYPE_ACADEMIC || Runner.getLicenseType() == Runner.LIC_TYPE_DEVELOPER) {
            JeusServer.printLicenseInfo();
        }
        if ((due = Runner.getLicenseDue()) > 0L) {
            long timeleft = due - System.currentTimeMillis();
            if ((timeleft /= 86400000L) <= 14L) {
                logger.log(JeusMessage_Manager1._500_LEVEL, JeusMessage_Manager1._500, (Object)Long.toString(timeleft));
            }
        }
        if ((defaultORBClassName = System.getProperty("org.omg.CORBA.ORBClass")) != null && !defaultORBClassName.equals("jeus.transaction.ots.JORB")) {
            System.setProperty("org.omg.CORBA.ORBClass", "jeus.transaction.ots.JORB");
            System.setProperty("jeus.CORBA.ORBClass", defaultORBClassName);
        } else if (defaultORBClassName == null && (defaultORBClassName = System.getProperty("jeus.CORBA.ORBClass")) != null && !defaultORBClassName.equals("jeus.transaction.ots.JORB")) {
            System.setProperty("org.omg.CORBA.ORBClass", "jeus.transaction.ots.JORB");
        }
        try {
            CommonProcessInitializer.init();
            if (!(JeusRootClassLoader.loader instanceof RootClassLoader)) {
                JeusRootClassLoader.loader = new RootClassLoader(new URL[0], JeusRootClassLoader.class.getClassLoader());
            }
            ((RootClassLoader)JeusRootClassLoader.loader).registerEJBRootClassLoader(new EJBRootClassLoader(new URL[0], JeusRootClassLoader.loader, JeusNetPropertyValues.LOCAL_FULL_HOSTNAME + "_default"));
            server = new JeusServer();
            MEJBUtility.setClusterChecker((ClusterChecker)server);
            server.start(jeusConsole);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            JeusServer.systemExit(1);
        }
    }

    public static void printLicenseInfo() {
        System.out.println("================ JEUS LICENSE INFORMATION ================");
        if (Runner.getLicenseType() == Runner.LIC_TYPE_ACADEMIC) {
            System.out.println("=== EDITION: Enterprise (Academic License)");
        } else if (Runner.getLicenseType() == Runner.LIC_TYPE_DEVELOPER) {
            System.out.println("=== EDITION: Enterprise (Trial License)");
        }
        System.out.println("=== NOTICE: This license restricts the number of allowed clients.");
        System.out.println("=== Max. Number of Clients: " + Runner.getNumOfLicensedClient());
        System.out.println("==========================================================");
    }

    public String getServerName() {
        return VirtualDNS.LOCAL_VIRTUALNAME;
    }

    public static ObjectName getObjectName() {
        return jeusManager.getObjectName();
    }

    public void setContainerManagerServiceName(ObjectName objectName) {
        this.containerManagerServiceName = objectName;
    }

    public ObjectName getContainerManagerServiceName() {
        return this.containerManagerServiceName;
    }

    public boolean dumpThreads(String containerName) {
        return false;
    }

    public Map<String, NodeEntry> getPrimarys() {
        return this.primarys;
    }

    private void installConfigModifyInfo() {
        block4: {
            try {
                String jeusMain_xml = JeusProperties.JEUS_CONFIG_HOME + fs + this.getServerName() + fs + "JEUSMain.xml";
                File f = new File(jeusMain_xml);
                Date cal = new Date(f.lastModified());
                this.configModifyDayList.put(jeusMain_xml, cal.toString());
                Vector list = (Vector)JMXManager.getMbeanServer().getAttribute(this.containerManagerServiceName, "BootedContainerList");
                if (list == null) {
                    return;
                }
                String[] engineMain_xmls = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    engineMain_xmls[i] = JeusProperties.JEUS_CONFIG_HOME + fs + this.getServerName() + fs + list.get(i) + fs + this.getXmlName((String)list.get(i));
                    File f0 = new File(engineMain_xmls[i]);
                    Date cal0 = new Date(f0.lastModified());
                    this.configModifyDayList.put(engineMain_xmls[i], cal0.toString());
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Manager1._508_LEVEL)) break block4;
                logger.log(JeusMessage_Manager1._508_LEVEL, JeusMessage_Manager1._508, (Throwable)e);
            }
        }
    }

    public String getConfigModifyInfo() {
        StringBuffer result;
        block4: {
            result = new StringBuffer();
            String jeusMain_xml = JeusProperties.JEUS_CONFIG_HOME + fs + this.getServerName() + fs + "JEUSMain.xml";
            this.setConfigModifyInfo(jeusMain_xml, result);
            try {
                Vector conList = (Vector)JMXManager.getMbeanServer().getAttribute(this.containerManagerServiceName, "BootedContainerList");
                for (int i = 0; i < conList.size(); ++i) {
                    Vector engineList = (Vector)JMXManager.getMbeanServer().invoke(this.containerManagerServiceName, "getEngineList", new String[]{this.getServerName(), (String)conList.get(i)}, new String[]{String.class.getName(), String.class.getName()});
                    String[] engineMain_xmls = new String[engineList.size()];
                    for (int j = 0; j < engineList.size(); ++j) {
                        String engine_xml = this.getXmlName((String)engineList.get(j));
                        if (engine_xml == null) continue;
                        engineMain_xmls[j] = JeusProperties.JEUS_CONFIG_HOME + fs + this.getServerName() + fs + engineList.get(j) + fs + engine_xml;
                        this.setConfigModifyInfo(engineMain_xmls[j], result);
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Manager1._509_LEVEL)) break block4;
                logger.log(JeusMessage_Manager1._509_LEVEL, JeusMessage_Manager1._509, (Throwable)e);
            }
        }
        return result.toString();
    }

    private void setConfigModifyInfo(String xml, StringBuffer result) {
        File f = new File(xml);
        Date cal = new Date(f.lastModified());
        String modifyDay = cal.toString();
        String premodifyDay = (String)this.configModifyDayList.get(xml);
        if (premodifyDay == null) {
            result.append(xml + " : MODIFY [" + modifyDay + "]");
            this.configModifyDayList.put(xml, modifyDay);
        } else if (modifyDay.equals(premodifyDay)) {
            result.append(xml + " : NOT MODIFY [" + modifyDay + "]");
        } else {
            result.append(xml + " : MODIFY [" + modifyDay + "]");
            this.configModifyDayList.put(xml, modifyDay);
        }
        result.append("\n");
    }

    private String getXmlName(String engName) {
        if (engName.indexOf("_ejb_") > 0) {
            return "EJBMain.xml";
        }
        if (engName.indexOf("_servlet_") > 0) {
            return "WEBMain.xml";
        }
        if (engName.indexOf("_jms_") > 0) {
            return "JMSMain.xml";
        }
        return null;
    }

    @Override
    public void fileChanged(File f) {
        String path = f.getAbsolutePath();
        if (path.endsWith(VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "JEUSMain.xml") || path.endsWith("vhost.properties")) {
            LoginUtil.loginCodeSubjectWithRuntimeException();
            try {
                this.initNodeList();
                this.clusterService.restartService();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                LoginUtil.logoutWithRuntimeException();
            }
        }
    }

    public boolean isBackupRunning() {
        return this.backupRunning;
    }

    public boolean isBackupNode() {
        return this.backupNodeName != null;
    }

    @Override
    public String getNodeName() {
        return VirtualDNS.LOCAL_VIRTUALNAME;
    }

    @Override
    public String getContainerName() {
        return VirtualDNS.LOCAL_VIRTUALNAME + "_default";
    }

    static {
        EncryptionUtil.init(JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + VirtualDNS.LOCAL_VIRTUALNAME + JeusPropertyValues.fs + "security", (Provider)CommonProcessInitializer.PROVIDER);
    }
}

