/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.enginecontainer;

import java.io.Serializable;
import javax.management.MBeanServerConnection;
import jeus.management.JMXManager;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEServer;
import jeus.management.j2ee.manager.EngineMoMBean;
import jeus.security.util.LoginUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.properties.JeusManagerPropertyValues;

public class DownThread
extends Thread {
    private String engineName;
    private Object sync;
    private boolean isSuccessful = false;
    private boolean down = false;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
    private J2EEServer serverMBean;

    public DownThread(String engineName, Object sync, J2EEServer serverMBean) {
        super("jeus.server.enginecontainer.DownThread");
        this.engineName = engineName;
        this.sync = sync;
        this.serverMBean = serverMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.serverMBean.sendNotification("jeus.engine.predown", "try to down engine", (Serializable)((Object)this.engineName));
            LoginUtil.loginCodeSubjectWithRuntimeException();
            try {
                EngineMoMBean engineMo = JMXUtility.getProxy((MBeanServerConnection)JMXManager.getMbeanServer(), JMXUtility.queryEngineMo(JMXManager.getMbeanServer(), JeusManagerPropertyValues.containerName, this.engineName), EngineMoMBean.class, false);
                engineMo.down();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            finally {
                LoginUtil.logoutWithRuntimeException();
            }
            this.isSuccessful = true;
            if (logger.isLoggable(JeusMessage_Manager._91_LEVEL)) {
                logger.log(JeusMessage_Manager._91_LEVEL, JeusMessage_Manager._91, (Object)this.engineName);
            }
            this.serverMBean.sendNotification("jeus.engine.postdown.success", "engine is downed successfully", (Serializable)((Object)this.engineName));
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Manager._94_LEVEL)) {
                logger.log(JeusMessage_Manager._94_LEVEL, JeusMessage_Manager._94, (Object)this.engineName, t);
            }
            this.serverMBean.sendNotification("jeus.engine.postdown.fail", "engine down is failed", (Serializable)new Object[]{this.engineName, t});
        }
        Object object = this.sync;
        synchronized (object) {
            this.down = true;
            this.sync.notify();
        }
    }

    public boolean isDowned() {
        return this.down;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }
}

