/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.enginecontainer;

import jeus.server.enginecontainer.InvocationManagerInterface;
import jeus.server.enginecontainer.InvocationStack;
import jeus.server.enginecontainer.ResourceSet;
import jeus.servlet.engine.RequestProcessor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.trace.ManagedResource;

public class InvocationManager
implements InvocationManagerInterface {
    public static final int NOACTION = 0;
    public static final int WARNING = 1;
    public static final int AUTOCLOSE = 2;
    private static int action;
    private static InvocationStacks stacks;
    private static JeusLogger logger;

    public static void init(int act) {
        action = act;
        stacks = new InvocationStacks();
    }

    public static int getAction() {
        return action;
    }

    public static void preInvoke(boolean stateless) {
        if (action < 1) {
            return;
        }
        try {
            InvocationStack myStack = (InvocationStack)stacks.get();
            myStack.push(stateless);
        }
        catch (Throwable t) {
            logger.log(JeusMessage_Manager._105_LEVEL, JeusMessage_Manager._105, t);
        }
    }

    public void addResource(ManagedResource resource) {
        if (action < 1) {
            return;
        }
        try {
            InvocationStack myStack = (InvocationStack)stacks.get();
            myStack.addResource(resource);
        }
        catch (Throwable t) {
            logger.log(JeusMessage_Manager._105_LEVEL, JeusMessage_Manager._105, t);
        }
    }

    public void removeResource(ManagedResource resource) {
        if (action < 1) {
            return;
        }
        try {
            InvocationStack myStack = (InvocationStack)stacks.get();
            myStack.removeResource(resource);
        }
        catch (Throwable t) {
            logger.log(JeusMessage_Manager._105_LEVEL, JeusMessage_Manager._105, t);
        }
    }

    public static void postInvoke() {
        if (action < 1) {
            return;
        }
        try {
            Thread currThread;
            InvocationStack myStack = (InvocationStack)stacks.get();
            ResourceSet set = myStack.pop();
            if (set.isEmpty()) {
                return;
            }
            if (logger.isLoggable(JeusMessage_Manager._396_LEVEL)) {
                logger.log(JeusMessage_Manager._396_LEVEL, JeusMessage_Manager._396, (Object)set.resourcesToString());
            }
            if ((currThread = Thread.currentThread()) instanceof RequestProcessor && logger.isLoggable(JeusMessage_Manager._107_LEVEL)) {
                logger.log(JeusMessage_Manager._107_LEVEL, JeusMessage_Manager._107, (Object)((RequestProcessor)currThread).getRequestURI());
            }
            if (action == 2) {
                set.releaseAll();
            }
        }
        catch (Throwable t) {
            logger.log(JeusMessage_Manager._105_LEVEL, JeusMessage_Manager._105, t);
        }
    }

    public static InvocationStack getCurrentStack() {
        return (InvocationStack)stacks.get();
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
    }

    public static class InvocationStacks
    extends ThreadLocal {
        public Object initialValue() {
            InvocationStack stack = new InvocationStack();
            stack.push(false);
            return stack;
        }
    }
}

