/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.manager;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class JeusVersion {
    private static String productName = "JEUS";
    private static String productVersion = "unknown";
    private static String majorVersion = "unknown";
    private static String fullVersion = "unknown";
    private static String buildVersion = "unknown";

    public static String getProductName() {
        return productName;
    }

    public static String getVersion() {
        return productVersion;
    }

    public static String getMajorVersion() {
        return majorVersion;
    }

    public static String getFullVersion() {
        return fullVersion;
    }

    public static String getBuildVersion() {
        return buildVersion;
    }

    private JeusVersion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            URL url = JeusVersion.class.getClassLoader().getResource("version.properties");
            if (url == null) {
                throw new FileNotFoundException("Could not find version.properties resource");
            }
            InputStream is = url.openStream();
            try {
                Properties p = new Properties();
                p.load(is);
                productName = p.getProperty("product.name");
                if (productName == null) {
                    throw new Exception("there is not product.name property");
                }
                majorVersion = p.getProperty("product.major.version");
                if (majorVersion == null) {
                    throw new Exception("there is not product.major.version property");
                }
                String fixVersion = p.getProperty("product.fix.version");
                if (fixVersion == null) {
                    throw new Exception("there is not product.fix.version property");
                }
                String buildNumber = p.getProperty("build.number");
                if (buildNumber == null) {
                    throw new Exception("there is not build.number property");
                }
                productVersion = productName + " " + majorVersion + " (Fix#" + fixVersion + ")";
                buildVersion = "b" + buildNumber;
                fullVersion = majorVersion + ".0." + fixVersion + "-" + buildVersion;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Throwable t) {
            System.err.println("[ERROR] Could not read version.properties - " + t);
        }
    }
}

