/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.util.logging.Level;
import jeus.descriptor.jeusserver.EngineContainerDescriptor;
import jeus.server.enginecontainer.EngineContainer;
import jeus.util.JeusException;
import jeus.util.logging.JeusLogger;
import jeus.util.sysmon.CPUMonitor;

public class CPUMonitorService {
    static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
    volatile boolean started;
    boolean enabled;
    int interval = 2000;
    private CPUMonitor monitor;
    private static CPUMonitorService instance = new CPUMonitorService();

    private CPUMonitorService() {
    }

    public static CPUMonitorService getInstance() {
        return instance;
    }

    public boolean isStarted() {
        return this.started;
    }

    public CPUMonitor getCPUMonitor() {
        return this.monitor;
    }

    public void startService(Object obj) throws JeusException {
        this.startService();
    }

    public void startService(EngineContainerDescriptor desc, EngineContainer container) throws JeusException {
        this.startService();
    }

    private void startService() {
        this.enabled = Boolean.parseBoolean(System.getProperty("jeus.server.cpumonitor.enabled", "false"));
        try {
            this.interval = Integer.parseInt(System.getProperty("jeus.server.cpumonitor.interval", "2000"));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (this.enabled) {
            this.monitor = CPUMonitor.createInstance();
            if (this.monitor == null) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log("CPUMonitorService is not supported for this platform");
                }
                return;
            }
            this.monitor.start(this.interval);
            this.started = true;
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log("CPUMonitorService started successfully (interval=" + this.interval + "ms)");
            }
        }
    }

    public void stopService() {
        if (this.started) {
            this.monitor.stop();
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log("CPUMonitorService stopped successfully");
            }
        }
    }
}

