/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.security.Permission;
import java.util.Enumeration;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.descriptor.bind.JMSSourceDescriptorJB;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.extresource.ExtResourceDescriptor;
import jeus.descriptor.extresource.JMSSourceDescriptor;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.external.InvalidPropertyException;
import jeus.jms.wrapper.JMSSourceBinder;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.ExtResourceBinder;
import jeus.server.JeusServerException;
import jeus.server.service.ExternalResourceHandler;
import jeus.server.service.ExternalResourceServiceMBean;
import jeus.server.service.JEUSService;
import jeus.server.service.MQExtResourceService;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.jeusDD.ExternalResourceType;
import jeus.xml.binding.jeusDD.HierarchicalPropertyType;
import jeus.xml.binding.jeusDD.JmsSourceType;
import jeus.xml.binding.jeusDD.ResourceType;

public class ExternalResourceService
extends JEUSService
implements ExternalResourceServiceMBean {
    private ResourcePermission externalResourcePermission;
    private ExternalResourceHandler externalResourceHandler = new ExternalResourceHandler();

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        ExternalResourceService mo = new ExternalResourceService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "ExternalResourceService");
    }

    protected void makePermissions() {
        super.makePermissions();
        this.externalResourcePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"externalResource");
    }

    public void startService(Object obj) throws JeusServerException {
        LoginService.checkCodeSubject();
        JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
        Enumeration e = desc.extResources.elements();
        while (e.hasMoreElements()) {
            try {
                ExtResourceBinder.bind((ExtResourceDescriptor)e.nextElement(), this.getObjectName());
            }
            catch (Exception ex) {
                throw new JeusServerException(JeusMessage_Manager._166, (Throwable)ex);
            }
        }
        ResourceType resourceType = desc.getJeusSystem().getResource();
        if (resourceType != null) {
            List resources = resourceType.getExternalResource();
            this.externalResourceHandler.bindResources(resources);
        }
        try {
            this.startRecursive();
        }
        catch (Exception e2) {
            throw new JeusServerException(e2.toString());
        }
    }

    public void modifyExternalResource(String name, HierarchicalPropertyType modifiedProperty) throws InvalidPropertyException {
        this.externalResourceHandler.modifyExternalResource(name, modifiedProperty);
    }

    public ExternalResourceType getExternalResource(String name) {
        return this.externalResourceHandler.getExternalResource(name);
    }

    public void stopService() throws JeusServerException {
        LoginService.checkCodeSubject();
        this.externalResourceHandler.destroyResources();
        try {
            this.stop();
        }
        catch (Exception e) {
            throw new JeusServerException(e.toString());
        }
        finally {
            this.destroyMBean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName bindMQ(JmsSourceType mqType) {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.externalResourcePermission);
        try {
            JMSSourceDescriptor ibmDesc = JMSSourceDescriptorJB.getJMSDescriptor(mqType);
            if (!JMSSourceBinder.bind((JMSSourceDescriptor)ibmDesc)) {
                ObjectName objectName = null;
                return objectName;
            }
            ObjectName objectName = MQExtResourceService.reCreateMBean(ibmDesc.getExportName(), this.getObjectName(), ibmDesc).getObjectName();
            return objectName;
        }
        catch (Throwable e) {
            ObjectName objectName = null;
            return objectName;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public String getJeusType() {
        return "ExternalResourceService";
    }
}

