/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.security.Permission;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.jdbc.datasource.ClusterDSBindInfo;
import jeus.management.JMXManagerException;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.service.JDBCClusterDataSourceServiceMBean;

public class JDBCClusterDataSourceService
extends J2EEManagedObjectSupport
implements JDBCClusterDataSourceServiceMBean {
    private String exportName;
    private ClusterDSBindInfo info;
    private ResourcePermission controlPermission;

    public JDBCClusterDataSourceService(String srvName, ClusterDSBindInfo info) {
        this.exportName = srvName;
        this.info = info;
    }

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object info) throws InstanceAlreadyExistsException {
        JDBCClusterDataSourceService mo = new JDBCClusterDataSourceService(srvName, (ClusterDSBindInfo)info);
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "JDBCClusterDataSourceService");
    }

    public String getExportName() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return this.exportName;
    }

    public List getDataSourceList() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return this.info.getDataSourceList();
    }

    public String getStringTypeDataSourceList() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return this.info.getDSList();
    }

    protected String initPermissionName() throws JMXManagerException {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return module.getPermissionName() + "." + "JDBCClusterDataSourceService" + "." + this.myNameString;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.controlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"control");
    }

    public boolean isPreConnection() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return this.info.isPreConn();
    }
}

