/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.security.Permission;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.management.JMXManagerException;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.service.JDBCDataSourceServiceMBean;

public class JDBCDataSourceService
extends J2EEManagedObjectSupport
implements JDBCDataSourceServiceMBean {
    private String exportName;
    private DBDSBindInfo info;
    private ResourcePermission controlPermission;

    public JDBCDataSourceService(String srvName, DBDSBindInfo info) {
        this.exportName = srvName;
        this.info = info;
    }

    protected String initPermissionName() throws JMXManagerException {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return module.getPermissionName() + "." + "JDBCDataSourceService" + "." + this.myNameString;
    }

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, DBDSBindInfo info) throws InstanceAlreadyExistsException {
        JDBCDataSourceService mo = new JDBCDataSourceService(srvName, info);
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "JDBCDataSourceService");
    }

    protected void makePermissions() {
        super.makePermissions();
        this.controlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"control");
    }

    public String getExportName() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return this.exportName;
    }

    public String getVendor() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return this.info.getVendor();
    }

    public DBDSBindInfo getDataSourceDescriptor() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        return this.info;
    }

    public String getDataSourceType() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.controlPermission);
        switch (this.info.getDataSourceType()) {
            case 0: {
                return "DataSource";
            }
            case 1: {
                return "ConnectionPoolDataSource";
            }
            case 3: {
                return "LocalXADataSource";
            }
            case 2: {
                return "XADataSource";
            }
        }
        return "UnKnown Type";
    }
}

