/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.io.IOException;
import java.security.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.xml.bind.JAXBException;
import jeus.descriptor.bind.DBDSBindInfoJB;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.datasource.ClusterDSBindInfo;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.jdbc.datasource.DBDSBinder;
import jeus.jdbc.datasource.DBDataSourceException;
import jeus.jdbc.datasource.DataSourceConfigurationTester;
import jeus.management.JMXUtility;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.JDBCResourceMBean;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.JeusServerException;
import jeus.server.service.JDBCClusterDataSourceService;
import jeus.server.service.JDBCDataSourceService;
import jeus.server.service.JDBCResourceServiceMBean;
import jeus.server.service.JEUSService;
import jeus.tool.common.xml.XMLConverterException;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_JDBC;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.jeusDD.ClusterDsType;
import jeus.xml.binding.jeusDD.DatabaseType;

public class JDBCResourceService
extends JEUSService
implements JDBCResourceServiceMBean {
    private ResourcePermission jdbcResourcePermission;
    private final Hashtable bindedDS = new Hashtable();

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        JDBCResourceService mo = new JDBCResourceService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "JDBCResourceService");
    }

    protected void makePermissions() {
        super.makePermissions();
        this.jdbcResourcePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"jdbcResource");
    }

    public void startService(Object obj) throws JeusServerException {
        LoginService.checkCodeSubject();
        JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
        for (DBDSBindInfo dBDSBindInfo : desc.dbDataSource) {
            try {
                DBDSBinder.bind(dBDSBindInfo, true);
            }
            catch (Exception ex) {
                throw new JeusServerException(JeusMessage_Manager._168, (Throwable)ex);
            }
            try {
                JDBCDataSourceService.createMBean(dBDSBindInfo.getExportName(), this.getObjectName(), dBDSBindInfo);
            }
            catch (InstanceAlreadyExistsException e1) {}
        }
        Enumeration e = desc.clusterDataSource.elements();
        while (e.hasMoreElements()) {
            ClusterDSBindInfo clusterDSBindInfo = (ClusterDSBindInfo)e.nextElement();
            try {
                DBDSBinder.bind(clusterDSBindInfo, true);
            }
            catch (Exception ex) {
                throw new JeusServerException(JeusMessage_Manager._168, (Throwable)ex);
            }
            try {
                JDBCClusterDataSourceService.createMBean(clusterDSBindInfo.getExportName(), this.getObjectName(), clusterDSBindInfo);
            }
            catch (InstanceAlreadyExistsException e1) {}
        }
    }

    public void stopService() throws JeusServerException {
        LoginService.checkCodeSubject();
        this.destroyMBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reconfigDataSources(String ds, Hashtable properties) throws IOException {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.jdbcResourcePermission);
        try {
            MEJBUtility utility = null;
            utility = MEJBUtility.getMEJBUtility();
            ObjectName[] resourceNames = JMXUtility.queryJDBCResources((MBeanServerConnection)utility, VirtualDNS.LOCAL_VIRTUALNAME);
            JDBCResourceMBean[] servers = JMXUtility.getProxy((MBeanServerConnection)utility, resourceNames, JDBCResourceMBean.class, false);
            for (int i = 0; i < servers.length; ++i) {
                JDBCResourceMBean jdbcResource = servers[i];
                try {
                    jdbcResource.updateCP(ds, properties);
                    continue;
                }
                catch (Throwable t2) {
                    if (logger.isLoggable(JeusMessage_Manager._169_LEVEL)) {
                        logger.log(JeusMessage_Manager._169_LEVEL, JeusMessage_Manager._169, (Object[])new String[]{ds, resourceNames[i].getKeyProperty("J2EEServer")});
                    }
                    boolean bl = false;
                    LoginUtil.logoutWithRuntimeException();
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName bindDBDS(DatabaseType databaseType) throws XMLConverterException {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.jdbcResourcePermission);
        try {
            try {
                databaseType.fillDefault();
            }
            catch (JAXBException e) {
                throw new JeusRuntimeException((Throwable)e);
            }
            DBDSBindInfo info = DBDSBindInfoJB.getDBDSBindInfoDescriptor(databaseType);
            if (logger.isLoggable(JeusMessage_Manager._170_LEVEL)) {
                logger.log(JeusMessage_Manager._170_LEVEL, JeusMessage_Manager._170, (Object)info);
            }
            if (!DBDSBinder.bind(info, true)) {
                ObjectName objectName = null;
                return objectName;
            }
            ObjectName objName = (ObjectName)this.bindedDS.get(info.getExportName());
            if (objName == null) {
                try {
                    objName = JDBCDataSourceService.createMBean(info.getExportName(), this.getObjectName(), info).getObjectName();
                    this.bindedDS.put(info.getExportName(), objName);
                }
                catch (InstanceAlreadyExistsException e1) {
                    if (logger.isLoggable(JeusMessage_Manager._361_LEVEL)) {
                        logger.log(JeusMessage_Manager._361_LEVEL, JeusMessage_Manager._361, (Object)info.getExportName(), (Throwable)e1);
                    }
                    objName = null;
                }
            }
            ObjectName objectName = objName;
            return objectName;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName bindClusterDBDS(ClusterDsType clusterDsType) {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.jdbcResourcePermission);
        try {
            ObjectName objName;
            ClusterDSBindInfo clInfo = JeusMainDescriptorJB.getClusterDBDSInfo(clusterDsType);
            if (logger.isLoggable(JeusMessage_Manager._170_LEVEL)) {
                logger.log(JeusMessage_Manager._170_LEVEL, JeusMessage_Manager._170, (Object)clInfo);
            }
            if (!DBDSBinder.bind(clInfo, false)) {
                ObjectName objectName = null;
                return objectName;
            }
            try {
                objName = JDBCClusterDataSourceService.createMBean(clInfo.getExportName(), this.getObjectName(), clInfo).getObjectName();
            }
            catch (InstanceAlreadyExistsException e1) {
                if (logger.isLoggable(JeusMessage_Manager._367_LEVEL)) {
                    logger.log(JeusMessage_Manager._367_LEVEL, JeusMessage_Manager._367, (Object)clInfo.getExportName(), (Throwable)e1);
                }
                ObjectName objectName = null;
                LoginUtil.logoutWithRuntimeException();
                return objectName;
            }
            ObjectName objectName = objName;
            return objectName;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testDBConfiguration(String exportName, String nodeName) throws DBDataSourceException {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.jdbcResourcePermission);
        try {
            DataSourceConfigurationTester.testDataSourceConfiguration(exportName, nodeName);
            boolean bl = true;
            return bl;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBinded(String exportName) {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.jdbcResourcePermission);
        try {
            int count = 0;
            InitialContext ctx = new InitialContext();
            NamingEnumeration<NameClassPair> nenum = ctx.list("/" + exportName);
            while (nenum.hasMoreElements()) {
                nenum.next();
                ++count;
            }
            boolean bl = count != 0;
            return bl;
        }
        catch (NamingException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBDSBindInfo getDataSourceInformation(String exportName) {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.jdbcResourcePermission);
        try {
            JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
            for (DBDSBindInfo bindInfo : desc.dbDataSource) {
                if (!exportName.equals(bindInfo.getExportName())) continue;
                DBDSBindInfo dBDSBindInfo = bindInfo;
                return dBDSBindInfo;
            }
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getListOfClusteredDataSources(String dataSourceName) throws IOException, ConnectionPoolException {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.jdbcResourcePermission);
        try {
            MEJBUtility utility = MEJBUtility.getMEJBUtility();
            ObjectName[] resourceNames = JMXUtility.queryJDBCResources((MBeanServerConnection)utility, VirtualDNS.LOCAL_VIRTUALNAME);
            JDBCResourceMBean[] servers = JMXUtility.getProxy((MBeanServerConnection)utility, resourceNames, JDBCResourceMBean.class, false);
            JDBCResourceMBean jdbcResource = servers[0];
            String[] stringArray = jdbcResource.getDataSourceListOfClusterDataSource(dataSourceName);
            return stringArray;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failbackClusterDataSource(String dataSourceName) throws ConnectionPoolException, IOException {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.jdbcResourcePermission);
        try {
            MEJBUtility utility = MEJBUtility.getMEJBUtility();
            ObjectName[] resourceNames = JMXUtility.queryJDBCResources((MBeanServerConnection)utility, VirtualDNS.LOCAL_VIRTUALNAME);
            JDBCResourceMBean[] servers = JMXUtility.getProxy((MBeanServerConnection)utility, resourceNames, JDBCResourceMBean.class, false);
            boolean checkNeeded = false;
            boolean allFailed = servers.length > 0;
            for (JDBCResourceMBean jdbcResource : servers) {
                try {
                    jdbcResource.failbackClusterDataSource(dataSourceName);
                    if (logger.isLoggable(JeusMessage_JDBC._62_LEVEL)) {
                        logger.log(JeusMessage_JDBC._62_LEVEL, JeusMessage_JDBC._62, (Object[])new String[]{dataSourceName, jdbcResource.getContainerName(), VirtualDNS.LOCAL_VIRTUALNAME});
                    }
                    allFailed = false;
                }
                catch (Exception e) {
                    if (e instanceof ConnectionPoolException) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, e.getMessage());
                        }
                    } else if (logger.isLoggable(JeusMessage_JDBC._59_LEVEL)) {
                        logger.log(JeusMessage_JDBC._59_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._59, (Object[])new String[]{jdbcResource.getContainerName(), VirtualDNS.LOCAL_VIRTUALNAME}), (Throwable)e);
                    }
                    checkNeeded = true;
                }
            }
            if (allFailed) {
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._60));
            }
            if (checkNeeded) {
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._61));
            }
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public String getJeusType() {
        return "JDBCResourceService";
    }
}

