/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.security.Permission;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.descriptor.bind.JMXManagerDescriptorJB;
import jeus.descriptor.jeusserver.EngineContainerDescriptor;
import jeus.descriptor.jeusserver.JMXManagerDescriptor;
import jeus.management.JMXManager;
import jeus.management.JMXManagerException;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.JeusServerException;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.service.ContainerService;
import jeus.server.service.JMXExportServiceMBean;
import jeus.util.JeusException;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.jeusDD.JmxManagerType;

public class JMXExportService
extends ContainerService
implements JMXExportServiceMBean {
    public boolean isContainer = false;
    private ResourcePermission jmxExportPermission;

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        JMXExportService mo = new JMXExportService();
        return mo.createMBean(srvName, "JeusService", parent, JMXExportServiceMBean.parentKeyMap, "JMXExportService");
    }

    protected void makePermissions() {
        super.makePermissions();
        this.jmxExportPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"jmxExport");
    }

    public void startService(Object obj) throws JeusServerException {
        LoginService.checkCodeSubject();
        try {
            this.isContainer = false;
            JMXManager.exportJMXManager(this.myNameString, false);
        }
        catch (JMXManagerException e) {
            this.destroyMBean();
            throw new JeusServerException(JeusMessage_Manager._171, (Throwable)e);
        }
    }

    public void startService(EngineContainerDescriptor desc, EngineContainer container) throws JeusException {
        LoginService.checkCodeSubject();
        try {
            this.isContainer = true;
            JMXManager.exportJMXManager(this.myNameString, true);
        }
        catch (JMXManagerException e) {
            this.destroyMBean();
            throw new JeusServerException(JeusMessage_Manager._171, (Throwable)e);
        }
    }

    public void stopService() throws JeusServerException {
        LoginService.checkCodeSubject();
        try {
            JMXManager.unexportJMXManager(this.myNameString);
        }
        catch (JMXManagerException e) {
            throw new JeusServerException(JeusMessage_Manager._172, (Throwable)e);
        }
        finally {
            this.destroyMBean();
        }
    }

    public ObjectName startSNMPAdaptor(JmxManagerType jmxManagerType) {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.jmxExportPermission);
        JMXManagerDescriptor desc = JMXManagerDescriptorJB.getJMSManagerDescriptor(jmxManagerType);
        return JMXManager.exportSNMPAdaptor(desc, this.isContainer, this.myNameString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSNMPAdaptor() {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.jmxExportPermission);
        try {
            JMXManager.unexportSNMPAdaptor();
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public String getJeusType() {
        return "JMXExportService";
    }
}

