/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.jndi.jns.delegate.RemoteContextFactoryImpl;
import jeus.jndi.jns.local.JNSLocal;
import jeus.jndi.jns.server.JNSServer;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.security.spi.LoginService;
import jeus.server.JeusServerException;
import jeus.server.service.JEUSService;
import jeus.server.service.JNDIResourceServiceMBean;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.properties.JeusJNDIProperties;

public class JNDIResourceService
extends JEUSService
implements JNDIResourceServiceMBean {
    private JNSServer nserver;
    private RemoteContextFactoryImpl remoteCtxFactory;

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        JNDIResourceService mo = new JNDIResourceService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "JNDIResourceService");
    }

    public void startService(Object obj) throws JeusServerException {
        LoginService.checkCodeSubject();
        try {
            JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
            this.nserver = new JNSServer(desc.getJNDIServerDescriptor(), this.myObjectName);
            this.nserver.export();
            if (logger.isLoggable(JeusMessage_Manager._173_LEVEL)) {
                logger.log(JeusMessage_Manager._173_LEVEL, JeusMessage_Manager._173);
            }
            if (JeusJNDIProperties.USE_REMOTE_CONTEXT) {
                this.remoteCtxFactory = new RemoteContextFactoryImpl();
                this.remoteCtxFactory.export(VirtualDNS.LOCAL_VIRTUALNAME);
            }
            if (logger.isLoggable(JeusMessage_Manager._174_LEVEL)) {
                logger.log(JeusMessage_Manager._174_LEVEL, JeusMessage_Manager._174);
            }
            J2EEManagedObject.setMEJBUtilityEnable();
        }
        catch (Throwable e) {
            block12: {
                block11: {
                    if (logger.isLoggable(JeusMessage_Manager1._441_LEVEL)) {
                        logger.log(JeusMessage_Manager1._441_LEVEL, JeusMessage_Manager1._441, e);
                    }
                    try {
                        if (this.remoteCtxFactory != null) {
                            this.remoteCtxFactory.unexport(VirtualDNS.LOCAL_VIRTUALNAME);
                            this.remoteCtxFactory = null;
                        }
                    }
                    catch (Throwable ex1) {
                        if (!logger.isLoggable(JeusMessage_Manager._175_LEVEL)) break block11;
                        logger.log(JeusMessage_Manager._175_LEVEL, JeusMessage_Manager._175, ex1);
                    }
                }
                try {
                    JNSLocal.down();
                    this.nserver.unexport();
                    this.nserver = null;
                }
                catch (Throwable ex1) {
                    if (!logger.isLoggable(JeusMessage_Manager._177_LEVEL)) break block12;
                    logger.log(JeusMessage_Manager._177_LEVEL, JeusMessage_Manager._177, ex1);
                }
            }
            this.destroyMBean();
            throw new RuntimeException();
        }
    }

    public void stopService() throws JeusServerException {
        block7: {
            block6: {
                LoginService.checkCodeSubject();
                try {
                    if (this.remoteCtxFactory != null) {
                        this.remoteCtxFactory.unexport(VirtualDNS.LOCAL_VIRTUALNAME);
                        this.remoteCtxFactory = null;
                    }
                }
                catch (Throwable ex1) {
                    if (!logger.isLoggable(JeusMessage_Manager._175_LEVEL)) break block6;
                    logger.log(JeusMessage_Manager._175_LEVEL, JeusMessage_Manager._175, ex1);
                }
            }
            try {
                JNSLocal.down();
                if (this.nserver != null) {
                    this.nserver.unexport();
                    this.nserver = null;
                }
            }
            catch (Throwable ex1) {
                if (!logger.isLoggable(JeusMessage_Manager._176_LEVEL)) break block7;
                logger.log(JeusMessage_Manager._176_LEVEL, JeusMessage_Manager._176, ex1);
            }
        }
        this.destroyMBean();
    }

    public String getJeusType() {
        return "JNDIResourceService";
    }
}

