/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.io.UnsupportedEncodingException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.xml.bind.JAXBException;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.service.JeusLogServiceMBean;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.AccessLogger;
import jeus.util.logging.ConsoleHandler;
import jeus.util.logging.ErrorHandlerFactory;
import jeus.util.logging.FileHandler;
import jeus.util.logging.FileHandlerView;
import jeus.util.logging.JeusFormatter;
import jeus.util.logging.JeusHandler;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.JeusLoggerConfiguration;
import jeus.util.logging.SimpleFormatter;
import jeus.util.logging.SmtpHandler;
import jeus.util.logging.SocketHandler;
import jeus.xml.binding.jeusDD.ConsoleHandlerType;
import jeus.xml.binding.jeusDD.FileHandlerType;
import jeus.xml.binding.jeusDD.HandlerType;
import jeus.xml.binding.jeusDD.LoggingLevelType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.SmtpHandlerType;
import jeus.xml.binding.jeusDD.SocketHandlerType;
import jeus.xml.binding.jeusDD.SystemLoggingType;
import jeus.xml.binding.jeusDD.UserHandlerType;

public class JeusLogService
extends J2EEManagedObjectSupport
implements JeusLogServiceMBean {
    private String permissionNamePrefix;

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object server) throws InstanceAlreadyExistsException {
        JeusLogService mo = new JeusLogService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "JeusLogService");
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        this.permissionNamePrefix = module.getPermissionName() + ".logger.";
        return module.getPermissionName() + ".logger";
    }

    public String getLogLevel(String loggerName) {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        String strLevel = null;
        Logger logger = JeusLogger.getLogger((String)loggerName);
        if (logger == null) {
            throw new RuntimeException(" Logger[" + loggerName + "] dose not exist");
        }
        Level level = logger.getLevel();
        boolean foundParentLevel = false;
        if (level == null) {
            while (!foundParentLevel && (logger = logger.getParent()) != null) {
                level = logger.getLevel();
                if (level == null) continue;
                foundParentLevel = true;
            }
        }
        if (level != null) {
            strLevel = level.toString();
        }
        return strLevel;
    }

    public void setLogLevel(String loggerName, String level, boolean forcedChildset) {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Level logLevel = JeusLevel.parse((String)level);
        if (forcedChildset) {
            JeusLogger[] loggers = JeusLogger.getChilden((String)loggerName);
            for (int i = 0; i < loggers.length; ++i) {
                JeusLogger jeusLogger = loggers[i];
                jeusLogger.resetLevelSetting();
            }
        }
        JeusLogger.getLogger((String)loggerName).setLevel(logLevel);
    }

    public void setLogHandler(String loggerName, String handlerName, boolean append) throws Exception {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Handler handler = (Handler)Class.forName(handlerName).newInstance();
        handler.setFormatter((Formatter)new SimpleFormatter(Collections.EMPTY_MAP));
        Logger logger = JeusLogger.getLogger((String)loggerName);
        if (!append) {
            Handler[] handlers = logger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                logger.removeHandler(handlers[i]);
            }
        }
        logger.addHandler(handler);
    }

    public boolean getUseParentHandlers(String loggerName) {
        ResourcePermission permission = new ResourcePermission(this.permissionNamePrefix + loggerName, "control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        if (logger == null) {
            throw new RuntimeException(" Logger[" + loggerName + "] dose not exist");
        }
        boolean isUseParentHandlers = logger.getUseParentHandlers();
        return isUseParentHandlers;
    }

    public void setUseParentHandlers(String loggerName, boolean useParentHandlers) {
        ResourcePermission permission = new ResourcePermission(this.permissionNamePrefix + loggerName, "control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        JeusLogger.getLogger((String)loggerName).setUseParentHandlers(useParentHandlers);
    }

    public SystemLoggingType getSystemLogging(String loggerName) throws JAXBException, UnsupportedEncodingException {
        ObjectFactory obj = new ObjectFactory();
        SystemLoggingType systemLogging = obj.createSystemLoggingType();
        Logger logger = JeusLogger.getLogger((String)loggerName);
        systemLogging.setLevel(LoggingLevelType.valueOf((String)logger.getLevel().toString()));
        if (logger.getFilter() != null) {
            systemLogging.setFilterClass(logger.getFilter().getClass().getName());
        }
        boolean useParentHandlers = logger.getUseParentHandlers();
        systemLogging.setUseParentHandlers(Boolean.valueOf(useParentHandlers));
        Handler[] handlers = logger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            HandlerType handlerType = obj.createHandlerType();
            systemLogging.setHandler(handlerType);
            List handlerList = handlerType.getConsoleHandlerOrFileHandlerOrSmtpHandler();
            this.createHandlerType(handlers, obj, handlerList);
        }
        if (useParentHandlers) {
            int ix2;
            int ix = 1;
            while ((ix2 = loggerName.indexOf(".", ix)) >= 0) {
                Handler[] parentHandlers;
                String pname = loggerName.substring(0, ix2);
                Logger parentLogger = Logger.getLogger(pname);
                if (!parentLogger.getUseParentHandlers()) {
                    systemLogging.getInfoMap().clear();
                }
                if ((parentHandlers = parentLogger.getHandlers()) != null && parentHandlers.length > 0) {
                    HandlerType handlerType = obj.createHandlerType();
                    List handlerList = handlerType.getConsoleHandlerOrFileHandlerOrSmtpHandler();
                    this.createHandlerType(parentHandlers, obj, handlerList);
                    systemLogging.getInfoMap().put(pname, handlerType);
                }
                ix = ix2 + 1;
            }
        }
        return systemLogging;
    }

    private void createHandlerType(Handler[] handlers, ObjectFactory obj, List handlerList) throws JAXBException {
        for (int i = 0; i < handlers.length; ++i) {
            JeusHandler handler = (JeusHandler)handlers[i];
            if (handler instanceof ConsoleHandler) {
                ConsoleHandler consoleObject = (ConsoleHandler)handler;
                ConsoleHandlerType consoleHandler = obj.createConsoleHandlerType();
                consoleHandler.setName(consoleObject.getName());
                consoleHandler.setLevel(LoggingLevelType.valueOf((String)consoleObject.getLevel().toString()));
                consoleHandler.setEncoding(consoleObject.getEncoding());
                if (consoleObject.getFilter() != null) {
                    consoleHandler.setFilterClass(consoleObject.getFilter().getClass().getName());
                }
                handlerList.add(consoleHandler);
                continue;
            }
            if (handler instanceof FileHandler) {
                FileHandler fileObject = (FileHandler)handler;
                FileHandlerType fileHandler = obj.createFileHandlerType();
                fileHandler.setName(fileObject.getName());
                fileHandler.setLevel(LoggingLevelType.valueOf((String)fileObject.getLevel().toString()));
                fileHandler.setEncoding(fileObject.getEncoding());
                if (fileObject.getFilter() != null) {
                    fileHandler.setFilterClass(fileObject.getFilter().getClass().getName());
                }
                fileHandler.setFileName(JeusLoggerConfiguration.detachTimePattern(fileObject.getValidDay(), fileObject.getFilePattern(), fileObject.getValidHour()));
                if (fileObject.getValidDay() > 0) {
                    fileHandler.setValidDay(Integer.valueOf(fileObject.getValidDay()));
                }
                if (fileObject.getValidHour() > 0) {
                    fileHandler.setValidHour(Integer.valueOf(fileObject.getValidHour()));
                }
                fileHandler.setBufferSize(Integer.valueOf(fileObject.getBufferSize()));
                fileHandler.setAppend(Boolean.valueOf(fileObject.isAppend()));
                handlerList.add(fileHandler);
                continue;
            }
            if (handler instanceof SmtpHandler) {
                SmtpHandler smtpObject = (SmtpHandler)handler;
                SmtpHandlerType smtpHandler = obj.createSmtpHandlerType();
                smtpHandler.setName(smtpObject.getName());
                smtpHandler.setLevel(LoggingLevelType.valueOf((String)smtpObject.getLevel().toString()));
                smtpHandler.setEncoding(smtpObject.getEncoding());
                if (smtpObject.getFilter() != null) {
                    smtpHandler.setFilterClass(smtpObject.getFilter().getClass().getName());
                }
                handlerList.add(smtpHandler);
                continue;
            }
            if (handler instanceof SocketHandler) {
                SocketHandler socketObject = (SocketHandler)handler;
                SocketHandlerType socketHandler = obj.createSocketHandlerType();
                socketHandler.setName(socketObject.getName());
                socketHandler.setLevel(LoggingLevelType.valueOf((String)socketObject.getLevel().toString()));
                socketHandler.setEncoding(socketObject.getEncoding());
                if (socketObject.getFilter() != null) {
                    socketHandler.setFilterClass(socketObject.getFilter().getClass().getName());
                }
                handlerList.add(socketHandler);
                continue;
            }
            UserHandlerType userHandler = obj.createUserHandlerType();
            userHandler.setName(handler.getName());
            userHandler.setLevel(LoggingLevelType.valueOf((String)handler.getLevel().getName()));
            userHandler.setEncoding(handler.getEncoding());
            userHandler.setFilterClass(handler.getFilter().getClass().getName());
            userHandler.setFormatterClass(handler.getFormatter().getClass().getName());
            handlerList.add(userHandler);
        }
    }

    public String[] getHandlerList(String loggerName) {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        ArrayList<String> list = new ArrayList<String>();
        Handler[] handers = JeusLogger.getLogger((String)loggerName).getHandlers();
        for (int i = 0; i < handers.length; ++i) {
            JeusHandler handler = (JeusHandler)handers[i];
            list.add(handler.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getFinalHandlerList(String loggerName) {
        JeusHandler handler;
        int i;
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        ArrayList<String> list = new ArrayList<String>();
        Logger logger = JeusLogger.getLogger((String)loggerName);
        Handler[] handers = logger.getHandlers();
        for (i = 0; i < handers.length; ++i) {
            handler = (JeusHandler)handers[i];
            list.add(handler.getName());
        }
        while (logger.getUseParentHandlers()) {
            logger = logger.getParent();
            handers = logger.getHandlers();
            for (i = 0; i < handers.length; ++i) {
                handler = (JeusHandler)handers[i];
                list.add(handler.getName());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public FileHandlerView[] getFinalFileHandlerList(String loggerName) {
        JeusHandler handler;
        int i;
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        ArrayList<FileHandlerView> list = new ArrayList<FileHandlerView>();
        Logger logger = JeusLogger.getLogger((String)loggerName);
        Handler[] handers = logger.getHandlers();
        for (i = 0; i < handers.length; ++i) {
            handler = (JeusHandler)handers[i];
            if (!(handler instanceof FileHandler)) continue;
            list.add(new FileHandlerView((FileHandler)handler, loggerName));
        }
        while (logger.getUseParentHandlers()) {
            logger = logger.getParent();
            loggerName = logger.getName();
            handers = logger.getHandlers();
            for (i = 0; i < handers.length; ++i) {
                handler = (JeusHandler)handers[i];
                if (!(handler instanceof FileHandler)) continue;
                list.add(new FileHandlerView((FileHandler)handler, loggerName));
            }
        }
        return list.toArray(new FileHandlerView[list.size()]);
    }

    public void addFileHanlder(String loggerName, FileHandlerType handler, String directory, String fileName) throws Exception {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        JeusLoggerConfiguration.addFileHandler((JeusLogger)JeusLogger.getLogger((String)loggerName), handler, directory, fileName, (JeusFormatter)new SimpleFormatter(), ErrorHandlerFactory.handlerFactory);
    }

    public void addConsoleHandler(String loggerName, ConsoleHandlerType handler) throws Exception {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        JeusLoggerConfiguration.addConsoleHandler((JeusLogger)JeusLogger.getLogger((String)loggerName), handler, (JeusFormatter)new SimpleFormatter());
    }

    public void addUserHandler(String loggerName, UserHandlerType handler) throws Exception {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        JeusLoggerConfiguration.addUserHandler((JeusLogger)JeusLogger.getLogger((String)loggerName), handler);
    }

    public void updateFileHanlder(String loggerName, FileHandlerType handlerType, String directory, String fileName) throws Exception {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        Handler handler = this.getHandler(logger, handlerType.getName());
        if (handler != null) {
            JeusLoggerConfiguration.setFileHandler(handlerType, directory, fileName, handler, (JeusFormatter)new SimpleFormatter());
        }
    }

    public void updateConsoleHandler(String loggerName, ConsoleHandlerType handlerType) throws Exception {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        Handler handler = this.getHandler(logger, handlerType.getName());
        if (handler != null) {
            JeusLoggerConfiguration.setConsoleHandler(handlerType, handler, (JeusFormatter)new SimpleFormatter());
        }
    }

    public void updateUserHandler(String loggerName, UserHandlerType handlerType) throws Exception {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        Handler handler = this.getHandler(logger, handlerType.getName());
        if (handler != null) {
            JeusLoggerConfiguration.setUserHandler(handlerType, handler);
        }
    }

    public void updateSmtpHandler(String loggerName, SmtpHandlerType handlerType) throws Exception {
        ResourcePermission permission = new ResourcePermission(this.permissionNamePrefix + loggerName, "control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        Handler handler = this.getHandler(logger, handlerType.getName());
        if (handler != null) {
            JeusLoggerConfiguration.setSmtpHandler(handlerType, handler, (JeusFormatter)new SimpleFormatter());
        }
    }

    public void updateSocketHandler(String loggerName, SocketHandlerType handlerType) throws Exception {
        ResourcePermission permission = new ResourcePermission(this.permissionNamePrefix + loggerName, "control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        Handler handler = this.getHandler(logger, handlerType.getName());
        if (handler != null) {
            JeusLoggerConfiguration.setSocketHandler(handlerType, handler, (JeusFormatter)new SimpleFormatter());
        }
    }

    public boolean removeHandler(String loggerName, String handlerId) {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        Handler handler = this.getHandler(logger, handlerId);
        if (handler != null) {
            logger.removeHandler(handler);
            return true;
        }
        return false;
    }

    public void setHandlerLevel(String loggerName, String handlerId, String level) {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        Handler handler = this.getHandler(logger, handlerId);
        if (handler == null) {
            throw new JeusRuntimeException("There is no handler for the name " + handlerId + " in the logger " + loggerName);
        }
        Level logLevel = JeusLevel.parse((String)level);
        handler.setLevel(logLevel);
    }

    public String[] getLoggerList() {
        return JeusLogger.getLoggerNames();
    }

    public void configureLogger(String loggerName, SystemLoggingType loggingType) throws Throwable, IllegalAccessException {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)loggerName);
        JeusLoggerConfiguration.configLogger(logger, loggingType);
    }

    public String getHandlerLevel(String loggerName, String handlerId) {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        Handler handler = this.getHandler(logger, handlerId);
        return handler.getLevel().toString();
    }

    public boolean isUseParentHandler(String loggerName) {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        return logger.getUseParentHandlers();
    }

    public String getParentLogger(String loggerName) {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        if (logger.getParent() != null) {
            return logger.getParent().getName();
        }
        return null;
    }

    public String getFileHandlerPattern(String loggerName, String fileHandlerName) {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        FileHandler handler = (FileHandler)this.getHandler(logger, fileHandlerName);
        return handler.getFilePattern();
    }

    public String getHandlerClassName(String loggerName, String handlerId) {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        Handler handler = this.getHandler(logger, handlerId);
        return handler.getClass().getName();
    }

    public String getFormatterClassName(String loggerName, String fileHandlerName) {
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + loggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        Logger logger = JeusLogger.getLogger((String)loggerName);
        FileHandler handler = (FileHandler)this.getHandler(logger, fileHandlerName);
        return handler.getFormatter().getClass().getName();
    }

    public void setAccessLoggerEnable(String contextGroupName, boolean isEnabled) {
        String accessLoggerName = "jeus.webaccess";
        if (contextGroupName != null) {
            accessLoggerName = accessLoggerName + "." + contextGroupName;
        }
        ResourcePermission permission = PermissionMaker.makeResourcePermission((String)(this.permissionNamePrefix + accessLoggerName), (String)"control");
        LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
        JeusLogger logger = (JeusLogger)AccessLogger.getLogger(accessLoggerName);
        if (isEnabled) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.SEVERE);
        }
    }

    private Handler getHandler(Logger logger, String handlerName) {
        Handler[] handers = logger.getHandlers();
        for (int i = 0; i < handers.length; ++i) {
            Handler handler = handers[i];
            if (!((JeusHandler)handler).getName().equals(handlerName)) continue;
            return handler;
        }
        throw new JeusRuntimeException("There is no handler for the name " + handlerName + " in the logger " + logger.getName());
    }

    public boolean isConfigurable(String loggerName) {
        if (loggerName.equals("jeus")) {
            return true;
        }
        HashSet configurableLoggers = JeusLogger.getConfigurableLoggers();
        for (String confLoggerName : configurableLoggers) {
            if (!confLoggerName.equals(loggerName)) continue;
            return true;
        }
        return false;
    }
}

