/*
 * Decompiled with CFR 0.152.
 */
package jeus.service.archive.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Vector;
import jeus.service.archive.parser.JavaCharStream;
import jeus.service.archive.parser.ParseException;
import jeus.service.archive.parser.PermissionParseException;
import jeus.service.archive.parser.PermissionParserConstants;
import jeus.service.archive.parser.PermissionParserTokenManager;
import jeus.service.archive.parser.Token;

public class PermissionParser
implements PermissionParserConstants {
    public PermissionParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[3];
    private static int[] jj_la1_0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static ArrayList parse(String queryString) throws PermissionParseException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(queryString.getBytes());
            PermissionParser parser = new PermissionParser(is);
            return parser.query();
        }
        catch (Throwable t) {
            throw new PermissionParseException("exception occurred for " + queryString, t);
        }
    }

    public static void main(String[] args) {
        try {
            ArrayList list = PermissionParser.parse("grant {\n permission java.security.SecurityPermission \"Security.insertProvider.*\";\n permission java.io.FilePermission \"/home/Alice\", \"read, write\";\n permission java.io.FilePermission \"${user.home}${/}*\", \"read\";\n }");
            for (int i = 0; i < list.size(); ++i) {
                String[] item = (String[])list.get(i);
                System.out.println("classname : " + item[0] + ", name = " + item[1] + ", action : " + item[2]);
            }
        }
        catch (PermissionParseException ex) {
            ex.printStackTrace();
        }
    }

    public final ArrayList query() throws ParseException {
        ArrayList<String[]> permissionList = new ArrayList<String[]>();
        String name = null;
        String action = null;
        this.jj_consume_token(13);
        this.jj_consume_token(5);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(14);
            Token t = this.jj_consume_token(15);
            String permissionClassName = t.image;
            block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    t = this.jj_consume_token(10);
                    name = t.image.substring(1, t.image.length() - 1);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: {
                            this.jj_consume_token(7);
                            t = this.jj_consume_token(10);
                            action = t.image.substring(1, t.image.length() - 1);
                            break block3;
                        }
                    }
                    this.jj_la1[1] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                }
            }
            this.jj_consume_token(8);
            permissionList.add(new String[]{permissionClassName, name, action});
        }
        this.jj_consume_token(6);
        this.jj_consume_token(8);
        return permissionList;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{16384, 128, 1024};
    }

    public PermissionParser(InputStream stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new PermissionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public PermissionParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new PermissionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public PermissionParser(PermissionParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(PermissionParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[16];
        for (i = 0; i < 16; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 3; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 16; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        PermissionParser.jj_la1_0();
    }
}

