/*
 * Decompiled with CFR 0.152.
 */
package jeus.service.descriptor;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.util.JeusException;
import jeus.util.StringUtil;
import jeus.util.UnicodeInputStream;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_Manager1;
import jeus.xml.binding.BindingHelper;
import jeus.xml.binding.DescriptorBinder;
import jeus.xml.binding.JeusJAXBException;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.j2ee.ObjectFactory;
import jeus.xml.binding.util.JAXBContextFactory;
import jeus.xml.util.XMLSurgeon;
import org.xml.sax.SAXException;

public abstract class DescriptorFile {
    protected String contextPackageName;
    protected String descriptorDirectory;
    protected String descriptorFileName;
    public static final String NAMESPACE = "http://www.tmaxsoft.com/xml/ns/jeus";
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.service.descriptor");
    protected static ObjectFactory j2eeObjectFactory = ObjectFactoryHelper.getJ2EEObjectFactory();
    protected static jeus.xml.binding.jeusDD.ObjectFactory jeusDDObjectFactory = ObjectFactoryHelper.getJeusDDObjectFactory();
    private SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

    protected DescriptorFile(String contextPackageName, String descriptorDirectory, String descriptorFileName) {
        this.contextPackageName = contextPackageName;
        this.descriptorDirectory = descriptorDirectory;
        this.descriptorFileName = descriptorFileName;
    }

    public String getDeploymentDescriptorPath() {
        if (this.descriptorDirectory != null) {
            return this.descriptorDirectory + File.separator + this.descriptorFileName;
        }
        return this.descriptorFileName;
    }

    protected String getSchemaFileName() {
        return null;
    }

    public boolean shouldValidateWithSchema() {
        return this.getSchemaFileName() != null;
    }

    public Schema getSchema() throws SAXException {
        String xsdFileName = this.getSchemaFileName();
        Schema schema = null;
        if (xsdFileName != null) {
            schema = this.loadSchema(xsdFileName);
        }
        return schema;
    }

    private Schema loadSchema(String xsdFileName) throws SAXException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URL systemResource = contextClassLoader.getResource("jeus/xml/schemas/" + xsdFileName);
        if (systemResource == null) {
            systemResource = contextClassLoader.getResource("jeus/xml/schemas/" + xsdFileName.substring(0, xsdFileName.indexOf(".xsd")) + "_jeus.xsd");
            if (systemResource == null) {
                return null;
            }
            return this.schemaFactory.newSchema(systemResource);
        }
        return this.schemaFactory.newSchema(systemResource);
    }

    public String getContextPackageName() {
        return this.contextPackageName;
    }

    public InputStream getSchemaBasedStream(InputStream is) throws IOException {
        return DescriptorFile.getUnicodeInputStream(is);
    }

    protected static InputStream getUnicodeInputStream(InputStream is) {
        UnicodeInputStream uis = new UnicodeInputStream(is, null);
        uis.getEncoding();
        return uis;
    }

    public final Object getDeploymentDescriptor(AbstractArchive archive) throws IOException, JAXBException {
        try {
            Object root = BindingHelper.getDescriptor(archive, this, null);
            this.postUnmarshal(root);
            return root;
        }
        catch (JeusJAXBException ex) {
            this.logException((Exception)((Object)ex));
            throw ex;
        }
        catch (JAXBException ex) {
            this.logException((Exception)((Object)ex));
            throw ex;
        }
    }

    public final DescriptorBinder getDeploymentDescriptorWithBinder(AbstractArchive archive) throws IOException, JAXBException {
        try {
            DescriptorBinder binder = BindingHelper.getDescriptorWithBinder(archive, this, null);
            this.postUnmarshal(binder.getObject());
            return binder;
        }
        catch (JeusJAXBException ex) {
            this.logException((Exception)((Object)ex));
            throw ex;
        }
        catch (JAXBException ex) {
            this.logException((Exception)((Object)ex));
            throw ex;
        }
    }

    public final Object getDeploymentDescriptor(InputStream is) throws JeusJAXBException, JAXBException {
        try {
            Object obj = BindingHelper.getDescriptor(is, this, null);
            this.postUnmarshal(obj);
            return obj;
        }
        catch (JeusJAXBException ex) {
            this.logException((Exception)((Object)ex));
            throw ex;
        }
        catch (JAXBException ex) {
            this.logException((Exception)((Object)ex));
            throw ex;
        }
    }

    public final DescriptorBinder getDeploymentDescriptorWithBinder(InputStream is) throws JeusJAXBException, JAXBException {
        try {
            DescriptorBinder binder = BindingHelper.getDescriptorWithBinder(is, this, null);
            this.postUnmarshal(binder.getObject());
            return binder;
        }
        catch (JeusJAXBException ex) {
            this.logException((Exception)((Object)ex));
            throw ex;
        }
        catch (JAXBException ex) {
            this.logException((Exception)((Object)ex));
            throw ex;
        }
    }

    public Object newDeploymentDescriptor() throws JAXBException {
        return null;
    }

    protected void logException(Exception ex) {
        if (logger.isLoggable(JeusMessage_Manager1._522_LEVEL)) {
            logger.log(JeusMessage_Manager1._522_LEVEL, JeusMessage_Manager1._522, (Object)this.getDeploymentDescriptorPath(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDeploymentDescriptor(String descriptorString) throws JAXBException, IOException {
        String encoding = StringUtil.getEncodingAndXmlDecl((String)descriptorString);
        ByteArrayInputStream is = new ByteArrayInputStream(descriptorString.getBytes(encoding));
        try {
            Object object = this.getDeploymentDescriptor(is);
            return object;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorBinder getDeploymentDescriptorWithBinder(String descriptorString) throws JAXBException, IOException {
        String encoding = StringUtil.getEncodingAndXmlDecl((String)descriptorString);
        ByteArrayInputStream is = new ByteArrayInputStream(descriptorString.getBytes(encoding));
        try {
            DescriptorBinder descriptorBinder = this.getDeploymentDescriptorWithBinder(is);
            return descriptorBinder;
        }
        finally {
            is.close();
        }
    }

    public void postUnmarshal(Object root) throws JAXBException {
    }

    public Object preMarshal(Object root) throws JeusException, JAXBException {
        return root;
    }

    public InputStream getDescriptorStream(AbstractArchive jarArchive) throws IOException {
        String descriptorPath = this.getDeploymentDescriptorPath();
        InputStream is = jarArchive.getEntry(descriptorPath);
        if (is != null) {
            return is;
        }
        if (this.descriptorDirectory != null) {
            descriptorPath = this.descriptorDirectory.replace(File.separatorChar, '/') + "/" + this.descriptorFileName;
            is = jarArchive.getEntry(descriptorPath);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescriptorString(String modulePath) throws IOException {
        File module = new File(modulePath);
        AbstractArchive archive = null;
        try {
            if (module.isDirectory()) {
                archive = FileArchiveFactory.openArchiveStatic((String)modulePath);
                String string = this.getDescriptorString(archive);
                return string;
            }
            archive = JarArchiveFactory.openArchiveStatic((String)modulePath);
            String string = this.getDescriptorString(archive);
            return string;
        }
        finally {
            if (archive != null) {
                archive.close();
            }
        }
    }

    public boolean existsDescriptorFile(AbstractArchive archive) {
        try {
            return archive.contains(this.getDeploymentDescriptorPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean existsDescriptorFile() {
        File file = new File(this.getDeploymentDescriptorPath());
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescriptorString(AbstractArchive archive) throws IOException {
        InputStream is = null;
        try {
            is = this.getDescriptorStream(archive);
            String string = this.getDescriptorString(is);
            return string;
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
        }
    }

    public String getDescriptorString(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BufferedOutputStream bufos = new BufferedOutputStream(os);
        byte[] buf = new byte[4096];
        int len = 0;
        try {
            while (len != -1) {
                len = is.read(buf, 0, buf.length);
                if (len == -1) continue;
                bufos.write(buf, 0, len);
                bufos.flush();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            os.close();
            bufos.close();
        }
        return "\n" + os.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshalDescriptor(Object jaxbObject, AbstractArchive archive) throws JAXBException, IOException, SAXException {
        OutputStream os = archive.addEntry(this.getDeploymentDescriptorPath());
        try {
            this.marshalDescriptor(jaxbObject, os);
        }
        finally {
            os.close();
        }
    }

    public String marshalDescriptor(Object jaxbObject) throws JAXBException, IOException {
        Object cloned = this.preMarshal(jaxbObject);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.marshalDescriptor(cloned, os);
            String string = os.toString(XMLSurgeon.getEncoding(jaxbObject));
            return string;
        }
        catch (Throwable e) {
            throw new JeusJAXBException(JeusMessage_Manager.MGR_59, e);
        }
        finally {
            os.close();
        }
    }

    public void marshalDescriptor(Object cloned, OutputStream os) throws JAXBException, IOException, SAXException {
        JAXBContext jc = JAXBContextFactory.getContext(this.contextPackageName);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        XMLSurgeon.leave(cloned, m, os, true);
    }

    public File getDeploymentDescriptorFile(FileArchive archive) {
        return archive.getFile(this.getDeploymentDescriptorPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeDescriptor(Object jaxbObject, AbstractArchive archive) throws IOException {
        OutputStream out = archive.addEntry(this.getDeploymentDescriptorPath() + ".ser");
        try {
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeObject(jaxbObject);
            objOut.close();
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserializeDescriptor(AbstractArchive archive) throws IOException, ClassNotFoundException {
        InputStream in = archive.getEntry(this.getDeploymentDescriptorPath() + ".ser");
        if (in == null) {
            return null;
        }
        try {
            ObjectInputStream objIn = new ObjectInputStream(in);
            Object jaxbObject = objIn.readObject();
            objIn.close();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Read " + this.getDeploymentDescriptorPath() + ".ser");
            }
            Object object = jaxbObject;
            return object;
        }
        finally {
            in.close();
        }
    }
}

