/*
 * Decompiled with CFR 0.152.
 */
package jeus.service.descriptor;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import jeus.security.util.EncryptionUtil;
import jeus.server.ConfigFile;
import jeus.service.descriptor.ConfigDescriptorFile;
import jeus.util.JeusException;
import jeus.xml.binding.jeusDD.DataSourceType;
import jeus.xml.binding.jeusDD.DatabaseType;
import jeus.xml.binding.jeusDD.EngineContainerType;
import jeus.xml.binding.jeusDD.ExternalSourceType;
import jeus.xml.binding.jeusDD.JaxrEntryType;
import jeus.xml.binding.jeusDD.JaxrSourceType;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.JmsSourceType;
import jeus.xml.binding.jeusDD.MailEntryType;
import jeus.xml.binding.jeusDD.MailSourceType;
import jeus.xml.binding.jeusDD.ResourceType;
import jeus.xml.binding.jeusDD.SystemLoggingType;
import jeus.xml.binding.jeusDD.TypePropertyType;
import jeus.xml.binding.jeusDD.UrlEntryType;
import jeus.xml.binding.jeusDD.UrlSourceType;
import jeus.xml.binding.jeusDD.VendorType;

public class JeusMainDescriptorFile
extends ConfigDescriptorFile {
    public static final String packageName = "jeus.xml.binding.jeusDD";
    public static final String xsdFileName = "jeus-main.xsd";
    public static final String rootElement = "jeus-system";
    public static final String descFileName = "JEUSMain.xml";
    private Vector exportNameList = new Vector();

    public JeusMainDescriptorFile(String nodeName, ConfigFile configFile) {
        super(packageName, nodeName, descFileName, configFile);
    }

    private JeusMainDescriptorFile() {
        super(packageName);
    }

    protected String getSchemaFileName() {
        return xsdFileName;
    }

    public static Object getDeploymentDescriptorStatic(String descriptorString) throws JAXBException, IOException {
        JeusMainDescriptorFile file = new JeusMainDescriptorFile();
        return file.getDeploymentDescriptor(descriptorString);
    }

    public static String marshalDescriptorStatic(Object descriptor) throws JAXBException, IOException {
        JeusMainDescriptorFile file = new JeusMainDescriptorFile();
        return file.marshalDescriptor(descriptor);
    }

    public void postUnmarshal(Object root) {
        try {
            JeusSystemType systemType = (JeusSystemType)root;
            this.checkSystemLoggingDuplicate(systemType);
            systemType.fillDefault();
            ResourceType resource = systemType.getResource();
            if (resource != null) {
                JaxrSourceType jaxrSourceType;
                ExternalSourceType externalSourceType;
                UrlSourceType urlSourceType;
                MailSourceType mailSourceType;
                DataSourceType dataSourceType = resource.getDataSource();
                if (dataSourceType != null) {
                    List databases = dataSourceType.getDatabase();
                    this.clearExportNameList();
                    for (int i = 0; i < databases.size(); ++i) {
                        DatabaseType databaseType = (DatabaseType)databases.get(i);
                        this.checkDuplicatedName(databaseType.getExportName());
                        if (databaseType.getVendor() == VendorType.OTHERS) {
                            List properties = databaseType.getProperty();
                            Iterator iter = properties.iterator();
                            TypePropertyType property = null;
                            while (iter.hasNext() && !(property = (TypePropertyType)iter.next()).getName().equalsIgnoreCase("Password")) {
                            }
                            if (property == null) continue;
                            property.setValue(property.getValue());
                            continue;
                        }
                        databaseType.setPassword(databaseType.getPassword());
                    }
                }
                if ((mailSourceType = resource.getMailSource()) != null) {
                    this.clearExportNameList();
                    List mailEntryList = mailSourceType.getMailEntry();
                    for (int i = 0; i < mailEntryList.size(); ++i) {
                        MailEntryType entry = (MailEntryType)mailEntryList.get(i);
                        this.checkDuplicatedName(entry.getExportName());
                    }
                }
                if ((urlSourceType = resource.getUrlSource()) != null) {
                    this.clearExportNameList();
                    List urlEntryList = urlSourceType.getUrlEntry();
                    for (int i = 0; i < urlEntryList.size(); ++i) {
                        UrlEntryType entry = (UrlEntryType)urlEntryList.get(i);
                        this.checkDuplicatedName(entry.getExportName());
                    }
                }
                if ((externalSourceType = resource.getExternalSource()) != null) {
                    this.clearExportNameList();
                    List jmsSourceList = externalSourceType.getJmsSource();
                    for (int i = 0; i < jmsSourceList.size(); ++i) {
                        JmsSourceType source = (JmsSourceType)jmsSourceList.get(i);
                        this.checkDuplicatedName(source.getExportName());
                    }
                }
                if ((jaxrSourceType = resource.getJaxrSource()) != null) {
                    this.clearExportNameList();
                    List jaxrEntryList = jaxrSourceType.getJaxrEntry();
                    for (int i = 0; i < jaxrEntryList.size(); ++i) {
                        JaxrEntryType jaxrEntry = (JaxrEntryType)jaxrEntryList.get(i);
                        this.checkDuplicatedName(jaxrEntry.getExportName());
                    }
                }
                this.clearExportNameList();
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException("Internal Exception", e);
        }
    }

    private JeusSystemType checkSystemLoggingDuplicate(JeusSystemType systemType) throws JAXBException {
        List nodes = systemType.getNode();
        for (int i = 0; i < nodes.size(); ++i) {
            JeusNodeType jeusNodeType = (JeusNodeType)nodes.get(i);
            this.checkDuplicateSystemLoggingName(jeusNodeType.getSystemLogging(), jeusNodeType.getName());
            List containers = jeusNodeType.getEngineContainer();
            for (int j = 0; j < containers.size(); ++j) {
                EngineContainerType engineContainerType = (EngineContainerType)containers.get(j);
                this.checkDuplicateSystemLoggingName(engineContainerType.getSystemLogging(), engineContainerType.getName());
            }
        }
        return systemType;
    }

    private void checkDuplicateSystemLoggingName(List systemLogging, String categoryName) throws JAXBException {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < systemLogging.size(); ++i) {
            SystemLoggingType systemLoggingType = (SystemLoggingType)systemLogging.get(i);
            String name = systemLoggingType.getName();
            if (names.add(name)) continue;
            throw new JAXBException("The logging name should be unique : " + name + ", for the node or container : " + categoryName);
        }
        if (names.contains(null) && names.contains("jeus")) {
            throw new JAXBException("The logging name 'jeus' cannot be specified with the empty name which implies 'jeus' loggerfor the node or container : " + categoryName);
        }
    }

    private void clearExportNameList() {
        this.exportNameList.clear();
    }

    private void checkDuplicatedName(String exportName) throws JAXBException {
        if (this.exportNameList.size() == 0) {
            this.exportNameList.add(exportName);
        } else {
            for (String listEle : this.exportNameList) {
                if (!listEle.equals(exportName)) continue;
                throw new JAXBException("Export name shoud be unique ! - " + exportName);
            }
        }
    }

    public Object preMarshal(Object root) throws JeusException, JAXBException {
        if (root instanceof JAXBElement) {
            root = ((JAXBElement)root).getValue();
        }
        JeusSystemType systemType = (JeusSystemType)root;
        JeusSystemType cloned = (JeusSystemType)systemType.cloneType();
        cloned.cleanDefault();
        this.checkSystemLoggingDuplicate(cloned);
        ResourceType resource = cloned.getResource();
        if (resource != null) {
            JaxrSourceType jaxrSourceType;
            ExternalSourceType externalSourceType;
            UrlSourceType urlSourceType;
            MailSourceType mailSourceType;
            DataSourceType dataSourceType = resource.getDataSource();
            if (dataSourceType != null) {
                List databases = dataSourceType.getDatabase();
                this.clearExportNameList();
                for (int i = 0; i < databases.size(); ++i) {
                    String encodedPass;
                    DatabaseType databaseType = (DatabaseType)databases.get(i);
                    this.checkDuplicatedName(databaseType.getExportName());
                    String plainPass = databaseType.getPassword();
                    if (plainPass != null) {
                        encodedPass = EncryptionUtil.encryptPassword(plainPass);
                        databaseType.setPassword(encodedPass);
                    } else if (databaseType.isSetPassword()) {
                        databaseType.setPassword("");
                    }
                    if (databaseType.getVendor() != VendorType.OTHERS) continue;
                    List properties = databaseType.getProperty();
                    Iterator iter = properties.iterator();
                    TypePropertyType property = null;
                    while (iter.hasNext() && !(property = (TypePropertyType)iter.next()).getName().equalsIgnoreCase("Password")) {
                    }
                    if (property == null) continue;
                    plainPass = property.getValue();
                    encodedPass = EncryptionUtil.encryptPassword(plainPass);
                    property.setValue(encodedPass);
                }
            }
            if ((mailSourceType = resource.getMailSource()) != null) {
                this.clearExportNameList();
                List mailEntryList = mailSourceType.getMailEntry();
                for (int i = 0; i < mailEntryList.size(); ++i) {
                    MailEntryType entry = (MailEntryType)mailEntryList.get(i);
                    this.checkDuplicatedName(entry.getExportName());
                }
            }
            if ((urlSourceType = resource.getUrlSource()) != null) {
                this.clearExportNameList();
                List urlEntryList = urlSourceType.getUrlEntry();
                for (int i = 0; i < urlEntryList.size(); ++i) {
                    UrlEntryType entry = (UrlEntryType)urlEntryList.get(i);
                    this.checkDuplicatedName(entry.getExportName());
                }
            }
            if ((externalSourceType = resource.getExternalSource()) != null) {
                this.clearExportNameList();
                List jmsSourceList = externalSourceType.getJmsSource();
                for (int i = 0; i < jmsSourceList.size(); ++i) {
                    JmsSourceType source = (JmsSourceType)jmsSourceList.get(i);
                    this.checkDuplicatedName(source.getExportName());
                }
            }
            if ((jaxrSourceType = resource.getJaxrSource()) != null) {
                this.clearExportNameList();
                List jaxrEntryList = jaxrSourceType.getJaxrEntry();
                for (int i = 0; i < jaxrEntryList.size(); ++i) {
                    JaxrEntryType jaxrEntry = (JaxrEntryType)jaxrEntryList.get(i);
                    this.checkDuplicatedName(jaxrEntry.getExportName());
                }
            }
            this.clearExportNameList();
        }
        return cloned;
    }
}

