/*
 * Decompiled with CFR 0.152.
 */
package jeus.service.library;

import jeus.service.library.VersionInfo;
import jeus.xml.binding.jeusDD.LibraryRefType;
import jeus.xml.binding.jeusDD.LibraryRefVersionType;

public class LibraryRef {
    private String libraryName;
    private VersionInfo specificationVersion;
    private VersionInfo implementationVersion;
    private boolean specificationVersionExactMatch;
    private boolean implementationVersionExactMatch;
    private boolean failOnError;

    public LibraryRef(String libraryName, String specificationVersion, String implementationVersion) {
        this(libraryName, specificationVersion, implementationVersion, false, false, false);
    }

    public LibraryRef(String libraryName, String specificationVersion, String implementationVersion, boolean exactMatchSpecVersion, boolean exactMatchImplVersion, boolean failOnError) {
        this.libraryName = libraryName;
        this.specificationVersion = new VersionInfo(specificationVersion);
        this.implementationVersion = new VersionInfo(implementationVersion);
        this.specificationVersionExactMatch = exactMatchSpecVersion;
        this.implementationVersionExactMatch = exactMatchImplVersion;
    }

    public LibraryRef(LibraryRefType r) {
        this.libraryName = r.getLibraryName();
        this.failOnError = r.isSetFailonerror() && r.isFailonerror();
        LibraryRefVersionType specVersion = r.getSpecificationVersion();
        if (specVersion != null) {
            this.specificationVersion = new VersionInfo(specVersion.getValue());
            this.specificationVersionExactMatch = specVersion.isSetExactMatch() && specVersion.isExactMatch();
        } else {
            this.specificationVersion = VersionInfo.UNSPECIFIED_VERSION;
        }
        LibraryRefVersionType implVersion = r.getImplementationVersion();
        if (implVersion != null) {
            this.implementationVersion = new VersionInfo(implVersion.getValue());
            this.implementationVersionExactMatch = implVersion.isSetExactMatch() && implVersion.isExactMatch();
        } else {
            this.implementationVersion = VersionInfo.UNSPECIFIED_VERSION;
        }
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public VersionInfo getSpecificationVersion() {
        return this.specificationVersion;
    }

    public VersionInfo getImplementationVersion() {
        return this.implementationVersion;
    }

    public boolean isSpecificationVersionExactMatch() {
        return this.specificationVersionExactMatch;
    }

    public boolean isImplementationVersionExactMatch() {
        return this.implementationVersionExactMatch;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public String toString() {
        return "[library-ref:name=" + this.libraryName + ", specVersion=" + this.specificationVersion + (this.specificationVersionExactMatch ? " exact" : "") + ", implVersion=" + this.implementationVersion + (this.implementationVersionExactMatch ? " exact" : "") + "]";
    }
}

