/*
 * Decompiled with CFR 0.152.
 */
package jeus.service.library;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionInfo
implements Comparable<VersionInfo> {
    public static final String UNSPECIFIED_VERSION_STRING = "0";
    public static final VersionInfo UNSPECIFIED_VERSION = new VersionInfo(null);
    private final String version;
    private boolean parsed;
    private List<Integer> fractionPart;
    private String stringPart;

    public VersionInfo(String version) {
        this.version = version == null ? UNSPECIFIED_VERSION_STRING : version;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(VersionInfo that) {
        this.parse();
        that.parse();
        int minSize = Math.min(this.fractionPart.size(), that.fractionPart.size());
        for (int i = 0; i < minSize; ++i) {
            int b;
            int a = this.fractionPart.get(i);
            if (a > (b = that.fractionPart.get(i).intValue())) {
                return 1;
            }
            if (a >= b) continue;
            return -1;
        }
        if (this.fractionPart.size() > minSize) {
            return 1;
        }
        if (that.fractionPart.size() > minSize) {
            return -1;
        }
        if (this.stringPart == null) {
            if (that.stringPart == null) {
                return 0;
            }
            return -1;
        }
        if (that.stringPart == null) {
            return 1;
        }
        return this.stringPart.compareTo(that.stringPart);
    }

    private synchronized void parse() {
        int i;
        if (this.parsed) {
            return;
        }
        this.fractionPart = new ArrayList<Integer>(4);
        int startInt = -1;
        int startString = -1;
        for (i = 0; i < this.version.length(); ++i) {
            char c = this.version.charAt(i);
            if (Character.isDigit(c)) {
                if (startInt != -1) continue;
                startInt = i;
                continue;
            }
            if (startInt != -1) {
                this.fractionPart.add(Integer.parseInt(this.version.substring(startInt, i)));
                startInt = -1;
            }
            if ('.' == c) continue;
            startString = i;
            break;
        }
        if (startInt != -1) {
            this.fractionPart.add(Integer.parseInt(this.version.substring(startInt, i)));
        } else if (startString != -1) {
            this.stringPart = this.version.substring(startString, this.version.length());
        }
        this.parsed = true;
    }

    public String toString() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionInfo that = (VersionInfo)o;
        return this.version.equals(that.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }
}

