/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.cache.base;

import java.io.Serializable;
import javax.swing.event.EventListenerList;
import jeus.servlet.cache.base.Cache;
import jeus.servlet.cache.base.CacheConfig;
import jeus.servlet.cache.base.FinalizationException;
import jeus.servlet.cache.base.LifecycleAware;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer11;

public abstract class AbstractCacheAdministrator
implements Serializable {
    protected static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.cache");
    public static final String CACHE_MEMORY_KEY = "cache.memory";
    public static final String CACHE_CAPACITY_KEY = "cache.capacity";
    public static final String CACHE_ALGORITHM_KEY = "cache.algorithm";
    public static final String CACHE_DISK_UNLIMITED_KEY = "cache.unlimited.disk";
    public static final String CACHE_BLOCKING_KEY = "cache.blocking";
    public static final String PERSISTENCE_CLASS_KEY = "cache.persistence.class";
    public static final String CACHE_PERSISTENCE_OVERFLOW_KEY = "cache.persistence.overflow.only";
    public static final String CACHE_ENTRY_EVENT_LISTENERS_KEY = "cache.event.listeners";
    protected EventListenerList listenerList = new EventListenerList();

    protected AbstractCacheAdministrator() {
    }

    protected Cache configureStandardListeners(Cache cache) {
        CacheConfig cacheConfig = cache.getCacheConfig();
        return cache;
    }

    protected void finalizeListeners(Cache cache) {
        if (cache == null) {
            return;
        }
        Object[] listeners = cache.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (!(listeners[i + 1] instanceof LifecycleAware)) continue;
            try {
                ((LifecycleAware)listeners[i + 1]).finialize();
                continue;
            }
            catch (FinalizationException e) {
                if (!logger.isLoggable(JeusMessage_WebContainer11._110010_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer11._110010_LEVEL, JeusMessage_WebContainer11._110010, (Throwable)e);
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer11._11009_LEVEL)) {
            logger.log(JeusMessage_WebContainer11._11009_LEVEL, JeusMessage_WebContainer11._11009);
        }
    }

    public JeusLogger getLogger() {
        if (logger != null) {
            return logger;
        }
        return (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.cache");
    }
}

