/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.cache.base;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;

public class Config
implements Serializable {
    private static final String PROPERTIES_FILENAME = "/jeuscache.properties";
    private Properties properties = null;

    public Config() {
        this(null);
    }

    public Config(Properties p) {
        if (p == null) {
            this.loadProps();
        } else {
            this.properties = p;
        }
    }

    public String getProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (this.properties == null) {
            return null;
        }
        String value = this.properties.getProperty(key);
        return value;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Object get(Object key) {
        return this.properties.get(key);
    }

    public void set(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (value == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        this.properties = new Properties();
        InputStream in = null;
        try {
            in = Config.class.getResourceAsStream(PROPERTIES_FILENAME);
            this.properties.load(in);
        }
        catch (Exception e) {
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }
}

